/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBDataSource
extends OMDataSourceExtBase {
    private static final Log log = LogFactory.getLog(JAXBDataSource.class);
    Object jaxb;
    JAXBDSContext context;

    public JAXBDataSource(Object jaxb, JAXBDSContext context) {
        this.jaxb = jaxb;
        this.context = context;
    }

    public void close() {
    }

    public OMDataSourceExt copy() {
        return new JAXBDataSource(this.jaxb, this.context);
    }

    public Object getObject() {
        return this.jaxb;
    }

    public JAXBDSContext getContext() {
        return this.context;
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            String encoding = "utf-8";
            ByteArrayInputStream is = new ByteArrayInputStream(this.getXMLBytes(encoding));
            return StAXUtils.createXMLStreamReader(is, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        block2: {
            MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
            this.serialize(writer);
            writer.flush();
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Catching and swallowing exception " + e);
            }
        }
    }

    public void serialize(Writer writerTarget, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writerTarget));
        writer.setOutputFormat(format);
        this.serialize(writer);
        writer.flush();
        writer.close();
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            this.context.marshal(this.jaxb, xmlWriter);
        }
        catch (JAXBException je) {
            if (log.isDebugEnabled()) {
                try {
                    log.debug("JAXBContext for marshal failure:" + this.context.getJAXBContext(this.context.getClassLoader()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new XMLStreamException(je);
        }
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriterWithOS writer = new XMLStreamWriterWithOS(baos, encoding);
            this.serialize(writer);
            writer.flush();
            writer.close();
            return baos.toByteArray();
        }
        catch (XMLStreamException e) {
            throw new OMException(e);
        }
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }
}

