/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.resolver.AARBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.AARFileBasedURIResolver;
import org.apache.axis2.deployment.resolver.WarBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.WarFileBasedURIResolver;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.WSDL11ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAllAxisServicesBuilder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveReader
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog(ArchiveReader.class);

    public ArrayList<AxisService> buildServiceGroup(InputStream zin, DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, HashMap<String, AxisService> wsdlServices, ConfigurationContext configCtx) throws XMLStreamException, AxisFault {
        OMElement rootElement = this.buildServiceDescription(zin, configCtx);
        return this.buildServiceGroup(rootElement, currentFile, axisServiceGroup, wsdlServices, configCtx);
    }

    public ArrayList<AxisService> buildServiceGroup(OMElement serviceMetaData, DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, Map<String, AxisService> wsdlServices, ConfigurationContext configCtx) throws XMLStreamException, AxisFault {
        String elementName = serviceMetaData.getLocalName();
        if ("service".equals(elementName)) {
            AxisService axisService = null;
            String serviceName = DescriptionBuilder.getShortFileName(currentFile.getName());
            if (serviceName != null) {
                axisService = wsdlServices.get(serviceName);
            }
            if (axisService == null) {
                axisService = wsdlServices.get(DescriptionBuilder.getShortFileName(currentFile.getName()));
            }
            if (axisService == null) {
                axisService = new AxisService(serviceName);
            } else {
                axisService.setWsdlFound(true);
                axisService.setCustomWsdl(true);
            }
            axisService.setParent(axisServiceGroup);
            axisService.setClassLoader(currentFile.getClassLoader());
            ServiceBuilder serviceBuilder = new ServiceBuilder(configCtx, axisService);
            serviceBuilder.setWsdlServiceMap(wsdlServices);
            AxisService service = serviceBuilder.populateService(serviceMetaData);
            ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
            serviceList.add(service);
            return serviceList;
        }
        if ("serviceGroup".equals(elementName)) {
            ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(serviceMetaData, wsdlServices, configCtx);
            return groupBuilder.populateServiceGroup(axisServiceGroup);
        }
        throw new AxisFault("Invalid services.xml found");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<AxisService> processServiceGroup(String filename, DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, boolean extractService, HashMap<String, AxisService> wsdlServices, ConfigurationContext configCtx) throws AxisFault {
        block26: {
            block22: {
                if (extractService) break block26;
                zin = null;
                fin = null;
                try {
                    try {
                        fin = new FileInputStream(filename);
                        zin = new ZipInputStream(fin);
                        do {
                            if ((entry = zin.getNextEntry()) == null) throw new DeploymentException(Messages.getMessage("servicexmlnotfound", filename));
                        } while (!entry.getName().equalsIgnoreCase("META-INF/services.xml"));
                        axisServiceGroup.setServiceGroupName(DescriptionBuilder.getShortFileName(currentFile.getName()));
                        var10_16 = this.buildServiceGroup(zin, currentFile, axisServiceGroup, wsdlServices, configCtx);
                        var12_17 = null;
                        if (zin == null) break block22;
                    }
                    catch (Exception e) {
                        throw new DeploymentException(e);
                    }
                }
                catch (Throwable var11_21) {
                    var12_18 = null;
                    if (zin != null) {
                        try {
                            zin.close();
                        }
                        catch (IOException e) {
                            ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                        }
                    }
                    if (fin == null) throw var11_21;
                    try {
                        fin.close();
                        throw var11_21;
                    }
                    catch (IOException e) {
                        ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                    }
                    throw var11_21;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 128->136)] { 
lbl38:
                // 1 sources

                zin.close();
                break block22;
lbl40:
                // 1 sources

                catch (IOException e) {
                    ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                }
            }
            if (fin == null) return var10_16;
            ** try [egrp 3[TRYBLOCK] [5 : 156->164)] { 
lbl45:
            // 1 sources

            fin.close();
            return var10_16;
lbl47:
            // 1 sources

            catch (IOException e) {
                ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
            }
            return var10_16;
        }
        file = new File(filename, "META-INF/services.xml");
        if (!file.exists()) {
            file = new File(filename, "META-INF/services.xml".toLowerCase());
        }
        if (file.exists() == false) throw new DeploymentException(Messages.getMessage("servicexmlnotfound"));
        in = null;
        try {
            try {
                in = new FileInputStream(file);
                axisServiceGroup.setServiceGroupName(currentFile.getName());
                e = this.buildServiceGroup(in, currentFile, axisServiceGroup, wsdlServices, configCtx);
                var15_22 = null;
                if (in == null) return e;
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(Messages.getMessage("StreamException", e.getMessage()));
            }
        }
        catch (Throwable var14_26) {
            var15_23 = null;
            if (in == null) throw var14_26;
            try {
                in.close();
                throw var14_26;
            }
            catch (IOException e) {
                ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
            }
            throw var14_26;
        }
        try {}
        catch (IOException e) {
            ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
            return e;
        }
        in.close();
        return e;
    }

    public ArrayList<AxisService> processServiceGroup(OMElement serviceMetaData, DeploymentFileData currentFile, AxisServiceGroup axisServiceGroup, boolean extractService, Map<String, AxisService> wsdlServices, ConfigurationContext configCtx) throws AxisFault {
        try {
            Object serviceMetaDataObject;
            if (serviceMetaData == null && (serviceMetaDataObject = currentFile.getServiceMetaData()) != null && serviceMetaDataObject instanceof OMElement) {
                serviceMetaData = (OMElement)serviceMetaDataObject;
            }
            if (serviceMetaData != null) {
                if (!extractService) {
                    axisServiceGroup.setServiceGroupName(DescriptionBuilder.getShortFileName(currentFile.getName()));
                } else {
                    axisServiceGroup.setServiceGroupName(currentFile.getName());
                }
                return this.buildServiceGroup(serviceMetaData, currentFile, axisServiceGroup, wsdlServices, configCtx);
            }
            throw new DeploymentException("Can not find service meta data file");
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
    }

    private List<AxisService> processWSDLFile(WSDLToAxisServiceBuilder axisServiceBuilder, File serviceArchiveFile, boolean isArchive, InputStream in, String baseURI) throws DeploymentException {
        block13: {
            try {
                if (serviceArchiveFile != null && isArchive) {
                    axisServiceBuilder.setCustomResolver(new AARFileBasedURIResolver(serviceArchiveFile));
                    if (axisServiceBuilder instanceof WSDL11ToAllAxisServicesBuilder) {
                        ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).setCustomWSDLResolver(new AARBasedWSDLLocator(baseURI, serviceArchiveFile, in));
                        ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).setDocumentBaseUri(serviceArchiveFile.getCanonicalFile().toURI().toString());
                    } else if (axisServiceBuilder instanceof WSDL20ToAllAxisServicesBuilder) {
                        axisServiceBuilder.setBaseUri("jar:" + serviceArchiveFile.toURI() + "!/" + baseURI);
                    }
                } else if (serviceArchiveFile != null) {
                    axisServiceBuilder.setBaseUri(serviceArchiveFile.getParentFile().toURI().toString());
                    if (axisServiceBuilder instanceof WSDL11ToAllAxisServicesBuilder) {
                        ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).setDocumentBaseUri(serviceArchiveFile.getCanonicalFile().toURI().toString());
                    }
                }
                if (axisServiceBuilder instanceof WSDL11ToAllAxisServicesBuilder) {
                    return ((WSDL11ToAllAxisServicesBuilder)axisServiceBuilder).populateAllServices();
                }
                if (axisServiceBuilder instanceof WSDL20ToAllAxisServicesBuilder) {
                    return ((WSDL20ToAllAxisServicesBuilder)axisServiceBuilder).populateAllServices();
                }
            }
            catch (AxisFault axisFault) {
                log.info("Trouble processing wsdl file :" + axisFault.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug(axisFault);
                }
            }
            catch (IOException ioex) {
                log.info("Trouble processing wsdl file :" + ioex.getMessage());
                if (!log.isDebugEnabled()) break block13;
                log.debug(ioex);
            }
        }
        return null;
    }

    public HashMap<String, AxisService> processWSDLs(DeploymentFileData file) throws DeploymentException {
        File serviceFile = file.getFile();
        HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
        boolean isDirectory = serviceFile.isDirectory();
        if (isDirectory) {
            try {
                File metaInfFolder = new File(serviceFile, "META-INF");
                if (!metaInfFolder.exists() && !(metaInfFolder = new File(serviceFile, "META-INF".toLowerCase())).exists()) {
                    throw new DeploymentException(Messages.getMessage("noMetaInf", serviceFile.getName()));
                }
                this.processFilesInFolder(metaInfFolder, servicesMap);
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(e);
            }
            catch (IOException e) {
                throw new DeploymentException(e);
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(e);
            }
        }
        try {
            ZipEntry entry;
            FileInputStream fin = new FileInputStream(serviceFile);
            ZipInputStream zin = new ZipInputStream(fin);
            byte[] buf = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                List<AxisService> services;
                WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder;
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.startsWith("META-INF".toLowerCase()) || !entryName.endsWith(".wsdl")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (entryName.indexOf("/") != entryName.lastIndexOf("/") || entryName.indexOf("wsdl_") != -1) continue;
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                OMNamespace documentElementNS = ((OMElement)XMLUtils.toOM(in)).getNamespace();
                if (documentElementNS == null) continue;
                if ("http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) {
                    wsdlToAxisServiceBuilder = new WSDL20ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                    wsdlToAxisServiceBuilder.setBaseUri(entryName);
                } else if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                    wsdlToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setDocumentBaseUri(entryName);
                } else {
                    throw new DeploymentException(Messages.getMessage("invalidWSDLFound"));
                }
                if ((services = this.processWSDLFile(wsdlToAxisServiceBuilder, serviceFile, true, new ByteArrayInputStream(out.toByteArray()), entry.getName())) == null) continue;
                for (AxisService axisService : services) {
                    if (axisService == null) continue;
                    servicesMap.put(axisService.getName(), axisService);
                }
            }
            try {
                zin.close();
            }
            catch (IOException e) {
                log.info(e);
            }
            try {
                fin.close();
            }
            catch (IOException e) {
                log.info(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return servicesMap;
    }

    public List<AxisService> getAxisServiceFromWsdl(InputStream in, ClassLoader loader, String wsdlUrl) throws Exception {
        OMElement element = (OMElement)XMLUtils.toOM(in);
        OMNamespace documentElementNS = element.getNamespace();
        if (documentElementNS != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            element.serialize(out);
            if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                WSDL11ToAllAxisServicesBuilder wsdlToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                wsdlToAxisServiceBuilder.setCustomWSDLResolver(new WarBasedWSDLLocator(wsdlUrl, loader, new ByteArrayInputStream(out.toByteArray())));
                wsdlToAxisServiceBuilder.setCustomResolver(new WarFileBasedURIResolver(loader));
                return wsdlToAxisServiceBuilder.populateAllServices();
            }
            if ("http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) {
                WSDL20ToAllAxisServicesBuilder wsdlToAxisServiceBuilder = new WSDL20ToAllAxisServicesBuilder(new ByteArrayInputStream(out.toByteArray()));
                wsdlToAxisServiceBuilder.setCustomWSDLResolver(new WarBasedWSDLLocator(wsdlUrl, loader, new ByteArrayInputStream(out.toByteArray())));
                wsdlToAxisServiceBuilder.setCustomResolver(new WarFileBasedURIResolver(loader));
                return wsdlToAxisServiceBuilder.populateAllServices();
            }
            throw new DeploymentException(Messages.getMessage("invalidWSDLFound"));
        }
        return null;
    }

    public void processFilesInFolder(File folder, HashMap<String, AxisService> servicesMap) throws FileNotFoundException, XMLStreamException, DeploymentException {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file1 = files[i];
            if (!file1.getName().toLowerCase().endsWith(".wsdl")) continue;
            FileInputStream in = new FileInputStream(file1);
            OMNamespace documentElementNS = ((OMElement)XMLUtils.toOM(in)).getNamespace();
            if (documentElementNS != null) {
                WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder;
                FileInputStream in2;
                if ("http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) {
                    in2 = new FileInputStream(file1);
                    wsdlToAxisServiceBuilder = new WSDL20ToAllAxisServicesBuilder(in2);
                } else if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                    in2 = new FileInputStream(file1);
                    wsdlToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder(in2);
                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setDocumentBaseUri(file1.toURI().toString());
                } else {
                    throw new DeploymentException(Messages.getMessage("invalidWSDLFound"));
                }
                FileInputStream in3 = new FileInputStream(file1);
                List<AxisService> services = this.processWSDLFile(wsdlToAxisServiceBuilder, file1, false, in2, file1.toURI().toString());
                if (services != null) {
                    for (AxisService axisService : services) {
                        if (axisService == null) continue;
                        servicesMap.put(axisService.getName(), axisService);
                    }
                }
                try {
                    in2.close();
                    in3.close();
                }
                catch (IOException e) {
                    log.info(e);
                }
            }
            try {
                ((InputStream)in).close();
                continue;
            }
            catch (IOException e) {
                log.info(e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readModuleArchive(DeploymentFileData deploymentFile, AxisModule module, boolean explodedDir, AxisConfiguration axisConfig) throws DeploymentException {
        boolean moduleXMLFound = false;
        String shortFileName = DescriptionBuilder.getShortFileName(deploymentFile.getName());
        if (!explodedDir) {
            try {
                ZipEntry entry;
                FileInputStream fin = new FileInputStream(deploymentFile.getAbsolutePath());
                ZipInputStream zin = new ZipInputStream(fin);
                while ((entry = zin.getNextEntry()) != null) {
                    if (!entry.getName().equalsIgnoreCase("META-INF/module.xml")) continue;
                    moduleXMLFound = true;
                    ModuleBuilder builder = new ModuleBuilder(zin, module, axisConfig);
                    module.setArchiveName(shortFileName);
                    builder.populateModule();
                    break;
                }
                zin.close();
                fin.close();
                if (moduleXMLFound) return;
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", deploymentFile.getAbsolutePath()));
            }
            catch (Exception e) {
                throw new DeploymentException(e);
            }
        }
        File file = new File(deploymentFile.getAbsolutePath(), "META-INF/module.xml");
        if (!file.exists() && !(file = new File(deploymentFile.getAbsolutePath(), "META-INF/module.xml".toLowerCase())).exists()) throw new DeploymentException(Messages.getMessage("modulexmlnotfound", deploymentFile.getAbsolutePath()));
        FileInputStream in = null;
        in = new FileInputStream(file);
        ModuleBuilder builder = new ModuleBuilder(in, module, axisConfig);
        module.setArchiveName(shortFileName);
        builder.populateModule();
        Object var12_16 = null;
        if (in == null) return;
        try {
            ((InputStream)in).close();
            return;
        }
        catch (IOException e) {
            log.info(Messages.getMessage("errorininputstreamclose"));
        }
        return;
        {
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                log.info(Messages.getMessage("errorininputstreamclose"));
            }
            throw throwable;
        }
    }

    public OMElement buildServiceDescription(InputStream in, ConfigurationContext configCtx) throws XMLStreamException {
        DescriptionBuilder builder = new DescriptionBuilder(in, configCtx);
        OMElement rootElement = builder.buildOM();
        return rootElement;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OMElement buildServiceDescription(String filename, ConfigurationContext configCtx, boolean extractService) throws AxisFault {
        block21: {
            block19: {
                block17: {
                    block18: {
                        in = null;
                        zin = null;
                        try {
                            try {
                                if (!extractService) {
                                    in = new FileInputStream(filename);
                                    zin = new ZipInputStream(in);
                                    do {
                                        if ((entry = zin.getNextEntry()) == null) throw new DeploymentException(Messages.getMessage("servicexmlnotfound", filename));
                                    } while (!entry.getName().equalsIgnoreCase("META-INF/services.xml"));
                                    var7_9 = this.buildServiceDescription(zin, configCtx);
                                    var9_11 = null;
                                    if (zin == null) break block17;
                                    break block18;
                                }
                                file = new File(filename, "META-INF/services.xml");
                                if (!file.exists()) {
                                    file = new File(filename, "META-INF/services.xml".toLowerCase());
                                }
                                if (file.exists() == false) throw new DeploymentException(Messages.getMessage("servicexmlnotfound"));
                                in = new FileInputStream(file);
                                var7_10 = this.buildServiceDescription(in, configCtx);
                                break block19;
                            }
                            catch (Exception e) {
                                throw new DeploymentException(e);
                            }
                        }
                        catch (Throwable var8_17) {
                            var9_13 = null;
                            if (zin != null) {
                                try {
                                    zin.close();
                                }
                                catch (IOException e) {
                                    ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                                }
                            }
                            if (in == null) throw var8_17;
                            try {
                                in.close();
                                throw var8_17;
                            }
                            catch (IOException e) {
                                ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                                throw var8_17;
                            }
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 193->201)] { 
lbl45:
                    // 1 sources

                    zin.close();
                    break block17;
lbl47:
                    // 1 sources

                    catch (IOException e) {
                        ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                    }
                }
                if (in == null) return var7_9;
                ** try [egrp 3[TRYBLOCK] [7 : 221->229)] { 
lbl52:
                // 1 sources

                in.close();
                return var7_9;
lbl54:
                // 1 sources

                catch (IOException e) {
                    ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                }
                return var7_9;
            }
            var9_12 = null;
            if (zin != null) {
                ** try [egrp 2[TRYBLOCK] [6 : 193->201)] { 
lbl61:
                // 1 sources

                zin.close();
                break block21;
lbl63:
                // 1 sources

                catch (IOException e) {
                    ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
                }
            }
        }
        if (in == null) return var7_10;
        ** try [egrp 3[TRYBLOCK] [7 : 221->229)] { 
lbl68:
        // 1 sources

        in.close();
        return var7_10;
lbl70:
        // 1 sources

        catch (IOException e) {
            ArchiveReader.log.info(Messages.getMessage("errorininputstreamclose"));
        }
        return var7_10;
    }
}

