/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import java.lang.annotation.Annotation;
import javax.xml.ws.WebServiceClient;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderUtils;
import org.apache.axis2.jaxws.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceClientAnnot
implements WebServiceClient {
    private String name;
    private String targetNamespace;
    private String wsdlLocation;

    private WebServiceClientAnnot() {
    }

    private WebServiceClientAnnot(String name, String targetNamespace, String wsdlLocation) {
        this.name = name;
        this.targetNamespace = targetNamespace;
        this.wsdlLocation = wsdlLocation;
    }

    public static WebServiceClientAnnot createWebServiceClientAnnotImpl() {
        return new WebServiceClientAnnot();
    }

    public static WebServiceClientAnnot createWebServiceClientAnnotImpl(String name, String targetNamespace, String wsdlLocation) {
        return new WebServiceClientAnnot(name, targetNamespace, wsdlLocation);
    }

    public static WebServiceClientAnnot createFromAnnotation(Annotation annotation2) {
        WebServiceClientAnnot returnAnnot = null;
        if (annotation2 != null && annotation2 instanceof WebServiceClient) {
            WebServiceClient wsc = (WebServiceClient)annotation2;
            returnAnnot = new WebServiceClientAnnot(wsc.name(), wsc.targetNamespace(), wsc.wsdlLocation());
        }
        return returnAnnot;
    }

    public static WebServiceClientAnnot createFromAnnotation(Annotation baseAnnotation, Annotation sparseAnnotation) {
        WebServiceClientAnnot returnAnnot = null;
        WebServiceClient baseWSCAnnotation = null;
        WebServiceClient sparseWSCAnnotation = null;
        if (baseAnnotation != null && baseAnnotation instanceof WebServiceClient) {
            baseWSCAnnotation = (WebServiceClient)baseAnnotation;
        }
        if (sparseAnnotation != null && sparseAnnotation instanceof WebServiceClient) {
            sparseWSCAnnotation = (WebServiceClient)sparseAnnotation;
        }
        if (baseWSCAnnotation != null && sparseWSCAnnotation != null) {
            returnAnnot = WebServiceClientAnnot.createFromAnnotation(baseWSCAnnotation);
            if (!DescriptionBuilderUtils.isEmpty(sparseWSCAnnotation.name())) {
                returnAnnot.setName(sparseWSCAnnotation.name());
            }
            if (!DescriptionBuilderUtils.isEmpty(sparseWSCAnnotation.targetNamespace())) {
                returnAnnot.setTargetNamespace(sparseWSCAnnotation.targetNamespace());
            }
            if (!DescriptionBuilderUtils.isEmpty(sparseWSCAnnotation.wsdlLocation())) {
                returnAnnot.setWsdlLocation(sparseWSCAnnotation.wsdlLocation());
            }
        } else if (baseWSCAnnotation != null && sparseWSCAnnotation == null) {
            returnAnnot = WebServiceClientAnnot.createFromAnnotation(baseWSCAnnotation);
        } else if (baseWSCAnnotation == null && sparseWSCAnnotation != null) {
            returnAnnot = WebServiceClientAnnot.createFromAnnotation(sparseWSCAnnotation);
        } else if (baseWSCAnnotation != null || sparseWSCAnnotation != null) {
            String msg = Messages.getMessage("DescriptionBuilderErr2", sparseAnnotation == null ? null : sparseAnnotation.toString(), baseAnnotation == null ? null : baseAnnotation.toString());
            throw ExceptionFactory.makeWebServiceException(msg);
        }
        return returnAnnot;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String targetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String wsdlLocation() {
        return this.wsdlLocation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public Class<Annotation> annotationType() {
        return Annotation.class;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String newLine = "\n";
        sb.append(newLine);
        sb.append("@WebServiceClient.name= " + this.name);
        sb.append(newLine);
        sb.append("@WebServiceClient.targetNamespace= " + this.targetNamespace);
        sb.append(newLine);
        sb.append("@WebServiceClient.wsdlLocation= " + this.wsdlLocation);
        sb.append(newLine);
        return sb.toString();
    }
}

