/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.config;

import java.util.ArrayList;
import java.util.Set;
import javax.wsdl.Binding;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import org.apache.axis2.jaxws.common.config.WSDLValidatorElement;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.util.WSDLExtensionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RespectBindingConfigurator
implements ServerConfigurator {
    private static final Log log = LogFactory.getLog(RespectBindingConfigurator.class);

    public void configure(EndpointDescription endpointDescription) {
        RespectBinding annotation2;
        if (log.isDebugEnabled()) {
            log.debug("Invoking RespectBindingConfiguration.configure() on Server");
        }
        if ((annotation2 = (RespectBinding)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("javax.xml.ws.RespectBindingFeature")) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Setting respectBinding to " + annotation2.enabled());
            }
            endpointDescription.setRespectBinding(annotation2.enabled());
            EndpointDescriptionWSDL edw = (EndpointDescriptionWSDL)((Object)endpointDescription);
            Binding bnd = edw.getWSDLBinding();
            Set<WSDLValidatorElement> requiredExtension = endpointDescription.getRequiredBindings();
            ArrayList<QName> unusedExtensions = new ArrayList<QName>();
            WSDLExtensionUtils.search(bnd, requiredExtension, unusedExtensions);
            if (log.isDebugEnabled()) {
                log.debug("The following extensibility elements were found, but were not required.");
                for (int n = 0; n < unusedExtensions.size(); ++n) {
                    log.debug("[" + (n + 1) + "] - " + unusedExtensions.get(n));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("No @RespectBinding annotation was found.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit from RespectBindingConfiguration.configure() on Server.");
        }
    }

    public boolean supports(String bindingId) {
        return true;
    }
}

