/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.saaj.DetailImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPFaultImpl;
import org.w3c.dom.Element;

public class SOAPFactoryImpl
extends javax.xml.soap.SOAPFactory {
    private final DOMMetaFactory metaFactory = (DOMMetaFactory)OMAbstractFactory.getMetaFactory("dom");
    protected String soapVersion = "SOAP 1.1 Protocol";

    public SOAPElement createElement(Name name) throws SOAPException {
        String localName = name.getLocalName();
        String prefix = name.getPrefix();
        String uri = name.getURI();
        OMElement omElement = null;
        omElement = this.soapVersion.equals("SOAP 1.2 Protocol") ? this.metaFactory.getSOAP12Factory().createOMElement(localName, uri, prefix) : this.metaFactory.getSOAP11Factory().createOMElement(localName, uri, prefix);
        this.metaFactory.getOMFactory().createOMElement(localName, uri, prefix);
        return new SOAPElementImpl<OMElement>(omElement);
    }

    public SOAPElement createElement(String localName) throws SOAPException {
        SOAPFactory omFactory = null;
        omFactory = this.soapVersion.equals("SOAP 1.2 Protocol") ? this.metaFactory.getSOAP12Factory() : this.metaFactory.getSOAP11Factory();
        OMElement omElement = omFactory.createOMElement(new QName(localName));
        return new SOAPElementImpl<OMElement>(omElement);
    }

    public SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        OMElement omElement = null;
        omElement = this.soapVersion.equals("SOAP 1.2 Protocol") ? this.metaFactory.getSOAP12Factory().createOMElement(localName, uri, prefix) : this.metaFactory.getSOAP11Factory().createOMElement(localName, uri, prefix);
        return new SOAPElementImpl<OMElement>(omElement);
    }

    public Detail createDetail() throws SOAPException {
        if (this.soapVersion.equals("SOAP 1.2 Protocol")) {
            return new DetailImpl(this.metaFactory.getSOAP12Factory().createSOAPFaultDetail());
        }
        return new DetailImpl(this.metaFactory.getSOAP11Factory().createSOAPFaultDetail());
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new PrefixedQName(uri, localName, prefix);
    }

    public Name createName(String localName) throws SOAPException {
        return new PrefixedQName(null, localName, null);
    }

    public SOAPFault createFault() throws SOAPException {
        if (this.soapVersion.equals("SOAP 1.2 Protocol")) {
            SOAPFactory soapFactory = this.metaFactory.getSOAP12Factory();
            return new SOAPFaultImpl(soapFactory.createSOAPFault());
        }
        SOAPFactory soapFactory = this.metaFactory.getSOAP11Factory();
        return new SOAPFaultImpl(soapFactory.createSOAPFault());
    }

    public SOAPFault createFault(String reasonText, QName faultCode) throws SOAPException {
        SOAPFaultImpl soapFault = this.soapVersion.equals("SOAP 1.2 Protocol") ? new SOAPFaultImpl(this.metaFactory.getSOAP12Factory().createSOAPFault()) : new SOAPFaultImpl(this.metaFactory.getSOAP11Factory().createSOAPFault());
        soapFault.setFaultCode(faultCode);
        try {
            soapFault.addFaultReasonText(reasonText, Locale.getDefault());
        }
        catch (UnsupportedOperationException e) {
            throw new SOAPException(e.getMessage());
        }
        return soapFault;
    }

    public void setSOAPVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public SOAPElement createElement(QName qname2) throws SOAPException {
        String localName = qname2.getLocalPart();
        String prefix = qname2.getPrefix();
        String uri = qname2.getNamespaceURI();
        OMElement omElement = this.metaFactory.getOMFactory().createOMElement(localName, uri, prefix);
        return new SOAPElementImpl<OMElement>(omElement);
    }

    public SOAPElement createElement(Element element) throws SOAPException {
        SOAPFactory omFactory = null;
        omFactory = this.soapVersion.equals("SOAP 1.2 Protocol") ? this.metaFactory.getSOAP12Factory() : this.metaFactory.getSOAP11Factory();
        String prefix = element.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        OMNamespace ns = omFactory.createOMNamespace(element.getNamespaceURI(), prefix);
        OMElement omElement = omFactory.createOMElement(element.getLocalName(), ns);
        return new SOAPElementImpl<OMElement>(omElement);
    }
}

