/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.benchmarking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hpccsystems.commons.benchmarking.AveragedMetric;
import org.hpccsystems.commons.benchmarking.IMetric;
import org.hpccsystems.commons.benchmarking.IMetricSetTransformer;

public class MetricAverageTransformer
implements IMetricSetTransformer {
    @Override
    public List<IMetric> transform(List<IMetric> metrics) {
        if (metrics.size() == 0) {
            return metrics;
        }
        Comparator<IMetric> compare = new Comparator<IMetric>(){

            @Override
            public int compare(IMetric m1, IMetric m2) {
                return m1.getName().compareTo(m2.getName());
            }
        };
        Collections.sort(metrics, compare);
        ArrayList<IMetric> aggedMetrics = new ArrayList<IMetric>();
        AveragedMetric workingMetric = new AveragedMetric(metrics.get(0));
        aggedMetrics.add(workingMetric);
        for (int i = 1; i < metrics.size(); ++i) {
            IMetric curMetric = metrics.get(i);
            if (workingMetric.getName() != curMetric.getName()) {
                workingMetric = new AveragedMetric(curMetric);
                aggedMetrics.add(workingMetric);
                continue;
            }
            workingMetric.addDataPoint(curMetric.getValue());
        }
        return aggedMetrics;
    }
}

