/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.ecl;

import java.io.Serializable;

public enum FieldType implements Serializable
{
    INTEGER(true, "Integer", false),
    FILEPOS(true, "Filepos", false),
    REAL(true, "Real", false),
    DECIMAL(true, "Decimal", false),
    VAR_STRING(true, "VarString", false),
    STRING(true, "String", false),
    CHAR(true, "Char", false),
    BOOLEAN(true, "Boolean", false),
    BINARY(true, "Binary data", false),
    RECORD(false, "Record", true),
    SET(false, "Set", true),
    DATASET(false, "Dataset", true),
    UNKNOWN(true, "Unknown", false);

    static final long serialVersionUID = 1L;
    private boolean scalar;
    private String name;
    private boolean composite;

    private FieldType(boolean atomicType, String name, boolean composite) {
        this.scalar = atomicType;
        this.name = name;
        this.composite = composite;
    }

    private FieldType() {
        this.scalar = true;
        this.name = "";
        this.composite = false;
    }

    public boolean isScalar() {
        return this.scalar;
    }

    public boolean isVector() {
        return !this.scalar && !this.composite;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public String description() {
        return this.name;
    }
}

