/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.errors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hpccsystems.commons.errors.HpccError;
import org.hpccsystems.commons.errors.HpccErrorLevel;
import org.hpccsystems.commons.errors.IErrorCode;

public class HpccErrorBlock {
    private final CopyOnWriteArraySet<HpccError> he = new CopyOnWriteArraySet();

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (HpccError e : this.he) {
            s.append(e.toString()).append("\n");
        }
        return s.toString();
    }

    public void addAll(HpccErrorBlock items) {
        this.he.addAll(items.he);
    }

    public List<HpccError> getErrors(IErrorCode st) {
        List<HpccError> errs = this.getItems(HpccErrorLevel.ERROR, st);
        errs.addAll(this.getItems(HpccErrorLevel.FATAL, st));
        return errs;
    }

    public List<HpccError> getErrors() {
        List<HpccError> errs = this.getItems(HpccErrorLevel.ERROR, null);
        errs.addAll(this.getItems(HpccErrorLevel.FATAL, null));
        return errs;
    }

    public List<HpccError> getWarnings() {
        return this.getItems(HpccErrorLevel.WARNING, null);
    }

    public List<HpccError> getInfos() {
        return this.getItems(HpccErrorLevel.INFO, null);
    }

    public List<HpccError> getItems(HpccErrorLevel errLevel, IErrorCode code) {
        ArrayList<HpccError> filtered = new ArrayList<HpccError>();
        for (HpccError err : this.he) {
            if (errLevel != null && !errLevel.equals((Object)err.getErrorLevel()) || code != null && !code.equals(err.getErrorCode())) continue;
            filtered.add(err);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HpccError err) {
        if (err == null) {
            return;
        }
        CopyOnWriteArraySet<HpccError> copyOnWriteArraySet = this.he;
        synchronized (copyOnWriteArraySet) {
            this.he.add(err);
        }
    }

    public String toEclIdeString() {
        StringBuilder sb = new StringBuilder();
        for (HpccError e : this.getErrors()) {
            sb.append(e.toEclIdeString());
        }
        return sb.toString();
    }

    public void clear() {
        this.he.clear();
    }

    public int size() {
        return this.he.size();
    }

    public Set<HpccError> asSet() {
        return this.he;
    }

    public boolean isEmpty() {
        return this.he.isEmpty();
    }
}

