/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hpccsystems.commons.filter.SQLExpression;
import org.hpccsystems.commons.filter.SQLFragment;
import org.hpccsystems.commons.filter.SQLOperator;
import org.hpccsystems.commons.utils.Utils;

public class SQLFilter {
    private List<SQLExpression> expressions = new ArrayList<SQLExpression>();
    private List<String> expressionUniqueColumnNames = new ArrayList<String>();
    private boolean orOperatorUsed = false;
    public static final SQLOperator andOperator = new SQLOperator(SQLOperator.and);
    public static final SQLOperator orOperator = new SQLOperator(SQLOperator.or);
    private static final String otherThanQuote = " [^'\"] ";
    private static final String quotedString = String.format(" ' %s* ' ", " [^'\"] ");
    public static final String andregex = "(?x) \\s+(?i)and\\s+(?=( [^'\"] *" + quotedString + ")*" + " [^'\"] " + "*$)";
    public static final String orregex = "(?x) \\s+(?i)or\\s+(?=( [^'\"] *" + quotedString + ")*" + " [^'\"] " + "*$)";

    public void addExpression(SQLExpression expression) {
        this.expressions.add(expression);
        if (!(expression.getPrefixType() != SQLFragment.FragmentType.FIELD && expression.getPrefixType() != SQLFragment.FragmentType.FIELD_CONTENT_MODIFIER || this.expressionUniqueColumnNames.contains(expression.getPrefixValue()))) {
            this.expressionUniqueColumnNames.add(expression.getPrefixValue());
        }
        if (!(expression.getPostfixType() != SQLFragment.FragmentType.FIELD && expression.getPostfixType() != SQLFragment.FragmentType.FIELD_CONTENT_MODIFIER || this.expressionUniqueColumnNames.contains(expression.getPostfixValue()))) {
            this.expressionUniqueColumnNames.add(expression.getPostfixValue());
        }
    }

    public Iterator<SQLExpression> getExpressions() {
        return this.expressions.iterator();
    }

    public int getExpressionsCount() {
        return this.expressions.size();
    }

    public String toString() {
        String clause = new String("");
        for (SQLExpression exp : this.expressions) {
            clause = clause + exp.toString();
        }
        return clause;
    }

    public String fullToString() {
        String clause = new String("");
        for (SQLExpression exp : this.expressions) {
            clause = clause + exp.toStringFull(true);
        }
        return clause;
    }

    public String toStringTranslateSource(HashMap<String, String> map, boolean ignoreMisTranslations) {
        String clause = new String("");
        String expstr = null;
        boolean foundFirstExpression = false;
        for (SQLExpression exp : this.expressions) {
            expstr = exp.toStringTranslateSource(map, !foundFirstExpression, ignoreMisTranslations);
            if (expstr == null) continue;
            clause = clause + expstr;
            if (foundFirstExpression) continue;
            foundFirstExpression = true;
        }
        return clause;
    }

    public String[] getExpressionColumnNames() {
        String[] colnames = new String[this.getExpressionsCount()];
        int i = 0;
        for (SQLExpression exp : this.expressions) {
            if (exp.getPrefixType() == SQLFragment.FragmentType.FIELD || exp.getPrefixType() == SQLFragment.FragmentType.FIELD_CONTENT_MODIFIER) {
                colnames[i++] = exp.getPrefixValue();
            }
            if (exp.getPostfixType() != SQLFragment.FragmentType.FIELD && exp.getPostfixType() != SQLFragment.FragmentType.FIELD_CONTENT_MODIFIER) continue;
            colnames[i++] = exp.getPostfixValue();
        }
        return colnames;
    }

    public String getExpressionFromColumnName(String colname) {
        String expstr = "";
        for (SQLExpression exp : this.expressions) {
            if ((exp.getPrefixType() != SQLFragment.FragmentType.FIELD || !exp.getPrefixValue().equals(colname)) && (exp.getPostfixType() != SQLFragment.FragmentType.FIELD || !exp.getPostfixValue().equals(colname))) continue;
            if (expstr.length() != 0) {
                expstr = expstr + " AND ";
            }
            expstr = expstr + exp.toString();
        }
        return expstr;
    }

    public boolean containsKey(String colname) {
        if (this.expressionUniqueColumnNames.contains(colname)) {
            for (SQLExpression exp : this.expressions) {
                if (!exp.containsKey(colname)) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] getUniqueExpressionColumnNames() {
        return this.expressionUniqueColumnNames.toArray();
    }

    public boolean isOrOperatorUsed() {
        return this.orOperatorUsed;
    }

    private String handleGroupParens(String group2) {
        int firstclose;
        int secopen;
        String unencapsulated = group2.trim();
        if (group2.charAt(0) == '(' && group2.charAt(group2.length() - 1) == ')' && (secopen = group2.indexOf(40, 1)) < (firstclose = group2.indexOf(41, 1))) {
            int sectolastclose = group2.substring(0, group2.length() - 1).lastIndexOf(41);
            int lastopen = group2.lastIndexOf(40);
            if (sectolastclose == -1 || sectolastclose > lastopen) {
                unencapsulated = Utils.getParenContents(group2);
            }
        }
        return unencapsulated;
    }

    public void parseWhereClause(String whereclause) throws SQLException {
        whereclause = this.handleGroupParens(whereclause);
        String[] splitedwhereands = whereclause.split(andregex);
        for (int andsIndex = 0; andsIndex < splitedwhereands.length; ++andsIndex) {
            splitedwhereands[andsIndex] = this.handleGroupParens(splitedwhereands[andsIndex]);
            String[] splitedwhereandors = splitedwhereands[andsIndex].split(orregex);
            for (int orsIndex = 0; orsIndex < splitedwhereandors.length; ++orsIndex) {
                splitedwhereandors[orsIndex] = this.handleGroupParens(splitedwhereandors[orsIndex]);
                SQLExpression exp = new SQLExpression();
                exp.ParseExpression(splitedwhereandors[orsIndex]);
                this.addExpression(exp);
                if (orsIndex > 0) {
                    this.orOperatorUsed = true;
                    exp.setPreviousExpUnifier(orOperator);
                    continue;
                }
                if (andsIndex <= 0) continue;
                exp.setPreviousExpUnifier(andOperator);
            }
        }
    }

    public boolean containsEqualityCondition(HashMap<String, String> map, String first, String second) {
        boolean andsmatch = false;
        SQLOperator prevunifier = null;
        for (SQLExpression exp : this.expressions) {
            prevunifier = exp.getPreviousExpUnifier();
            boolean localmatch = exp.isEqualityCondition(map, first, second);
            if (prevunifier == null || prevunifier.equals(andOperator)) {
                andsmatch |= localmatch;
                continue;
            }
            if (prevunifier == null || !prevunifier.equals(orOperator)) continue;
            if (!andsmatch || !localmatch) {
                return false;
            }
            andsmatch = false;
        }
        return andsmatch;
    }
}

