/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Network {
    private static final Logger log = LogManager.getLogger(Network.class);
    private static HashMap<String, InetAddress> LocalAddresses = new HashMap();

    public static String getLocalAddress(String interfacename) throws Exception {
        return Network.getLocalAddress(interfacename, false);
    }

    public static String getLocalAddress(String interfacename, boolean ipv6) throws Exception {
        if (interfacename == null || interfacename.isEmpty()) {
            throw new Exception("getLocalAddress: Must provide valid NIC name, or '*'");
        }
        if (interfacename.trim().equals("*")) {
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress addr = addresses.nextElement();
                        if (addr.isLoopbackAddress() || (!(addr instanceof Inet4Address) || ipv6) && (!(addr instanceof Inet6Address) || !ipv6)) continue;
                        return addr.getHostAddress();
                    }
                }
            }
            catch (SocketException e) {
                throw new Exception("getLocalAddress: Failed to retrieve local network address information", e);
            }
        } else {
            NetworkInterface nic = NetworkInterface.getByName(interfacename);
            Enumeration<InetAddress> addresses = nic.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if ((!(addr instanceof Inet4Address) || ipv6) && (!(addr instanceof Inet6Address) || !ipv6)) continue;
                return addr.getHostAddress();
            }
        }
        throw new Exception("getLocalAddress: Could not find local address");
    }

    public static boolean isLocalAddress(String address) {
        return LocalAddresses.containsKey(address.toUpperCase());
    }

    static {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    LocalAddresses.put(addr.getHostAddress().toUpperCase(), addr);
                }
            }
        }
        catch (SocketException e) {
            log.error("Failed to retrieve local network address information");
            log.error((Object)e);
        }
    }
}

