/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FileFilter;
import org.hpccsystems.commons.ecl.RecordDefinitionTranslator;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.client.ColumnPruner;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.PartitionProcessor;
import org.hpccsystems.dfs.cluster.ClusterRemapper;
import org.hpccsystems.dfs.cluster.RemapInfo;
import org.hpccsystems.ws.client.HPCCWsDFUClient;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileAccessInfoWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileDetailWrapper;
import org.json.JSONObject;

public class HPCCFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(HPCCFile.class);
    private DataPartition[] dataParts;
    private DataPartition tlkPartition = null;
    private PartitionProcessor partitionProcessor = null;
    private long dataPartsCreationTimeMS = -1L;
    private FieldDef recordDefinition;
    private FieldDef projectedRecordDefinition;
    private boolean isIndex = false;
    private static final int DEFAULT_ACCESS_EXPIRY_SECONDS = 120;
    private int fileAccessExpirySecs = 120;
    private transient Connection espConnInfo;
    private String fileName;
    private String targetfilecluster = "";
    private RemapInfo clusterRemapInfo = new RemapInfo();
    private FileFilter filter;
    private ColumnPruner columnPruner;
    private DFUFileDetailWrapper originalFileMetadata = null;

    public HPCCFile(String fileName, Connection espconninfo) throws HpccFileException {
        this(fileName, espconninfo, "", "", new RemapInfo(), 0, "");
    }

    public HPCCFile(String fileName, String connectionString, String user, String pass) throws MalformedURLException, HpccFileException {
        this(fileName, new Connection(connectionString));
        this.espConnInfo.setUserName(user);
        this.espConnInfo.setPassword(pass);
    }

    public HPCCFile(String fileName, Connection espconninfo, String targetColumnList, String filter, RemapInfo remap_info, int maxParts, String targetfilecluster) throws HpccFileException {
        this.fileName = fileName;
        this.recordDefinition = null;
        this.projectedRecordDefinition = null;
        this.columnPruner = new ColumnPruner(targetColumnList);
        this.espConnInfo = espconninfo;
        try {
            if (filter != null && !filter.isEmpty()) {
                this.filter = new FileFilter(filter);
            }
        }
        catch (Exception e) {
            throw new HpccFileException("Could not create HPCCFile due to invalid FileFilter", e);
        }
        this.clusterRemapInfo = remap_info;
        this.targetfilecluster = targetfilecluster;
    }

    public static int getFilePartFromFPos(long fpos) {
        return (int)(fpos >>> 48 & 0x7FFFL);
    }

    public static long getOffsetFromFPos(long fpos) {
        return fpos & 0xFFFFFFFFFFFFL;
    }

    public String getProjectList() {
        return this.columnPruner.getFieldListString();
    }

    public HPCCFile setProjectList(String projectList) throws Exception {
        this.columnPruner = new ColumnPruner(projectList);
        if (this.recordDefinition != null) {
            this.projectedRecordDefinition = this.columnPruner.pruneRecordDefinition(this.recordDefinition);
        }
        return this;
    }

    public int getFileAccessExpirySecs() {
        return this.fileAccessExpirySecs;
    }

    public HPCCFile setFileAccessExpirySecs(int fileAccessExpirySecs) {
        this.fileAccessExpirySecs = fileAccessExpirySecs;
        this.dataParts = null;
        return this;
    }

    public String getTargetfilecluster() {
        return this.targetfilecluster;
    }

    public HPCCFile setTargetfilecluster(String targetfilecluster) {
        this.targetfilecluster = targetfilecluster;
        this.dataParts = null;
        return this;
    }

    public RemapInfo getClusterRemapInfo() {
        return this.clusterRemapInfo;
    }

    public HPCCFile setClusterRemapInfo(RemapInfo remapinfo) {
        this.clusterRemapInfo = remapinfo;
        this.dataParts = null;
        return this;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public HPCCFile setFilter(String filterexpression) throws Exception {
        this.filter = new FileFilter(filterexpression);
        if (this.dataParts != null) {
            for (int i = 0; i < this.dataParts.length; ++i) {
                this.dataParts[i].setFilter(this.filter);
            }
        }
        return this;
    }

    public HPCCFile setFilter(FileFilter filefilter) throws Exception {
        this.filter = filefilter;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void createDataParts() throws HpccFileException {
        boolean accessTokenExpired;
        long fileAccessExpiryMS = this.fileAccessExpirySecs * 1000;
        long dataPartsAgeMS = System.currentTimeMillis() - this.dataPartsCreationTimeMS;
        boolean bl = accessTokenExpired = dataPartsAgeMS >= fileAccessExpiryMS;
        if (this.dataParts != null) {
            if (accessTokenExpired) {
                log.info("Refreshing data parts due to access token expiration.");
            } else {
                return;
            }
        }
        this.dataPartsCreationTimeMS = System.currentTimeMillis();
        HPCCWsDFUClient dfuClient = HPCCWsDFUClient.get(this.espConnInfo);
        if (dfuClient.hasInitError()) {
            String errmesg = "Could not fetch '" + this.fileName + "' info from WsDFU ESP due to wsdfuclient init error: " + dfuClient.getInitError();
            log.error(errmesg);
            throw new HpccFileException(errmesg);
        }
        String originalRecDefInJSON = "";
        DFUFileAccessInfoWrapper fileinfoforread = null;
        try {
            fileinfoforread = HPCCFile.fetchReadFileInfo(this.fileName, dfuClient, this.fileAccessExpirySecs, this.targetfilecluster);
            this.isIndex = fileinfoforread.getFileType().isIndex();
            originalRecDefInJSON = fileinfoforread.getRecordTypeInfoJson();
            if (originalRecDefInJSON == null) {
                throw new Exception("File record definiton returned from ESP was null");
            }
        }
        catch (Exception e) {
            log.error("Unable to retrieve file or record information: " + e.getMessage());
            throw new HpccFileException("Unable to retrieve file or record information: " + e.getMessage(), e);
        }
        DataPartition.FileType fileType = DataPartition.FileType.FLAT;
        try {
            fileType = DataPartition.FileType.fromWrappedFileType(fileinfoforread.getFileType());
        }
        catch (Exception e) {
            throw new HpccFileException(e);
        }
        try {
            if (fileinfoforread.getNumParts() > 0) {
                DataPartition lastPart;
                ClusterRemapper clusterremapper = ClusterRemapper.makeMapper(this.clusterRemapInfo, fileinfoforread);
                this.dataParts = DataPartition.createPartitions(fileinfoforread.getFileParts(), clusterremapper, 0, this.filter, fileinfoforread.getFileAccessInfoBlob(), fileType);
                if (this.isIndex() && (lastPart = this.dataParts[this.dataParts.length - 1]).isTLK()) {
                    this.tlkPartition = lastPart;
                    this.dataParts = Arrays.copyOfRange(this.dataParts, 0, this.dataParts.length - 1);
                }
            } else {
                throw new HpccFileException("Could not fetch metadata for file: '" + this.fileName + "'");
            }
            this.recordDefinition = RecordDefinitionTranslator.parseJsonRecordDefinition(new JSONObject(originalRecDefInJSON));
            this.partitionProcessor = new PartitionProcessor(this.recordDefinition, this.dataParts, this.tlkPartition);
            this.projectedRecordDefinition = this.columnPruner.pruneRecordDefinition(this.recordDefinition);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to acquire file access or retrieve meta info for: '").append(this.fileName).append("'");
            sb.append(" with error: " + e.getMessage());
            throw new HpccFileException(sb.toString(), e);
        }
    }

    public DataPartition[] getFileParts() throws HpccFileException {
        return this.findMatchingPartitions(this.filter).toArray(new DataPartition[0]);
    }

    public List<DataPartition> findMatchingPartitions(FileFilter filter) throws HpccFileException {
        this.createDataParts();
        List<DataPartition> matchedPartitions = this.partitionProcessor.findMatchingPartitions(filter);
        return matchedPartitions;
    }

    public PartitionProcessor getPartitionProcessor() {
        return this.partitionProcessor;
    }

    public final FieldDef getRecordDefinition() throws HpccFileException {
        this.createDataParts();
        return this.recordDefinition;
    }

    public final FieldDef getProjectedRecordDefinition() throws HpccFileException {
        this.createDataParts();
        return this.projectedRecordDefinition;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    private static DFUFileAccessInfoWrapper fetchReadFileInfo(String fileName, HPCCWsDFUClient hpccClient, int expirySeconds, String clusterName) throws Exception, ArrayOfEspExceptionWrapper {
        String uniqueID = "HPCC-FILE: " + UUID.randomUUID().toString();
        return hpccClient.getFileAccess(fileName, clusterName, expirySeconds, uniqueID);
    }

    private static String acquireReadFileAccess(String fileName, HPCCWsDFUClient hpccClient, int expirySeconds, String clusterName) throws Exception, ArrayOfEspExceptionWrapper {
        return HPCCFile.acquireFileAccess(fileName, hpccClient, expirySeconds, clusterName);
    }

    private static String acquireWriteFileAccess(String fileName, HPCCWsDFUClient hpccClient, int expirySeconds, String clusterName) throws Exception, ArrayOfEspExceptionWrapper {
        return HPCCFile.acquireFileAccess(fileName, hpccClient, expirySeconds, clusterName);
    }

    private static String acquireFileAccess(String fileName, HPCCWsDFUClient hpcc, int expirySeconds, String clusterName) throws Exception, ArrayOfEspExceptionWrapper {
        String uniqueID = "HPCC-FILE: " + UUID.randomUUID().toString();
        return hpcc.getFileAccessBlob(fileName, clusterName, expirySeconds, uniqueID);
    }

    public DFUFileDetailWrapper getOriginalFileMetadata() {
        if (this.originalFileMetadata == null) {
            HPCCWsDFUClient dfuClient = HPCCWsDFUClient.get(this.espConnInfo);
            if (dfuClient.hasInitError()) {
                String errmesg = "Could not fetch '" + this.fileName + "' info from WsDFU ESP due to wsdfuclient init error: " + dfuClient.getInitError();
                log.error(errmesg);
            }
            try {
                this.originalFileMetadata = dfuClient.getFileDetails(this.fileName, this.targetfilecluster);
            }
            catch (Exception e) {
                log.error("Unable to retrieve file or record information: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.originalFileMetadata;
    }
}

