/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.client.BinaryRecordReader;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.IRecordBuilder;
import org.hpccsystems.dfs.client.RowServiceInputStream;

public class HpccRandomAccessFileReader<T>
implements Iterator<T> {
    private static final Logger log = LogManager.getLogger(HpccRandomAccessFileReader.class);
    private FieldDef originalRecordDef = null;
    private DataPartition dataPartition = null;
    private RowServiceInputStream inputStream = null;
    private BinaryRecordReader binaryRecordReader;
    private IRecordBuilder recordBuilder = null;
    private ArrayList<Long> requestedRecordOffsets = new ArrayList();
    private ArrayList<Long> queuedRecordOffsets = new ArrayList();
    private Thread fetchRequestThread = null;

    public HpccRandomAccessFileReader(DataPartition dp, FieldDef originalRD, IRecordBuilder recBuilder, int connectTimeout) throws Exception {
        this.originalRecordDef = originalRD;
        if (this.originalRecordDef == null) {
            throw new Exception("HpccRemoteFileReader: Original record definition is null.");
        }
        if (connectTimeout < 1) {
            connectTimeout = 5000;
        }
        this.dataPartition = dp;
        this.recordBuilder = recBuilder;
        FieldDef projectedRecordDefinition = recBuilder.getRecordDefinition();
        if (projectedRecordDefinition == null) {
            throw new Exception("IRecordBuilder does not have a valid record definition.");
        }
        boolean isFetching = true;
        boolean createPrefetchThread = false;
        this.inputStream = new RowServiceInputStream(this.dataPartition, this.originalRecordDef, projectedRecordDefinition, connectTimeout, -1, createPrefetchThread, -1, null, isFetching);
        this.binaryRecordReader = new BinaryRecordReader(this.inputStream);
        this.binaryRecordReader.initialize(this.recordBuilder);
    }

    public void addRecordRequests(List<Long> recordOffsets) {
        this.queuedRecordOffsets.addAll(recordOffsets);
    }

    public int getRemoteReadMessageCount() {
        int count = 0;
        if (this.binaryRecordReader != null) {
            count = this.binaryRecordReader.getStreamMessageCount();
        }
        return count;
    }

    public String getRemoteReadMessages() {
        String report = "";
        if (this.binaryRecordReader != null) {
            report = this.binaryRecordReader.getStreamMessages();
        }
        return report;
    }

    @Override
    public boolean hasNext() {
        int numRemainingRecords = this.requestedRecordOffsets.size() + this.queuedRecordOffsets.size();
        return numRemainingRecords != 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            String errorMessage = "No records remaining in request or no records have been requested.";
            log.error(errorMessage);
            throw new NoSuchElementException(errorMessage);
        }
        if (this.requestedRecordOffsets.size() == 0) {
            this.requestedRecordOffsets.addAll(this.queuedRecordOffsets);
            this.queuedRecordOffsets.clear();
            Runnable fetchRequestTask = new Runnable(){
                RowServiceInputStream inputStream;
                {
                    this.inputStream = HpccRandomAccessFileReader.this.inputStream;
                }

                @Override
                public void run() {
                    try {
                        this.inputStream.startBlockingFetchRequest(HpccRandomAccessFileReader.this.requestedRecordOffsets);
                    }
                    catch (Exception e) {
                        String errorMessage = "Error while performing block fetch request: " + e.getMessage();
                        log.error(errorMessage);
                        throw new NoSuchElementException(errorMessage);
                    }
                }
            };
            this.fetchRequestThread = new Thread(fetchRequestTask);
            this.fetchRequestThread.start();
        }
        Object rslt = null;
        try {
            rslt = this.binaryRecordReader.getNext();
        }
        catch (HpccFileException e) {
            log.error("Read failure for " + this.dataPartition.toString() + " " + e.getMessage());
            throw new NoSuchElementException("Fatal read error: " + e.getMessage());
        }
        this.requestedRecordOffsets.remove(0);
        return (T)rslt;
    }

    public void close() throws Exception {
        this.report();
        this.inputStream.close();
    }

    public RowServiceInputStream getInputStream() {
        return this.inputStream;
    }

    public BinaryRecordReader getRecordReader() {
        return this.binaryRecordReader;
    }

    public void report() {
        if (this.getRemoteReadMessageCount() > 0) {
            log.warn("DataPartition '" + this.dataPartition + "' read operation messages:\n");
            log.warn(this.getRemoteReadMessages());
        }
    }
}

