/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetInputFile
implements InputFile {
    private File file = null;

    ParquetInputFile(File file) {
        this.file = file;
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    public SeekableInputStream newStream() throws IOException {
        return new ParquetInputStream(new FileInputStream(this.file));
    }

    public static class ParquetInputStream
    extends DelegatingSeekableInputStream {
        private FileInputStream inputStream = null;

        public ParquetInputStream(FileInputStream stream) {
            super((InputStream)stream);
            this.inputStream = stream;
        }

        public long getPos() throws IOException {
            return this.inputStream.getChannel().position();
        }

        public void seek(long newPos) throws IOException {
            this.inputStream.getChannel().position(newPos);
        }
    }
}

