/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ObjectPool<T> {
    private long expirationTime;
    private Hashtable<T, Long> locked;
    private Hashtable<T, Long> unlocked;

    public ObjectPool(long expirationTime) {
        this.expirationTime = expirationTime;
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
    }

    public ObjectPool() {
        this(60000L);
    }

    protected abstract T create();

    public abstract boolean validate(T var1);

    public abstract void expire(T var1);

    public synchronized T checkOut() {
        T t;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration<T> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (now - this.unlocked.get(t) > this.expirationTime) {
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        t = this.create();
        this.locked.put(t, now);
        return t;
    }

    public synchronized void checkIn(T t) {
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
    }
}

