/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class WsGen2
extends MatchingTask {
    private CommandlineJava cmd = new CommandlineJava();
    protected Path compileClasspath = null;
    private File destDir = null;
    private boolean failonerror = true;
    protected boolean extension;
    private boolean keep = false;
    private boolean fork = false;
    private File resourceDestDir = null;
    private boolean optimize = false;
    private File sourceDestDir;
    protected boolean verbose = false;
    private boolean debug = false;
    private boolean genWsdl = false;
    private String protocol = "";
    private String serviceName = null;
    private String portName = null;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;
    private String sei;

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getCP() {
        return this.getClasspath();
    }

    public void setCP(Path classpath) {
        this.setClasspath(classpath);
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File base) {
        this.destDir = base;
    }

    public void setFailonerror(boolean value) {
        this.failonerror = value;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public File getResourcedestdir() {
        return this.resourceDestDir;
    }

    public void setResourcedestdir(File resourceDir) {
        this.resourceDestDir = resourceDir;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setSourcedestdir(File sourceBase) {
        this.keep = true;
        this.sourceDestDir = sourceBase;
    }

    public File getSourcedestdir() {
        return this.sourceDestDir;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getGenwsdl() {
        return this.genWsdl;
    }

    public void setGenwsdl(boolean genWsdl) {
        this.genWsdl = genWsdl;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServicename() {
        return this.serviceName;
    }

    public void setServicename(String name) {
        this.serviceName = name;
    }

    public String getPortname() {
        return this.portName;
    }

    public void setPortname(String name) {
        this.portName = name;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public String getSei() {
        return this.sei;
    }

    public void setSei(String endpointImplementationClass) {
        this.sei = endpointImplementationClass;
    }

    private void setupWscompileCommand() {
        Path classpath = this.getClasspath();
        if (classpath != null && !classpath.toString().equals("")) {
            this.cmd.createArgument().setValue("-classpath");
            this.cmd.createArgument().setPath(classpath);
        }
        this.setupWscompileArgs();
    }

    private void setupWscompileForkCommand() {
        ClassLoader loader;
        for (loader = ((Object)((Object)this)).getClass().getClassLoader(); loader != null && !(loader instanceof AntClassLoader); loader = loader.getParent()) {
        }
        if (loader != null) {
            this.cmd.createClasspath(this.getProject()).append(new Path(this.getProject(), ((AntClassLoader)loader).getClasspath()));
        }
        this.cmd.createClasspath(this.getProject()).append(this.getClasspath());
        this.cmd.setClassname("com.sun.tools.ws.WsGen");
        this.setupWscompileArgs();
    }

    private void setupWscompileArgs() {
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.getDestdir());
        }
        if (this.getDebug()) {
            this.cmd.createArgument().setValue("-g");
        }
        if (this.getExtension()) {
            this.cmd.createArgument().setValue("-extension");
        }
        if (this.getKeep()) {
            this.cmd.createArgument().setValue("-keep");
        }
        if (this.getGenwsdl()) {
            String tmp = "-wsdl";
            if (this.protocol.length() > 0) {
                tmp = tmp + ":" + this.protocol;
            }
            this.cmd.createArgument().setValue(tmp);
            if (this.serviceName != null && this.serviceName.length() > 0) {
                this.cmd.createArgument().setValue("-servicename");
                this.cmd.createArgument().setValue(this.serviceName);
            }
            if (this.portName != null && this.portName.length() > 0) {
                this.cmd.createArgument().setValue("-portname");
                this.cmd.createArgument().setValue(this.portName);
            }
        }
        if (null != this.getResourcedestdir() && !this.getResourcedestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-r");
            this.cmd.createArgument().setFile(this.getResourcedestdir());
        }
        if (this.getOptimize()) {
            this.cmd.createArgument().setValue("-O");
        }
        if (null != this.getSourcedestdir() && !this.getSourcedestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-s");
            this.cmd.createArgument().setFile(this.getSourcedestdir());
        }
        if (this.getVerbose()) {
            this.cmd.createArgument().setValue("-verbose");
        }
        if (this.getSei() != null) {
            this.cmd.createArgument().setValue(this.getSei());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        LogOutputStream logstr = null;
        boolean ok = false;
        try {
            if (this.fork) {
                this.setupWscompileForkCommand();
            } else {
                if (this.cmd.getVmCommand().size() > 1) {
                    this.log("JVM args ignored when same JVM is used.", 1);
                }
                this.setupWscompileCommand();
            }
            if (this.fork) {
                int status;
                if (this.verbose) {
                    this.log("command line: wsgen " + this.cmd.toString());
                }
                ok = (status = this.run(this.cmd.getCommandline())) == 0;
            } else {
                if (this.verbose) {
                    this.log("command line: wsgen " + this.cmd.getJavaCommand().toString());
                }
                logstr = new LogOutputStream((Task)this, 1);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                try {
                    WsgenTool compTool = new WsgenTool((OutputStream)logstr);
                    ok = compTool.run(this.cmd.getJavaCommand().getArguments());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            if (!ok) {
                if (!this.verbose) {
                    this.log("Command invoked: wsgen " + this.cmd.toString());
                }
                throw new BuildException("wsgen failed", this.location);
            }
        }
        catch (Exception ex) {
            if (this.failonerror) {
                if (ex instanceof BuildException) {
                    throw (BuildException)((Object)ex);
                }
                throw new BuildException("Error starting wsgen: ", (Throwable)ex, this.getLocation());
            }
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.getProject().log(sw.toString(), 1);
        }
        finally {
            try {
                if (logstr != null) {
                    logstr.close();
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private int run(String[] command) throws BuildException {
        Object fos = null;
        Execute exe = null;
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.project);
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

