/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.framework.ParseException;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.tools.ws.wsdl.parser.InternalizationLogic;
import com.sun.xml.ws.api.wsdl.parser.MetaDataResolver;
import com.sun.xml.ws.api.wsdl.parser.MetadataResolverFactory;
import com.sun.xml.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataFinder
extends DOMForest {
    public boolean isMexMetadata;
    private String rootWSDL;
    private Set<String> rootWsdls = new HashSet<String>();

    public MetadataFinder(InternalizationLogic logic, WsimportOptions options, ErrorReceiver errReceiver) {
        super(logic, options, errReceiver);
    }

    public void parseWSDL() {
        for (InputSource value : this.options.getWSDLs()) {
            String systemID = value.getSystemId();
            this.errorReceiver.pollAbort();
            Element doc = null;
            try {
                Document dom;
                if (this.options.entityResolver != null) {
                    value = this.options.entityResolver.resolveEntity(null, systemID);
                }
                if (value == null) {
                    value = new InputSource(systemID);
                }
                if ((doc = (dom = this.parse(value, true)).getDocumentElement()) == null) continue;
                if (doc.getNamespaceURI() == null || !doc.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !doc.getLocalName().equals("definitions")) {
                    throw new SAXParseException(WsdlMessages.INVALID_WSDL(systemID, WSDLConstants.QNAME_DEFINITIONS, doc.getNodeName(), this.locatorTable.getStartLocation(doc).getLineNumber()), this.locatorTable.getStartLocation(doc));
                }
            }
            catch (FileNotFoundException e) {
                this.errorReceiver.error(WsdlMessages.FILE_NOT_FOUND(systemID), e);
                return;
            }
            catch (IOException e) {
                doc = this.getFromMetadataResolver(systemID, e);
            }
            catch (SAXParseException e) {
                doc = this.getFromMetadataResolver(systemID, e);
            }
            catch (SAXException e) {
                doc = this.getFromMetadataResolver(systemID, e);
            }
            if (doc == null) continue;
            NodeList schemas = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < schemas.getLength(); ++i) {
                if (this.inlinedSchemaElements.contains(schemas.item(i))) continue;
                this.inlinedSchemaElements.add((Element)schemas.item(i));
            }
        }
        this.identifyRootWslds();
    }

    @Nullable
    public String getRootWSDL() {
        return this.rootWSDL;
    }

    @NotNull
    public Set<String> getRootWSDLs() {
        return this.rootWsdls;
    }

    private void identifyRootWslds() {
        for (String location : this.rootDocuments) {
            Element definition;
            Document doc = this.get(location);
            if (doc == null || (definition = doc.getDocumentElement()) == null || definition.getLocalName() == null || definition.getNamespaceURI() == null || !definition.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !definition.getLocalName().equals("definitions")) continue;
            this.rootWsdls.add(location);
            NodeList nl = definition.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
            if (nl.getLength() <= 0) continue;
            this.rootWSDL = location;
        }
        if (this.rootWSDL == null) {
            StringBuffer strbuf = new StringBuffer();
            for (String str : this.rootWsdls) {
                strbuf.append(str);
                strbuf.append('\n');
            }
            this.errorReceiver.error(null, WsdlMessages.FAILED_NOSERVICE(strbuf.toString()));
        }
    }

    @Nullable
    private Element getFromMetadataResolver(String systemId, Exception ex) {
        ServiceDescriptor serviceDescriptor = null;
        for (MetadataResolverFactory resolverFactory : ServiceFinder.find(MetadataResolverFactory.class)) {
            MetaDataResolver resolver2 = resolverFactory.metadataResolver(this.options.entityResolver);
            try {
                serviceDescriptor = resolver2.resolve(new URI(systemId));
                if (serviceDescriptor == null) continue;
                break;
            }
            catch (URISyntaxException e) {
                throw new ParseException(e);
            }
        }
        if (serviceDescriptor != null) {
            this.errorReceiver.warning(new SAXParseException(WsdlMessages.TRY_WITH_MEX(ex.getMessage()), null, ex));
            return this.parseMetadata(systemId, serviceDescriptor);
        }
        this.errorReceiver.error(null, WsdlMessages.PARSING_UNABLE_TO_GET_METADATA(ex.getMessage(), WscompileMessages.WSIMPORT_NO_WSDL(systemId)), ex);
        return null;
    }

    private Element parseMetadata(@NotNull String systemId, @NotNull ServiceDescriptor serviceDescriptor) {
        Node n;
        List mexWsdls = serviceDescriptor.getWSDLs();
        List mexSchemas = serviceDescriptor.getSchemas();
        Document root = null;
        for (Source src : mexWsdls) {
            NodeList nl;
            Document doc;
            if (!(src instanceof DOMSource)) continue;
            n = ((DOMSource)src).getNode();
            if (n.getNodeType() == 1 && n.getOwnerDocument() == null) {
                doc = DOMUtil.createDom();
                doc.importNode(n, true);
            } else {
                doc = n.getOwnerDocument();
            }
            if (root == null && (nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service")).getLength() > 0) {
                root = doc;
                this.rootWSDL = src.getSystemId();
            }
            nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element imp = (Element)nl.item(i);
                String loc = imp.getAttribute("location");
                if (loc == null || this.externalReferences.contains(loc)) continue;
                this.externalReferences.add(loc);
            }
            if (this.core.keySet().contains(systemId)) {
                this.core.remove(systemId);
            }
            this.core.put(src.getSystemId(), doc);
            this.isMexMetadata = true;
        }
        for (Source src : mexSchemas) {
            if (!(src instanceof DOMSource)) continue;
            n = ((DOMSource)src).getNode();
            Element e = n.getNodeType() == 1 ? (Element)n : DOMUtil.getFirstElementChild((Node)n);
            this.inlinedSchemaElements.add(e);
        }
        return root.getDocumentElement();
    }
}

