/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types.soapencoding;

import java.io.IOException;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.types.soapencoding.ExtensionMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;

public class Base64Binary
implements ADBBean {
    protected DataHandler localBase64Binary;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return "SOAP-ENC";
        }
        return BeanUtil.getUniquePrefix();
    }

    public DataHandler getBase64Binary() {
        return this.localBase64Binary;
    }

    public void setBase64Binary(DataHandler param) {
        this.localBase64Binary = param;
    }

    public String toString() {
        return this.localBase64Binary.toString();
    }

    public OMElement getOMElement(QName parentQName, OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName);
        return factory.createOMElement(dataSource, parentQName);
    }

    public void serialize(QName parentQName, XMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, xmlWriter, false);
    }

    public void serialize(QName parentQName, XMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = Base64Binary.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix(xmlWriter, "http://schemas.xmlsoap.org/soap/encoding/");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":base64Binary", xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "base64Binary", xmlWriter);
            }
        }
        if (this.localBase64Binary != null) {
            try {
                XMLStreamWriterUtils.writeDataHandler(xmlWriter, this.localBase64Binary, null, true);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname2, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname2.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname2.getLocalPart() : qname2.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname2, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname2.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = Base64Binary.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString(qname2));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString(qname2));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString(qname2));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = Base64Binary.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString(qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            String uri;
            prefix = Base64Binary.generatePrefix(namespace);
            NamespaceContext nsContext = xmlWriter.getNamespaceContext();
            while ((uri = nsContext.getNamespaceURI(prefix)) != null && uri.length() != 0) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public static class Factory {
        public static Base64Binary fromString(String value, String namespaceURI) {
            Base64Binary returnValue = new Base64Binary();
            returnValue.setBase64Binary(ConverterUtil.convertToBase64Binary(value));
            return returnValue;
        }

        public static Base64Binary fromString(XMLStreamReader xmlStreamReader, String content) {
            if (content.indexOf(":") > -1) {
                String prefix = content.substring(0, content.indexOf(":"));
                String namespaceUri = xmlStreamReader.getNamespaceContext().getNamespaceURI(prefix);
                return Factory.fromString(content, namespaceUri);
            }
            return Factory.fromString(content, "");
        }

        public static Base64Binary parse(XMLStreamReader reader) throws Exception {
            Base64Binary object = new Base64Binary();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"base64Binary".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (Base64Binary)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector handledAttributes = new Vector();
                while (!reader.isEndElement()) {
                    if (reader.isStartElement() || reader.hasText()) {
                        if (reader.isStartElement() || reader.hasText()) {
                            object.setBase64Binary(XMLStreamReaderUtils.getDataHandlerFromElement(reader));
                            continue;
                        }
                        throw new ADBException("Unexpected subelement " + reader.getLocalName());
                    }
                    reader.next();
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

