/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.activation.DataHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.BeanInfoCache;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.MultirefHelper;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.StreamWrapper;
import org.apache.ws.commons.schema.constants.Constants;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtil {
    private static int nsCount = 1;

    public static XMLStreamReader getPullParser(Object beanObject, QName beanName, TypeTable typeTable, boolean qualified, boolean processingDocLitBare) {
        QName qNamefortheType;
        Class<?> beanClass = beanObject.getClass();
        List<Object> propertyQnameValueList = BeanUtil.getPropertyQnameList(beanObject, beanClass, beanName, typeTable, qualified, processingDocLitBare);
        ArrayList<QName> objectAttributes = new ArrayList<QName>();
        if (typeTable != null && (qNamefortheType = typeTable.getQNamefortheType(BeanUtil.getClassName(beanClass))) != null) {
            objectAttributes.add(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"));
            objectAttributes.add(qNamefortheType);
        }
        return new ADBXMLStreamReaderImpl(beanName, propertyQnameValueList.toArray(), objectAttributes.toArray(), typeTable, qualified);
    }

    private static String getClassName(Class type) {
        String name = type.getName();
        if (name.indexOf("$") > 0) {
            name = name.replace('$', '_');
        }
        return name;
    }

    private static BeanInfo getBeanInfo(Class beanClass, Class beanSuperclass) throws IntrospectionException {
        return BeanInfoCache.getCachedBeanInfo(beanClass, beanSuperclass);
    }

    private static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        return BeanUtil.getBeanInfo(beanClass, null);
    }

    private static List<Object> getPropertyQnameList(Object beanObject, Class<?> beanClass, QName beanName, TypeTable typeTable, boolean qualified, boolean processingDocLitBare) {
        Class<?> supperClass = beanClass.getSuperclass();
        List<Object> propertyQnameValueList = !BeanUtil.getQualifiedName(supperClass.getPackage()).startsWith("java.") ? BeanUtil.getPropertyQnameList(beanObject, supperClass, beanName, typeTable, qualified, processingDocLitBare) : new ArrayList();
        try {
            PropertyDescriptor[] properties;
            QName elemntNameSpace = null;
            if (typeTable != null && qualified) {
                QName qNamefortheType = typeTable.getQNamefortheType(beanClass.getName());
                if (qNamefortheType == null) {
                    qNamefortheType = typeTable.getQNamefortheType(beanClass.getPackage().getName());
                }
                if (qNamefortheType == null) {
                    throw new AxisFault("Mapping qname not fond for the package: " + beanObject.getClass().getPackage().getName());
                }
                elemntNameSpace = new QName(qNamefortheType.getNamespaceURI(), "elementName", qNamefortheType.getPrefix());
            }
            AxisService axisService = null;
            if (MessageContext.getCurrentMessageContext() != null) {
                axisService = MessageContext.getCurrentMessageContext().getAxisService();
            }
            BeanExcludeInfo beanExcludeInfo = null;
            if (axisService != null && axisService.getExcludeInfo() != null) {
                beanExcludeInfo = axisService.getExcludeInfo().getBeanExcludeInfoForClass(beanClass.getName());
            }
            BeanInfo beanInfo = BeanUtil.getBeanInfo(beanClass, beanClass.getSuperclass());
            for (PropertyDescriptor property : properties = beanInfo.getPropertyDescriptors()) {
                Object qNamefortheType;
                OMFactory fac;
                Method writeMethod;
                Class<?> propertyType;
                String propertyName = property.getName();
                Class<?> ptype = property.getPropertyType();
                if (propertyName.equals("class") || beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName) || ptype == null) continue;
                Method readMethod = property.getReadMethod();
                if (readMethod == null && (propertyType = property.getPropertyType()) == Boolean.class && (writeMethod = property.getWriteMethod()) != null) {
                    String tmpWriteMethodName = writeMethod.getName();
                    PropertyDescriptor tmpPropDesc = new PropertyDescriptor(property.getName(), beanObject.getClass(), "is" + tmpWriteMethodName.substring(3), tmpWriteMethodName);
                    readMethod = tmpPropDesc.getReadMethod();
                }
                if (readMethod == null) {
                    throw new AxisFault("Property '" + propertyName + "' in bean class '" + beanClass.getName() + "'is not readable.");
                }
                readMethod.setAccessible(true);
                Object value = readMethod.invoke(beanObject, new Object[0]);
                if (SimpleTypeMapper.isSimpleType(ptype)) {
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value == null ? null : SimpleTypeMapper.getStringValue(value));
                    continue;
                }
                if (SimpleTypeMapper.isDomDocument(ptype)) {
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    fac = OMAbstractFactory.getOMFactory();
                    propertyQnameValueList.add(BeanUtil.convertDOMtoOM(fac, value));
                    continue;
                }
                if (ptype.isArray()) {
                    if (SimpleTypeMapper.isSimpleType(ptype.getComponentType())) {
                        if (value != null) {
                            if (Byte.TYPE.equals(ptype.getComponentType())) {
                                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                                propertyQnameValueList.add(Base64Utils.encode((byte[])value));
                                continue;
                            }
                            int i1 = Array.getLength(value);
                            for (int j = 0; j < i1; ++j) {
                                Object o = Array.get(value, j);
                                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                                propertyQnameValueList.add(o == null ? null : SimpleTypeMapper.getStringValue(o));
                            }
                            continue;
                        }
                        BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                        propertyQnameValueList.add(value);
                        continue;
                    }
                    if (value != null) {
                        for (Object o : (Object[])value) {
                            BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                            QName propertyQName = null;
                            propertyQName = elemntNameSpace != null ? new QName(elemntNameSpace.getNamespaceURI(), propertyName, elemntNameSpace.getPrefix()) : new QName(propertyName);
                            if (SimpleTypeMapper.isObjectArray(o.getClass()) || SimpleTypeMapper.isMultidimensionalObjectArray(o.getClass())) {
                                QName itemName = qualified ? new QName(elemntNameSpace.getNamespaceURI(), "array", elemntNameSpace.getPrefix()) : new QName("array");
                                propertyQnameValueList.add(BeanUtil.getOMElement(propertyQName, (Object[])o, itemName, qualified, typeTable));
                                continue;
                            }
                            if (SimpleTypeMapper.isObjectArray(value.getClass())) {
                                OMFactory fac2 = OMAbstractFactory.getOMFactory();
                                OMElement element = fac2.createOMElement(propertyQName);
                                element.addChild(fac2.createOMText(SimpleTypeMapper.getStringValue(o)));
                                BeanUtil.addInstanceTypeAttribute(fac2, element, o, typeTable);
                                propertyQnameValueList.add(element);
                                continue;
                            }
                            propertyQnameValueList.add(o);
                        }
                        continue;
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value);
                    continue;
                }
                if (SimpleTypeMapper.isCollection(ptype) && value != null) {
                    if (typeTable != null) {
                        fac = OMAbstractFactory.getOMFactory();
                        qNamefortheType = null;
                        qNamefortheType = typeTable.getComplexSchemaMap().get(BeanUtil.getClassName(beanClass));
                        Type genericType = property.getReadMethod().getGenericReturnType();
                        OMElement collection = BeanUtil.getCollectionElement(fac, genericType, (Collection)value, propertyName, null, (QName)qNamefortheType, typeTable, qualified);
                        Iterator childItr = collection.getChildren();
                        while (childItr.hasNext()) {
                            BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                            propertyQnameValueList.add(childItr.next());
                        }
                        continue;
                    }
                    Collection objList = (Collection)value;
                    if (objList != null && objList.size() > 0) {
                        for (Object o : objList) {
                            if (SimpleTypeMapper.isSimpleType(o)) {
                                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                                propertyQnameValueList.add(o);
                                continue;
                            }
                            BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                            propertyQnameValueList.add(o);
                        }
                        continue;
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value);
                    continue;
                }
                if (SimpleTypeMapper.isMap(ptype) && value != null) {
                    fac = OMAbstractFactory.getOMFactory();
                    qNamefortheType = typeTable.getComplexSchemaMap().get(BeanUtil.getClassName(beanClass));
                    OMNamespace ns = fac.createOMNamespace(((QName)qNamefortheType).getNamespaceURI(), ((QName)qNamefortheType).getPrefix());
                    List<OMElement> mapEntries = BeanUtil.getMapElement(fac, ptype, (Map)value, typeTable, qualified);
                    OMElement map = fac.createOMElement(propertyName, ((QName)qNamefortheType).getNamespaceURI(), ((QName)qNamefortheType).getPrefix());
                    for (OMElement ele : mapEntries) {
                        map.addChild(ele);
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(map);
                    continue;
                }
                if (SimpleTypeMapper.isEnum(ptype)) {
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value == null ? null : SimpleTypeMapper.getStringValue(value.toString()));
                    continue;
                }
                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                if (Object.class.equals(ptype) && value != null) {
                    OMElement element;
                    QName qNamefortheType2 = typeTable.getComplexSchemaMap().get(BeanUtil.getClassName(beanClass));
                    OMFactory fac3 = OMAbstractFactory.getOMFactory();
                    QName elementName = elemntNameSpace != null ? new QName(elemntNameSpace.getNamespaceURI(), property.getName(), qNamefortheType2.getPrefix()) : new QName(property.getName());
                    if (SimpleTypeMapper.isSimpleType(value)) {
                        element = fac3.createOMElement(elementName);
                        element.addChild(fac3.createOMText(SimpleTypeMapper.getStringValue(value)));
                    } else {
                        XMLStreamReader xr = BeanUtil.getPullParser(value, elementName, typeTable, qualified, false);
                        OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(), new StreamWrapper(xr));
                        element = stAXOMBuilder.getDocumentElement();
                    }
                    BeanUtil.addInstanceTypeAttribute(fac3, element, value, typeTable);
                    propertyQnameValueList.add(element);
                    continue;
                }
                propertyQnameValueList.add(value);
            }
            return propertyQnameValueList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addTypeQname(QName elemntNameSpace, List<Object> propertyQnameValueList, PropertyDescriptor propDesc, QName beanName, boolean processingDocLitBare) {
        if (elemntNameSpace != null) {
            propertyQnameValueList.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
        } else if (processingDocLitBare) {
            propertyQnameValueList.add(new QName(propDesc.getName()));
        } else {
            propertyQnameValueList.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
        }
    }

    public static XMLStreamReader getPullParser(Object beanObject) {
        String className = beanObject.getClass().getName();
        if (className.indexOf(".") > 0) {
            className = className.substring(className.lastIndexOf(46) + 1, className.length());
        }
        return BeanUtil.getPullParser(beanObject, new QName(className), null, false, false);
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, ObjectSupplier objectSupplier, String arrayLocalName) throws AxisFault {
        try {
            PropertyDescriptor[] propDescs;
            QName nilAttName;
            AxisService axisService;
            MessageContext messageContext;
            String instanceTypeName = null;
            if (beanClass != null && !beanClass.isArray()) {
                instanceTypeName = beanElement.getAttributeValue(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
            }
            boolean hexBin = false;
            if (instanceTypeName != null && (messageContext = MessageContext.getCurrentMessageContext()) != null && (axisService = messageContext.getAxisService()) != null) {
                TypeTable typeTable;
                String className;
                QName typeQName = beanElement.resolveQName(instanceTypeName);
                if (Constants.XSD_HEXBIN.equals(typeQName)) {
                    hexBin = true;
                }
                if ((className = (typeTable = axisService.getTypeTable()).getClassNameForQName(typeQName)) != null) {
                    try {
                        beanClass = Loader.loadClass(axisService.getClassLoader(), className);
                    }
                    catch (ClassNotFoundException ce) {
                        throw AxisFault.makeFault(ce);
                    }
                } else {
                    throw new AxisFault("Unknow type " + typeQName);
                }
            }
            if (beanElement.getAttribute(nilAttName = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi")) != null) {
                return null;
            }
            if (beanClass.getName().equals(DataHandler.class.getName())) {
                return SimpleTypeMapper.getDataHandler(beanElement, hexBin);
            }
            if (beanClass.isArray()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                Class<?> arrayClassType = beanClass.getComponentType();
                if ("byte".equals(arrayClassType.getName())) {
                    OMElement partElement = null;
                    Iterator iter = beanElement.getChildElements();
                    while (iter.hasNext() && !(partElement = (OMElement)iter.next()).getLocalName().equals(arrayLocalName)) {
                    }
                    return Base64Utils.decode(partElement.getText());
                }
                Iterator parts = beanElement.getChildElements();
                while (parts.hasNext()) {
                    Object objValue = parts.next();
                    if (!(objValue instanceof OMElement)) continue;
                    OMElement omElement = (OMElement)objValue;
                    if (arrayLocalName != null && !arrayLocalName.equals(omElement.getLocalName())) continue;
                    Object obj = BeanUtil.deserialize(arrayClassType, omElement, objectSupplier, "array");
                    valueList.add(obj);
                }
                return ConverterUtil.convertToArray(arrayClassType, valueList);
            }
            if (SimpleTypeMapper.isDomDocument(beanClass)) {
                return BeanUtil.convertOMtoDOM(beanElement);
            }
            if (XMLGregorianCalendar.class.getName().equals(beanClass.getName())) {
                return BeanUtil.getXMLGregorianCalendar(beanElement);
            }
            if (SimpleTypeMapper.isSimpleType(beanClass)) {
                return BeanUtil.getSimpleTypeObjectChecked(beanClass, beanElement);
            }
            if ("java.lang.Object".equals(beanClass.getName())) {
                return beanElement.getFirstOMChild();
            }
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String string1 = (String)o1;
                    String string2 = (String)o2;
                    return string1.compareToIgnoreCase(string2);
                }
            };
            TreeMap<String, PropertyDescriptor> properties = new TreeMap<String, PropertyDescriptor>(comparator);
            BeanInfo beanInfo = BeanUtil.getBeanInfo(beanClass);
            for (PropertyDescriptor proprty : propDescs = beanInfo.getPropertyDescriptors()) {
                properties.put(proprty.getName(), proprty);
            }
            Iterator elements = beanElement.getChildren();
            Object beanObj = objectSupplier.getObject(beanClass);
            while (elements.hasNext()) {
                Type type;
                Object partObj;
                String nilValue;
                Object objValue = elements.next();
                if (!(objValue instanceof OMElement)) continue;
                OMElement parts = (OMElement)objValue;
                OMAttribute attribute = parts.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
                String partsLocalName = parts.getLocalName();
                PropertyDescriptor prty = (PropertyDescriptor)properties.remove(partsLocalName);
                if (prty == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.getName().equals("class")) continue;
                boolean isNil = false;
                if (attribute != null && ("true".equals(nilValue = attribute.getAttributeValue()) || "1".equals(nilValue))) {
                    isNil = true;
                }
                if (isNil) {
                    partObj = null;
                } else if (SimpleTypeMapper.isSimpleType(parameters)) {
                    partObj = SimpleTypeMapper.getSimpleTypeObject(parameters, parts);
                } else if (SimpleTypeMapper.isHashSet(parameters)) {
                    partObj = SimpleTypeMapper.getHashSet((OMElement)parts.getParent(), prty.getName());
                } else if (SimpleTypeMapper.isCollection(parameters)) {
                    type = prty.getReadMethod().getGenericReturnType();
                    partObj = BeanUtil.processGenericCollection(parts, type, null, objectSupplier);
                } else if (SimpleTypeMapper.isDataHandler(parameters)) {
                    partObj = SimpleTypeMapper.getDataHandler(parts);
                } else if (parameters.isArray()) {
                    partObj = BeanUtil.deserialize(parameters, (OMElement)parts.getParent(), objectSupplier, prty.getName());
                } else if (SimpleTypeMapper.isMap(parameters)) {
                    partObj = null;
                    type = prty.getReadMethod().getGenericReturnType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType aType = (ParameterizedType)type;
                        Type[] parameterArgTypes = aType.getActualTypeArguments();
                        partObj = BeanUtil.processGenericsMapElement(parameterArgTypes, (OMElement)parts.getParent(), null, parts.getChildren(), objectSupplier, beanClass);
                    } else {
                        Type[] parameterArgTypes = new Type[]{Object.class, Object.class};
                        partObj = BeanUtil.processGenericsMapElement(parameterArgTypes, (OMElement)parts.getParent(), null, parts.getChildren(), objectSupplier, beanClass);
                    }
                } else {
                    partObj = SimpleTypeMapper.isEnum(parameters) ? BeanUtil.processEnumObject(parameters, parts) : BeanUtil.deserialize(parameters, parts, objectSupplier, null);
                }
                Object[] parms = new Object[]{partObj};
                Method writeMethod = prty.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.setAccessible(true);
                writeMethod.invoke(beanObj, parms);
            }
            return beanObj;
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
        catch (DatatypeConfigurationException e) {
            throw new AxisFault("DatatypeConfigurationException : " + e);
        }
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, MultirefHelper helper, ObjectSupplier objectSupplier) throws AxisFault {
        Object beanObj;
        try {
            PropertyDescriptor[] propDescs;
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = BeanUtil.getBeanInfo(beanClass);
            for (PropertyDescriptor proprty : propDescs = beanInfo.getPropertyDescriptors()) {
                properties.put(proprty.getName(), proprty);
            }
            beanObj = objectSupplier.getObject(beanClass);
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                Object partObj;
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object child = elements.next();
                if (!(child instanceof OMElement) || (prty = (PropertyDescriptor)properties.get((partsLocalName = (parts = (OMElement)child).getLocalName()).toLowerCase())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.getName().equals("class")) continue;
                OMAttribute attr = MultirefHelper.processRefAtt(parts);
                if (attr != null) {
                    String refId = MultirefHelper.getAttvalue(attr);
                    partObj = helper.getObject(refId);
                    if (partObj == null) {
                        partObj = helper.processRef(parameters, refId, objectSupplier);
                    }
                } else {
                    partObj = SimpleTypeMapper.getSimpleTypeObject(parameters, parts);
                    if (partObj == null) {
                        partObj = BeanUtil.deserialize(parameters, parts, objectSupplier, null);
                    }
                }
                Object[] parms = new Object[]{partObj};
                Method writeMethod = prty.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.setAccessible(true);
                writeMethod.invoke(beanObj, parms);
            }
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
        return beanObj;
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes, ObjectSupplier objectSupplier) throws AxisFault {
        return BeanUtil.deserialize(response, javaTypes, objectSupplier, null, null);
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes, ObjectSupplier objectSupplier, String[] parameterNames, Method method) throws AxisFault {
        int length = javaTypes.length;
        int count = 0;
        Object[] retObjs = new Object[length];
        Iterator parts = response.getChildren();
        MultirefHelper helper = new MultirefHelper((OMElement)response.getParent());
        Type[] genericParameterTypes = null;
        if (method != null) {
            genericParameterTypes = method.getGenericParameterTypes();
        }
        Type genericType = null;
        while (parts.hasNext() && count < length) {
            Class paramClassType;
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            OMElement omElement = (OMElement)objValue;
            while (!(parameterNames == null || omElement.getQName().getLocalPart().startsWith("arg") || omElement.getQName().getLocalPart().startsWith("item") || omElement.getQName().getLocalPart().equals(parameterNames[count]) || (paramClassType = (Class)javaTypes[count]).getName().equals(OMElement.class.getName()))) {
                ++count;
            }
            String currentLocalName = omElement.getLocalName();
            Class classType = (Class)javaTypes[count];
            if (genericParameterTypes != null) {
                genericType = genericParameterTypes[count];
            }
            boolean bare = false;
            if (parameterNames == null) {
                bare = true;
            }
            omElement = BeanUtil.processElement(classType, omElement, helper, parts, currentLocalName, retObjs, count, objectSupplier, genericType, bare);
            while (omElement != null) {
                Class paramClassType2;
                ++count;
                while (!(parameterNames == null || omElement.getQName().getLocalPart().startsWith("arg") || omElement.getQName().getLocalPart().startsWith("item") || omElement.getQName().getLocalPart().equals(parameterNames[count]) || (paramClassType2 = (Class)javaTypes[count]).getName().equals(OMElement.class.getName()))) {
                    ++count;
                }
                currentLocalName = omElement.getLocalName();
                classType = (Class)javaTypes[count];
                if (genericParameterTypes != null) {
                    genericType = genericParameterTypes[count];
                }
                omElement = BeanUtil.processElement((Class)javaTypes[count], omElement, helper, parts, omElement.getLocalName(), retObjs, count, objectSupplier, genericType);
            }
            ++count;
        }
        for (int i = 0; i < length; ++i) {
            Class clazz = (Class)javaTypes[i];
            if (retObjs[i] != null || !clazz.isArray()) continue;
            retObjs[i] = Array.newInstance(clazz.getComponentType(), 0);
        }
        helper.clean();
        return retObjs;
    }

    private static OMElement processElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, String currentLocalName, Object[] retObjs, int count, ObjectSupplier objectSupplier, Type genericType) throws AxisFault {
        return BeanUtil.processElement(classType, omElement, helper, parts, currentLocalName, retObjs, count, objectSupplier, genericType, false);
    }

    private static OMElement processElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, String currentLocalName, Object[] retObjs, int count, ObjectSupplier objectSupplier, Type genericType, boolean bare) throws AxisFault {
        boolean isRef = false;
        OMAttribute omatribute = MultirefHelper.processRefAtt(omElement);
        if (omatribute != null) {
            isRef = true;
        }
        if (classType.isArray()) {
            boolean done = true;
            ArrayList<Object> valueList = new ArrayList<Object>();
            Class<?> arrayClassType = classType.getComponentType();
            if ("byte".equals(arrayClassType.getName())) {
                retObjs[count] = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier, genericType);
                return null;
            }
            valueList.add(BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier, genericType));
            while (parts.hasNext()) {
                Object objValue = parts.next();
                if (!(objValue instanceof OMElement)) continue;
                omElement = (OMElement)objValue;
                if (!currentLocalName.equals(omElement.getLocalName())) {
                    done = false;
                    break;
                }
                Object o = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier, genericType);
                valueList.add(o);
            }
            retObjs[count] = valueList.size() == 1 && valueList.get(0) == null ? null : ConverterUtil.convertToArray(arrayClassType, valueList);
            if (!done) {
                return omElement;
            }
        } else if (SimpleTypeMapper.isCollection(classType) && !isRef) {
            if (bare) {
                OMElement[] toReturn = new OMElement[1];
                parts = omElement.getChildren();
                retObjs[count] = BeanUtil.processGenericCollection(omElement.getFirstElement(), toReturn, genericType, helper, objectSupplier, parts, bare);
                for (OMNode node = omElement.getNextOMSibling(); node != null; node = node.getNextOMSibling()) {
                    if (!OMElement.class.isAssignableFrom(node.getClass())) continue;
                    return (OMElement)node;
                }
            } else {
                OMElement[] toReturn = new OMElement[1];
                retObjs[count] = BeanUtil.processGenericCollection(omElement, toReturn, genericType, helper, objectSupplier, parts, bare);
                if (toReturn[0] != null) {
                    return toReturn[0];
                }
            }
        } else {
            retObjs[count] = SimpleTypeMapper.isEnum(classType) ? BeanUtil.processEnumObject(classType, omElement) : BeanUtil.processObject(omElement, classType, helper, false, objectSupplier, genericType);
        }
        return null;
    }

    private static Collection<Object> processGenericsElement(Type classType, OMElement omElement, MultirefHelper helper, Iterator parts, ObjectSupplier objectSupplier, Type genericType) throws AxisFault {
        Collection<Object> valueList = BeanUtil.getCollectionInstance(genericType);
        while (parts.hasNext()) {
            ParameterizedType parameterizedClassType;
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            omElement = (OMElement)objValue;
            Object o = classType instanceof ParameterizedType ? (Collection.class.isAssignableFrom((Class)(parameterizedClassType = (ParameterizedType)classType).getRawType()) ? BeanUtil.processGenericCollection(omElement.getFirstElement(), classType, helper, objectSupplier) : (Map.class.isAssignableFrom((Class)parameterizedClassType.getRawType()) ? BeanUtil.processGenericsMapElement(parameterizedClassType.getActualTypeArguments(), omElement, helper, omElement.getChildren(), objectSupplier, parameterizedClassType) : BeanUtil.processObject(omElement, (Class)classType, helper, true, objectSupplier, genericType))) : BeanUtil.processObject(omElement, (Class)classType, helper, true, objectSupplier, genericType);
            valueList.add(o);
        }
        return valueList;
    }

    public static Object processObject(OMElement omElement, Class classType, MultirefHelper helper, boolean isArrayType, ObjectSupplier objectSupplier, Type generictype) throws AxisFault {
        boolean hasRef = false;
        OMAttribute omatribute = MultirefHelper.processRefAtt(omElement);
        String ref = null;
        if (omatribute != null) {
            hasRef = true;
            ref = MultirefHelper.getAttvalue(omatribute);
        }
        if (OMElement.class.isAssignableFrom(classType)) {
            if (hasRef) {
                OMElement elemnt = helper.getOMElement(ref);
                if (elemnt == null) {
                    return helper.processOMElementRef(ref);
                }
                return elemnt;
            }
            return omElement;
        }
        if (hasRef) {
            if (helper.getObject(ref) != null) {
                return helper.getObject(ref);
            }
            return helper.processRef(classType, generictype, ref, objectSupplier);
        }
        OMAttribute attribute = omElement.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
        if (attribute != null) {
            return null;
        }
        if (SimpleTypeMapper.isSimpleType(classType)) {
            if (isArrayType && "byte".equals(classType.getName())) {
                String value = omElement.getText();
                return Base64Utils.decode(value);
            }
            return BeanUtil.getSimpleTypeObjectChecked(classType, omElement);
        }
        if (SimpleTypeMapper.isCollection(classType)) {
            return BeanUtil.processGenericCollection(omElement, generictype, null, objectSupplier);
        }
        if (SimpleTypeMapper.isDataHandler(classType)) {
            return SimpleTypeMapper.getDataHandler(omElement);
        }
        if (SimpleTypeMapper.isDomDocument(classType)) {
            return BeanUtil.convertOMtoDOM(omElement);
        }
        if (SimpleTypeMapper.isMap(classType)) {
            if (generictype != null && generictype instanceof ParameterizedType) {
                ParameterizedType aType = (ParameterizedType)generictype;
                Type[] parameterArgTypes = aType.getActualTypeArguments();
                Iterator parts = omElement.getChildElements();
                return BeanUtil.processGenericsMapElement(parameterArgTypes, omElement, helper, parts, objectSupplier, generictype);
            }
            Type[] parameterArgTypes = new Type[]{Object.class, Object.class};
            Iterator parts = omElement.getChildElements();
            return BeanUtil.processGenericsMapElement(parameterArgTypes, omElement, helper, parts, objectSupplier, generictype);
        }
        if (SimpleTypeMapper.isEnum(classType)) {
            return BeanUtil.processEnumObject(classType, omElement);
        }
        return BeanUtil.deserialize(classType, omElement, objectSupplier, null);
    }

    public static Object processEnumObject(Class classType, OMElement omElement) throws AxisFault {
        String paraArgString = omElement.getText();
        Object enumIbj = paraArgString == null || paraArgString.length() == 0 ? null : Enum.valueOf(classType, paraArgString);
        return enumIbj;
    }

    public static OMElement getOMElement(QName opName, Object[] args, QName partName, boolean qualifed, TypeTable typeTable) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int argCount = 0;
        for (Object arg : args) {
            if (arg == null) {
                if (partName == null) {
                    objects.add("item" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(arg);
                continue;
            }
            if (arg instanceof Object[]) {
                if (partName == null) {
                    Object[] array;
                    for (Object o : array = (Object[])arg) {
                        if (o == null) {
                            objects.add("item" + argCount);
                            objects.add(o);
                            continue;
                        }
                        if (SimpleTypeMapper.isSimpleType(o)) {
                            objects.add("item" + argCount);
                            objects.add(SimpleTypeMapper.getStringValue(o));
                            continue;
                        }
                        objects.add(new QName("item" + argCount));
                        if (o instanceof OMElement) {
                            OMFactory fac = OMAbstractFactory.getOMFactory();
                            OMElement wrappingElement = fac.createOMElement("item" + argCount, null);
                            wrappingElement.addChild((OMElement)o);
                            objects.add(wrappingElement);
                            continue;
                        }
                        objects.add(o);
                    }
                } else {
                    objects.add(partName);
                    if (SimpleTypeMapper.isObjectArray(arg.getClass()) || SimpleTypeMapper.isMultidimensionalObjectArray(arg.getClass())) {
                        QName itemName = new QName(partName.getNamespaceURI(), "array", partName.getPrefix());
                        objects.add(BeanUtil.getOMElement(partName, (Object[])arg, itemName, qualifed, typeTable));
                    } else {
                        objects.add(arg);
                    }
                }
            } else if (SimpleTypeMapper.isSimpleType(arg)) {
                OMElement element;
                OMFactory fac = OMAbstractFactory.getOMFactory();
                if (partName != null) {
                    element = fac.createOMElement(partName, null);
                } else {
                    String eleName = "arg" + argCount;
                    element = fac.createOMElement(eleName, null);
                }
                element.addChild(fac.createOMText(SimpleTypeMapper.getStringValue(arg)));
                if (SimpleTypeMapper.isObjectArray(args.getClass())) {
                    BeanUtil.addInstanceTypeAttribute(fac, element, arg, typeTable);
                }
                objects.add(element.getQName());
                objects.add(element);
            } else {
                OMElement wrappingElement;
                OMFactory fac;
                if (partName == null) {
                    objects.add(new QName("arg" + argCount));
                } else {
                    objects.add(partName);
                }
                if (arg instanceof OMElement) {
                    fac = OMAbstractFactory.getOMFactory();
                    if (partName == null) {
                        wrappingElement = fac.createOMElement("arg" + argCount, null);
                        wrappingElement.addChild((OMElement)arg);
                    } else {
                        wrappingElement = fac.createOMElement(partName, null);
                        wrappingElement.addChild((OMElement)arg);
                    }
                    objects.add(wrappingElement);
                } else if (arg instanceof byte[]) {
                    objects.add(Base64Utils.encode((byte[])arg));
                } else if (SimpleTypeMapper.isDataHandler(arg.getClass())) {
                    fac = OMAbstractFactory.getOMFactory();
                    wrappingElement = partName == null ? fac.createOMElement("arg" + argCount, null) : fac.createOMElement(partName, null);
                    OMText text = fac.createOMText(arg, true);
                    wrappingElement.addChild(text);
                    objects.add(wrappingElement);
                } else if (SimpleTypeMapper.isEnum(arg.getClass())) {
                    objects.add(arg.toString());
                } else {
                    objects.add(arg);
                }
            }
            ++argCount;
        }
        ADBXMLStreamReaderImpl xr = new ADBXMLStreamReaderImpl(opName, objects.toArray(), null, typeTable, qualifed);
        StreamWrapper parser = new StreamWrapper(xr);
        OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getSOAP11Factory(), parser);
        return stAXOMBuilder.getDocumentElement();
    }

    public static synchronized String getUniquePrifix() {
        return BeanUtil.getUniquePrefix();
    }

    public static synchronized String getUniquePrefix() {
        if (nsCount > 1000) {
            nsCount = 1;
        }
        return "s" + nsCount++;
    }

    private static String getQualifiedName(Package packagez) {
        if (packagez != null) {
            return packagez.getName();
        }
        return "";
    }

    private static Object getSimpleTypeObjectChecked(Class classType, OMElement omElement) throws AxisFault {
        try {
            return SimpleTypeMapper.getSimpleTypeObject(classType, omElement);
        }
        catch (NumberFormatException e) {
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            QName faultCode = msgContext != null ? msgContext.getEnvelope().getVersion().getSenderFaultCode() : null;
            throw new AxisFault("Invalid value \"" + omElement.getText() + "\" for element " + omElement.getLocalName(), faultCode, (Throwable)e);
        }
    }

    public static void addInstanceTypeAttribute(OMFactory fac, OMElement element, Object resObject, TypeTable typeTable) {
        if (typeTable == null) {
            return;
        }
        OMNamespace xsiNS = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        OMNamespace xsdNS = fac.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xs");
        element.declareNamespace(xsiNS);
        element.declareNamespace(xsdNS);
        QName xsdType = typeTable.getSchemaTypeName(resObject.getClass().getName());
        String attrValue = xsdType.getPrefix() + ":" + xsdType.getLocalPart();
        element.addAttribute("type", attrValue, xsiNS);
    }

    public static OMDocument convertOMtoDOM(OMContainer omElement) {
        OMFactory doomFactory = OMAbstractFactory.getMetaFactory("dom").getOMFactory();
        OMXMLParserWrapper doomBuilder = OMXMLBuilderFactory.createStAXOMBuilder(doomFactory, omElement.getXMLStreamReader());
        OMDocument domElement = doomBuilder.getDocument();
        return domElement;
    }

    public static OMElement convertDOMtoOM(OMFactory fac, Object document) {
        if (document == null) {
            return null;
        }
        if (document instanceof OMDocument) {
            return ((OMDocument)document).getOMDocumentElement();
        }
        return OMXMLBuilderFactory.createOMBuilder((Document)document, false).getDocumentElement(true);
    }

    public static Map<Object, Object> processGenericsMapElement(Type[] parameterArgTypes, OMElement omElement, MultirefHelper helper, Iterator parts, ObjectSupplier objectSupplier, Type genericType) throws AxisFault {
        Map<Object, Object> valueMap = BeanUtil.getMapInstance(genericType);
        while (parts.hasNext()) {
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement) || (omElement = (OMElement)objValue) == null) continue;
            Iterator entryParts = omElement.getChildren();
            Object entryKey = null;
            Object entryValue = null;
            while (entryParts.hasNext()) {
                objValue = entryParts.next();
                if (!(objValue instanceof OMElement)) continue;
                omElement = (OMElement)objValue;
                if (omElement.getLocalName().equals("key")) {
                    entryKey = BeanUtil.processMapParameterObject(parameterArgTypes[0], omElement, helper, objectSupplier, genericType);
                    continue;
                }
                if (!omElement.getLocalName().equals("value")) continue;
                entryValue = BeanUtil.processMapParameterObject(parameterArgTypes[1], omElement, helper, objectSupplier, genericType);
            }
            if (entryKey == null) continue;
            valueMap.put(entryKey, entryValue);
        }
        return valueMap;
    }

    public static List<OMElement> getMapElement(OMFactory fac, Type type, Map results, TypeTable typeTable, boolean elementFormDefault) {
        Iterator keyItr = results.keySet().iterator();
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        OMNamespace ns = null;
        Object keyType = Object.class;
        Object valueType = Object.class;
        if (elementFormDefault) {
            ns = fac.createOMNamespace("http://ws.apache.org/namespaces/axis2/map", "map");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)type;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            keyType = parameterArgTypes[0];
            valueType = parameterArgTypes[1];
        }
        while (keyItr.hasNext()) {
            Iterator valItr;
            QName valueName;
            QName keyName;
            Object key = keyItr.next();
            if (key == null) continue;
            Object value = results.get(key);
            ArrayList<Object> properties = new ArrayList<Object>();
            if (elementFormDefault) {
                keyName = new QName(ns.getNamespaceURI(), "key", ns.getPrefix());
                valueName = new QName(ns.getNamespaceURI(), "value", ns.getPrefix());
            } else {
                keyName = new QName("key");
                valueName = new QName("value");
            }
            Object kValue = BeanUtil.getMapParameterElement(fac, "key", key, (Type)keyType, typeTable, ns, elementFormDefault);
            Object vValue = BeanUtil.getMapParameterElement(fac, "value", value, (Type)valueType, typeTable, ns, elementFormDefault);
            if (Iterator.class.isAssignableFrom(kValue.getClass())) {
                valItr = (Iterator)kValue;
                while (valItr.hasNext()) {
                    properties.add(keyName);
                    properties.add(valItr.next());
                }
            } else {
                properties.add(keyName);
                properties.add(kValue);
            }
            if (vValue != null && Iterator.class.isAssignableFrom(vValue.getClass())) {
                valItr = (Iterator)vValue;
                while (valItr.hasNext()) {
                    properties.add(valueName);
                    properties.add(valItr.next());
                }
            } else {
                properties.add(valueName);
                properties.add(vValue);
            }
            QName entryQName = elementFormDefault ? new QName(ns.getNamespaceURI(), "entry", ns.getPrefix()) : new QName("entry");
            ADBXMLStreamReaderImpl pullParser = new ADBXMLStreamReaderImpl(entryQName, properties.toArray(), null, typeTable, elementFormDefault);
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), new StreamWrapper(pullParser));
            OMElement omEntry = stAXOMBuilder.getDocumentElement();
            list.add(omEntry);
        }
        return list;
    }

    private static Object processMapParameterObject(Type paraType, OMElement omElement, MultirefHelper helper, ObjectSupplier objectSupplier, Type genericType) throws AxisFault {
        if (paraType instanceof ParameterizedType) {
            if (Map.class.isAssignableFrom((Class)((ParameterizedType)paraType).getRawType())) {
                return BeanUtil.processGenericsMapElement(((ParameterizedType)paraType).getActualTypeArguments(), omElement, helper, omElement.getChildren(), objectSupplier, paraType);
            }
            if (Collection.class.isAssignableFrom((Class)((ParameterizedType)paraType).getRawType())) {
                return BeanUtil.processGenericCollection(omElement, (ParameterizedType)paraType, helper, objectSupplier);
            }
            throw new AxisFault("Map parameter does not support for " + ((ParameterizedType)paraType).getRawType());
        }
        return BeanUtil.processObject(omElement, (Class)paraType, helper, true, objectSupplier, genericType);
    }

    private static Map<Object, Object> getMapInstance(Type genericType) {
        Class rowType = genericType instanceof ParameterizedType ? (Class)((ParameterizedType)genericType).getRawType() : (Class)genericType;
        if (Map.class.getName().equals(rowType.getName())) {
            return new HashMap<Object, Object>();
        }
        if (ConcurrentMap.class.getName().equals(rowType.getName())) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (SortedMap.class.getName().equals(rowType.getName())) {
            return new TreeMap<Object, Object>();
        }
        try {
            return (Map)rowType.newInstance();
        }
        catch (Exception e) {
            return new HashMap<Object, Object>();
        }
    }

    private static Object getMapParameterElement(OMFactory fac, String elementName, Object value, Type valueType, TypeTable typeTable, OMNamespace ns, boolean elementFormDefault) {
        if (value == null) {
            return null;
        }
        if (SimpleTypeMapper.isMap(value.getClass())) {
            List<OMElement> childList = BeanUtil.getMapElement(fac, valueType, (Map)value, typeTable, elementFormDefault);
            OMElement omValue = elementFormDefault ? fac.createOMElement(elementName, ns.getNamespaceURI(), ns.getPrefix()) : fac.createOMElement(elementName, null);
            for (OMElement child : childList) {
                omValue.addChild(child);
            }
            return omValue;
        }
        if (SimpleTypeMapper.isCollection(value.getClass())) {
            QName elementQName = elementFormDefault ? new QName(ns.getNamespaceURI(), elementName, ns.getPrefix()) : new QName(elementName);
            return BeanUtil.getCollectionElement(fac, valueType, (Collection)value, elementName, null, elementQName, typeTable, elementFormDefault).getChildren();
        }
        if (SimpleTypeMapper.isDomDocument((Class)valueType)) {
            return BeanUtil.convertDOMtoOM(fac, value);
        }
        if (SimpleTypeMapper.isObjectType((Class)valueType)) {
            OMElement omValue = fac.createOMElement(elementName, ns);
            if (SimpleTypeMapper.isSimpleType(value)) {
                omValue.addChild(fac.createOMText(SimpleTypeMapper.getStringValue(value)));
            } else {
                QName name = elementFormDefault ? new QName(ns.getNamespaceURI(), elementName, ns.getPrefix()) : new QName(elementName);
                XMLStreamReader xr = BeanUtil.getPullParser(value, name, typeTable, true, false);
                OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(), new StreamWrapper(xr));
                omValue = stAXOMBuilder.getDocumentElement();
            }
            BeanUtil.addInstanceTypeAttribute(fac, omValue, value, typeTable);
            return omValue;
        }
        if (SimpleTypeMapper.isSimpleType(value)) {
            OMElement omValue = fac.createOMElement(elementName, ns);
            omValue.addChild(fac.createOMText(SimpleTypeMapper.getStringValue(value)));
            return omValue;
        }
        return value;
    }

    public static Collection<Object> processGenericCollection(OMElement omElement, Type generictype, MultirefHelper helper, ObjectSupplier objectSupplier) throws AxisFault {
        QName partName = omElement.getQName();
        Object parameter = Object.class;
        if (generictype != null && generictype instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)generictype;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            parameter = parameterArgTypes[0];
        }
        Iterator parts = omElement.getParent().getChildrenWithName(partName);
        return BeanUtil.processGenericsElement(parameter, omElement, helper, parts, objectSupplier, generictype);
    }

    public static Collection<Object> processGenericCollection(OMElement omElement, OMElement[] toReturn, Type generictype, MultirefHelper helper, ObjectSupplier objectSupplier, Iterator parts, boolean bare) throws AxisFault {
        String currentLocalName = omElement.getLocalName();
        Object parameter = Object.class;
        ArrayList<OMElement> eleList = new ArrayList<OMElement>();
        if (!bare) {
            eleList.add(omElement);
        }
        if (generictype != null && generictype instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)generictype;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            parameter = parameterArgTypes[0];
        }
        while (parts.hasNext()) {
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            OMElement currElement = (OMElement)objValue;
            if (currentLocalName.equals(currElement.getLocalName())) {
                eleList.add(currElement);
                continue;
            }
            toReturn[0] = currElement;
            break;
        }
        return BeanUtil.processGenericsElement(parameter, omElement, helper, eleList.iterator(), objectSupplier, generictype);
    }

    public static OMElement getCollectionElement(OMFactory fac, Type type, Collection results, String name, String innerName, QName elementQName, TypeTable typeTable, boolean elementFormDefault) {
        String elementName = innerName == null ? name : innerName;
        Iterator itr = results.iterator();
        ArrayList<QName> properties = new ArrayList<QName>();
        OMNamespace ns = fac.createOMNamespace(elementQName.getNamespaceURI(), elementQName.getPrefix());
        Object valueType = Object.class;
        if (type instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)type;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            valueType = parameterArgTypes[0];
        }
        while (itr.hasNext()) {
            Object value = itr.next();
            if (value == null) continue;
            value = BeanUtil.getCollectionItemElement(fac, elementName, value, (Type)valueType, typeTable, ns, elementFormDefault);
            QName valueQName = elementFormDefault ? new QName(ns.getNamespaceURI(), elementName, ns.getPrefix()) : new QName(elementName);
            properties.add(valueQName);
            properties.add((QName)value);
        }
        QName eleQName = elementFormDefault ? new QName(ns.getNamespaceURI(), elementQName.getLocalPart(), ns.getPrefix()) : new QName(elementQName.getLocalPart());
        ADBXMLStreamReaderImpl pullParser = new ADBXMLStreamReaderImpl(eleQName, properties.toArray(), null, typeTable, elementFormDefault);
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), new StreamWrapper(pullParser));
        return stAXOMBuilder.getDocumentElement();
    }

    private static Object getCollectionItemElement(OMFactory fac, String elementName, Object value, Type valueType, TypeTable typeTable, OMNamespace ns, boolean elementFormDefault) {
        if (SimpleTypeMapper.isMap(value.getClass())) {
            List<OMElement> childList = BeanUtil.getMapElement(fac, valueType, (Map)value, typeTable, elementFormDefault);
            OMElement omValue = fac.createOMElement(elementName, ns.getNamespaceURI(), ns.getPrefix());
            for (OMElement child : childList) {
                omValue.addChild(child);
            }
            return omValue;
        }
        if (SimpleTypeMapper.isCollection(value.getClass())) {
            return BeanUtil.getCollectionElement(fac, valueType, (Collection)value, elementName, "array", new QName(ns.getNamespaceURI(), elementName, ns.getPrefix()), typeTable, elementFormDefault);
        }
        if (SimpleTypeMapper.isObjectType((Class)valueType)) {
            OMElement omValue = fac.createOMElement(elementName, ns);
            if (SimpleTypeMapper.isSimpleType(value)) {
                omValue.addChild(fac.createOMText(SimpleTypeMapper.getStringValue(value)));
            } else {
                QName name = elementFormDefault ? new QName(ns.getNamespaceURI(), elementName, ns.getPrefix()) : new QName(elementName);
                XMLStreamReader xr = BeanUtil.getPullParser(value, name, typeTable, true, false);
                OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(), new StreamWrapper(xr));
                omValue = stAXOMBuilder.getDocumentElement();
            }
            BeanUtil.addInstanceTypeAttribute(fac, omValue, value, typeTable);
            return omValue;
        }
        return value;
    }

    private static Collection<Object> getCollectionInstance(Type genericType) {
        Class rowType = genericType instanceof ParameterizedType ? (Class)((ParameterizedType)genericType).getRawType() : (Class)genericType;
        if (Collection.class.getName().equals(rowType.getName()) || List.class.getName().equals(rowType.getName())) {
            return new ArrayList<Object>();
        }
        if (Set.class.getName().equals(rowType.getName())) {
            return new HashSet<Object>();
        }
        if (Queue.class.getName().equals(rowType.getName())) {
            return new LinkedList<Object>();
        }
        if (BlockingQueue.class.getName().equals(rowType.getName())) {
            return new LinkedBlockingQueue<Object>();
        }
        try {
            return (Collection)rowType.newInstance();
        }
        catch (Exception e) {
            return new ArrayList<Object>();
        }
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(OMElement beanElement) throws DatatypeConfigurationException {
        String greCal = beanElement.getText();
        XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(greCal);
        return xmlCal;
    }
}

