/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamWriterArrayFilter
implements XMLStreamWriter {
    private static final Log log = LogFactory.getLog(XMLStreamWriterArrayFilter.class);
    XMLStreamWriter writer;
    int depth = 0;
    boolean isBuffering = true;
    List<List<String>> bufferedCommands = new ArrayList<List<String>>();
    private static boolean DEBUG_ENABLED = false;
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

    public XMLStreamWriterArrayFilter(XMLStreamWriter writer) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("XMLStreamWriterArrayFilter " + writer);
        }
        this.writer = writer;
    }

    @Override
    public void close() throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("close");
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("flush");
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (DEBUG_ENABLED) {
            log.debug("getNamespaceContext");
        }
        return this.writer.getNamespaceContext();
    }

    @Override
    public String getPrefix(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("getPrefix " + arg0);
        }
        return this.writer.getPrefix(arg0);
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        if (DEBUG_ENABLED) {
            log.debug("getProperty " + arg0);
        }
        return this.writer.getProperty(arg0);
    }

    @Override
    public void setDefaultNamespace(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("setDefaultNamespace " + arg0);
        }
        this.writer.setDefaultNamespace(arg0);
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("setNamespaceContext " + arg0);
        }
        this.writer.setNamespaceContext(arg0);
    }

    @Override
    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("setPrefix " + arg0 + " " + arg1);
        }
        this.writer.setPrefix(arg0, arg1);
    }

    @Override
    public void writeAttribute(String prefix, String uri, String localName, String value) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeAttribute " + prefix + " " + uri + " " + localName + " " + value);
        }
        this.writer.writeAttribute(prefix, uri, localName, value);
    }

    @Override
    public void writeAttribute(String arg0, String arg1, String arg2) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeAttribute " + arg0 + " " + arg1 + " " + arg2);
        }
        this.writer.writeAttribute(arg0, arg1, arg2);
    }

    @Override
    public void writeAttribute(String arg0, String arg1) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeAttribute " + arg0 + " " + arg1);
        }
        this.writer.writeAttribute(arg0, arg1);
    }

    @Override
    public void writeCData(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeCData " + arg0);
        }
        this.writer.writeCData(arg0);
    }

    @Override
    public void writeCharacters(char[] arg0, int arg1, int arg2) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeCharacters " + arg0 + " " + arg1 + " " + arg2);
        }
        this.writer.writeCharacters(arg0, arg1, arg2);
    }

    @Override
    public void writeCharacters(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeCharacters " + arg0);
        }
        this.writer.writeCharacters(arg0);
    }

    @Override
    public void writeComment(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeComment " + arg0);
        }
        this.writer.writeComment(arg0);
    }

    @Override
    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeDefaultNamespace (" + uri + ")");
        }
        if (this.isBuffering) {
            if (DEBUG_ENABLED) {
                log.debug("  Supress writeDefaultNamespace on top element");
            }
        } else if (this.depth >= 2) {
            this.writer.writeDefaultNamespace(uri);
        }
    }

    @Override
    public void writeDTD(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeDTD " + arg0);
        }
        this.writer.writeDTD(arg0);
    }

    @Override
    public void writeEmptyElement(String arg0, String arg1, String arg2) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeEmptyElement" + arg0 + " " + arg1 + " " + arg2);
        }
        this.writeStartElement(arg0, arg1, arg2);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String arg0, String arg1) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeEmptyElement " + arg0 + " " + arg1);
        }
        this.writeStartElement(arg0, arg1);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeEmptyElement " + arg0);
        }
        this.writeStartElement(arg0);
        this.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeEndDocument ");
        }
        this.writer.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (DEBUG_ENABLED) {
            log.debug("writeEndElement ");
        }
        if (this.depth != 0) {
            this.writer.writeEndElement();
        } else {
            if (DEBUG_ENABLED) {
                log.debug("  Suppress writeEndElement for the top element..but performing a flush");
            }
            this.writer.flush();
        }
    }

    @Override
    public void writeEntityRef(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeEntityRef " + arg0);
        }
        this.writer.writeEntityRef(arg0);
    }

    @Override
    public void writeNamespace(String prefix, String uri) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeNamespace (" + prefix + ") (" + uri + ")");
        }
        if (this.isBuffering) {
            if ("".equals(prefix)) {
                if (DEBUG_ENABLED) {
                    log.debug("  Supress default write namespace on top element to avoid collision");
                }
            } else {
                ArrayList<String> command = new ArrayList<String>();
                command.add("writeNamespace");
                command.add(prefix);
                command.add(uri);
                this.bufferCommand(command);
            }
        } else if (this.depth == 2 && XSI_URI.equals(uri) && "xsi".equals(prefix)) {
            if (DEBUG_ENABLED) {
                log.debug("  Supressing xsi namespace declaration on array item");
            }
        } else if (this.depth >= 2) {
            this.writer.writeNamespace(prefix, uri);
        }
    }

    @Override
    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeProcessingInstruction " + arg0 + " " + arg1);
        }
        this.writer.writeProcessingInstruction(arg0, arg1);
    }

    @Override
    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeProcessingInstruction " + arg0);
        }
        this.writer.writeProcessingInstruction(arg0);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeStartDocument ");
        }
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String arg0, String arg1) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeStartDocument " + arg0 + " " + arg1);
        }
        this.writer.writeStartDocument(arg0, arg1);
    }

    @Override
    public void writeStartDocument(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeStartDocument " + arg0);
        }
        this.writer.writeStartDocument(arg0);
    }

    @Override
    public void writeStartElement(String arg0, String arg1, String arg2) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeStartElement " + arg0 + " " + arg1 + " " + arg2);
        }
        ++this.depth;
        if (this.depth > 1) {
            this.isBuffering = false;
        }
        if (this.isBuffering) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("writeStartElement");
            command.add(arg0);
            command.add(arg1);
            command.add(arg2);
            this.bufferCommand(command);
        } else if (this.depth == 2) {
            this.writeCommands();
        } else {
            this.writer.writeStartElement(arg0, arg1, arg2);
        }
    }

    @Override
    public void writeStartElement(String arg0, String arg1) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeStartElement " + arg0 + " " + arg1);
        }
        ++this.depth;
        if (this.depth > 1) {
            this.isBuffering = false;
        }
        if (this.isBuffering) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("writeStartElement");
            command.add(arg0);
            command.add(arg1);
            this.bufferCommand(command);
        } else if (this.depth == 2) {
            this.writeCommands();
        } else {
            this.writer.writeStartElement(arg0, arg1);
        }
    }

    @Override
    public void writeStartElement(String arg0) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("writeStartElement " + arg0);
        }
        ++this.depth;
        if (this.depth > 1) {
            this.isBuffering = false;
        }
        if (this.isBuffering) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("writeStartElement");
            command.add(arg0);
            this.bufferCommand(command);
        } else if (this.depth == 2) {
            this.writeCommands();
        } else {
            this.writer.writeStartElement(arg0);
        }
    }

    void bufferCommand(List<String> command) {
        if (DEBUG_ENABLED) {
            log.debug("  Buffering command " + command);
        }
        this.bufferedCommands.add(command);
    }

    void writeCommands() throws XMLStreamException {
        for (int i = 0; i < this.bufferedCommands.size(); ++i) {
            List<String> command = this.bufferedCommands.get(i);
            String m = command.get(0);
            if ("writeNamespace".equals(m)) {
                if (DEBUG_ENABLED) {
                    log.debug("  Sending buffered writeNamespace " + command.get(1) + "  " + command.get(2));
                }
                this.writer.writeNamespace(command.get(1), command.get(2));
                continue;
            }
            if (!"writeStartElement".equals(m)) continue;
            int len = command.size();
            if (len == 2) {
                if (DEBUG_ENABLED) {
                    log.debug("  Sending buffered writeStartElement " + command.get(1));
                }
                this.writer.writeStartElement(command.get(1));
                continue;
            }
            if (len == 3) {
                if (DEBUG_ENABLED) {
                    log.debug("  Sending buffered writeStartElement " + command.get(1) + "  " + command.get(2));
                }
                this.writer.writeStartElement(command.get(1), command.get(2));
                continue;
            }
            if (len != 4) continue;
            if (DEBUG_ENABLED) {
                log.debug("  Sending buffered writeStartElement " + command.get(1) + "  " + command.get(2) + " " + command.get(3));
            }
            this.writer.writeStartElement(command.get(1), command.get(2), command.get(3));
        }
    }
}

