/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(ModuleDeployer.class);
    private AxisConfiguration axisConfig;

    public ModuleDeployer() {
    }

    public ModuleDeployer(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public void init(ConfigurationContext configCtx) {
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        File deploymentFile = deploymentFileData.getFile();
        if (deploymentFile == null) {
            this.deoloyFromUrl(deploymentFileData);
            return;
        }
        boolean isDirectory = deploymentFile.isDirectory();
        if (isDirectory && deploymentFileData.getName().startsWith(".")) {
            return;
        }
        ArchiveReader archiveReader = new ArchiveReader();
        String moduleStatus = "";
        StringWriter errorWriter = new StringWriter();
        try {
            try {
                deploymentFileData.setClassLoader(isDirectory, this.axisConfig.getModuleClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
                AxisModule metaData = new AxisModule();
                metaData.setModuleClassLoader(deploymentFileData.getClassLoader());
                metaData.setParent(this.axisConfig);
                archiveReader.readModuleArchive(deploymentFileData, metaData, isDirectory, this.axisConfig);
                URL url = deploymentFile.toURI().toURL();
                metaData.setFileName(url);
                DeploymentEngine.addNewModule(metaData, this.axisConfig);
                super.deploy(deploymentFileData);
                log.info(Messages.getMessage("deployingmodule", metaData.getArchiveName(), url.toString()));
            }
            catch (DeploymentException e) {
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), e);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                e.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var12_18 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            catch (AxisFault axisFault) {
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), axisFault.getMessage()), axisFault);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                axisFault.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var12_19 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            catch (MalformedURLException e) {
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), e);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                e.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var12_20 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), t.getMessage()), t);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                t.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var12_21 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            Object var12_17 = null;
            if (!moduleStatus.startsWith("Error:")) return;
            this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
            return;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            if (!moduleStatus.startsWith("Error:")) throw throwable;
            this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deoloyFromUrl(DeploymentFileData deploymentFileData) {
        URL fileUrl = deploymentFileData.getUrl();
        StringWriter errorWriter = new StringWriter();
        String moduleStatus = "";
        if (fileUrl == null) {
            return;
        }
        try {
            try {
                ClassLoader deploymentClassLoader = Utils.createClassLoader(new URL[]{fileUrl}, this.axisConfig.getModuleClassLoader(), true, (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
                AxisModule module = new AxisModule();
                module.setModuleClassLoader(deploymentClassLoader);
                module.setParent(this.axisConfig);
                module.setArchiveName(DescriptionBuilder.getShortFileName(deploymentFileData.getName()));
                this.populateModule(module, fileUrl);
                module.setFileName(fileUrl);
                DeploymentEngine.addNewModule(module, this.axisConfig);
                log.info(Messages.getMessage("deployingmodule", module.getArchiveName(), fileUrl.toString()));
            }
            catch (DeploymentException e) {
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), e);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                e.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var10_14 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            catch (AxisFault axisFault) {
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), axisFault.getMessage()), axisFault);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                axisFault.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var10_15 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.error(Messages.getMessage("invalidmodule", deploymentFileData.getName(), t.getMessage()), t);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                t.printStackTrace(error_ptintWriter);
                moduleStatus = "Error:\n" + errorWriter.toString();
                Object var10_16 = null;
                if (!moduleStatus.startsWith("Error:")) return;
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
                return;
            }
            Object var10_13 = null;
            if (!moduleStatus.startsWith("Error:")) return;
            this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
            return;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (!moduleStatus.startsWith("Error:")) throw throwable;
            this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
            throw throwable;
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
        super.undeploy(fileName);
    }

    private void populateModule(AxisModule module, URL moduleUrl) throws DeploymentException {
        try {
            ClassLoader classLoader = module.getModuleClassLoader();
            InputStream moduleStream = classLoader.getResourceAsStream("META-INF/module.xml");
            if (moduleStream == null) {
                moduleStream = classLoader.getResourceAsStream("meta-inf/module.xml");
            }
            if (moduleStream == null) {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", moduleUrl.toString()));
            }
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, module, this.axisConfig);
            moduleBuilder.populateModule();
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }
}

