/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisMessage
extends AxisDescription {
    private ArrayList<Handler> handlerChain;
    private String name;
    private ArrayList soapHeaders = new ArrayList();
    private QName elementQname;
    private String direction;
    private String messagePartName;
    private ArrayList<String> modulerefs;
    private String partName = "parameters";
    private boolean wrapped = true;
    private volatile Policy effectivePolicy = null;
    private volatile Date lastPolicyCalculatedTime = null;

    public String getMessagePartName() {
        return this.messagePartName;
    }

    public void setMessagePartName(String messagePartName) {
        this.messagePartName = messagePartName;
    }

    public AxisMessage() {
        this.handlerChain = new ArrayList();
        this.modulerefs = new ArrayList();
    }

    public ArrayList<Handler> getMessageFlow() {
        return this.handlerChain;
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        boolean locked = false;
        if (this.getParent() != null) {
            locked = this.getParent().isParameterLocked(parameterName);
        }
        if (locked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setMessageFlow(ArrayList<Handler> operationFlow) {
        this.handlerChain = operationFlow;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public QName getElementQName() {
        return this.elementQname;
    }

    public void setElementQName(QName element) {
        this.elementQname = element;
    }

    @Override
    public Object getKey() {
        return this.elementQname;
    }

    public XmlSchemaElement getSchemaElement() {
        XmlSchema schema;
        XmlSchemaElement xmlSchemaElement = null;
        AxisService service = this.getAxisOperation().getAxisService();
        ArrayList<XmlSchema> schemas = service.getSchema();
        Iterator<XmlSchema> iterator = schemas.iterator();
        while (iterator.hasNext() && (xmlSchemaElement = this.getSchemaElement(schema = iterator.next())) == null) {
        }
        return xmlSchemaElement;
    }

    private XmlSchemaElement getSchemaElement(XmlSchema schema) {
        XmlSchemaElement xmlSchemaElement = null;
        if (schema != null && (xmlSchemaElement = schema.getElementByName(this.elementQname)) == null) {
            for (XmlSchemaObject xmlSchemaObject : schema.getExternals()) {
                XmlSchema schema1;
                if (xmlSchemaObject instanceof XmlSchemaImport) {
                    schema1 = ((XmlSchemaImport)xmlSchemaObject).getSchema();
                    xmlSchemaElement = this.getSchemaElement(schema1);
                }
                if (xmlSchemaObject instanceof XmlSchemaInclude) {
                    schema1 = ((XmlSchemaInclude)xmlSchemaObject).getSchema();
                    xmlSchemaElement = this.getSchemaElement(schema1);
                }
                if (xmlSchemaElement == null) continue;
                break;
            }
        }
        return xmlSchemaElement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getExtensibilityAttributes() {
        return new ArrayList(0);
    }

    public void addSoapHeader(SOAPHeaderMessage soapHeaderMessage) {
        this.soapHeaders.add(soapHeaderMessage);
    }

    public ArrayList getSoapHeaders() {
        return this.soapHeaders;
    }

    @Override
    public void onEngage(AxisModule axisModule, AxisDescription engager) throws AxisFault {
        PhaseResolver phaseResolver = new PhaseResolver(this.getAxisConfiguration());
        phaseResolver.engageModuleToMessage(this, axisModule);
    }

    public ArrayList<String> getModulerefs() {
        return this.modulerefs;
    }

    public void addModuleRefs(String moduleName) {
        this.modulerefs.add(moduleName);
    }

    public AxisOperation getAxisOperation() {
        return (AxisOperation)this.parent;
    }

    public String getPartName() {
        return this.partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy getEffectivePolicy() {
        if (this.lastPolicyCalculatedTime == null || this.isPolicyUpdated()) {
            AxisMessage axisMessage = this;
            synchronized (axisMessage) {
                if (this.lastPolicyCalculatedTime == null || this.isPolicyUpdated()) {
                    this.effectivePolicy = this.calculateEffectivePolicy();
                    this.lastPolicyCalculatedTime = new Date();
                }
            }
        }
        return this.effectivePolicy;
    }

    public Policy calculateEffectivePolicy() {
        AxisConfiguration axisConfiguration;
        AxisService axisService;
        ArrayList<PolicyComponent> policyList = new ArrayList<PolicyComponent>();
        PolicySubject policySubject = this.getPolicySubject();
        policyList.addAll(policySubject.getAttachedPolicyComponents());
        AxisOperation axisOperation = this.getAxisOperation();
        if (axisOperation != null) {
            policyList.addAll(axisOperation.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisService axisService2 = axisService = axisOperation == null ? null : axisOperation.getAxisService();
        if (axisService != null) {
            policyList.addAll(axisService.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisConfiguration axisConfiguration2 = axisConfiguration = axisService == null ? null : axisService.getAxisConfiguration();
        if (axisConfiguration != null) {
            policyList.addAll(axisConfiguration.getPolicySubject().getAttachedPolicyComponents());
        }
        Policy result = PolicyUtil.getMergedPolicy(policyList, (AxisDescription)axisService);
        return result;
    }

    public boolean isPolicyUpdated() {
        AxisService axisService;
        if (this.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalculatedTime)) {
            return true;
        }
        AxisOperation axisOperation = (AxisOperation)this.parent;
        if (axisOperation != null && axisOperation.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalculatedTime)) {
            return true;
        }
        AxisService axisService2 = axisService = axisOperation == null ? null : axisOperation.getAxisService();
        if (axisService != null && axisService.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalculatedTime)) {
            return true;
        }
        AxisConfiguration axisConfiguration = axisService == null ? null : axisService.getAxisConfiguration();
        return axisConfiguration != null && axisConfiguration.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalculatedTime);
    }
}

