/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.ThreadContextDescriptor;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.service.Lifecycle;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DependencyManager {
    private static final Log log = LogFactory.getLog(DependencyManager.class);
    public static final String SERVICE_INIT_METHOD = "init";
    public static final String SERVICE_DESTROY_METHOD = "destroy";

    public static void initServiceObject(Object obj, ServiceContext serviceContext) throws AxisFault {
        if (obj instanceof Lifecycle) {
            ((Lifecycle)obj).init(serviceContext);
            return;
        }
        Class<?> classToLoad = obj.getClass();
        Method method = null;
        try {
            method = classToLoad.getMethod(SERVICE_INIT_METHOD, ServiceContext.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            try {
                method.invoke(obj, serviceContext);
            }
            catch (IllegalAccessException e) {
                log.error("Exception trying to call init", e);
                throw new AxisFault("Can not access the method ", e);
            }
            catch (IllegalArgumentException e) {
                log.error("Exception trying to call init", e);
                throw new AxisFault(" Incorrect arguments ", e);
            }
            catch (InvocationTargetException e) {
                log.error("Exception trying to call init", e);
                throw new AxisFault(" problem in invocation the method ", e);
            }
        }
    }

    public static void initService(ServiceGroupContext serviceGroupContext) throws AxisFault {
        AxisServiceGroup serviceGroup = serviceGroupContext.getDescription();
        Iterator<AxisService> serviceItr = serviceGroup.getServices();
        while (serviceItr.hasNext()) {
            AxisService axisService = serviceItr.next();
            ServiceContext serviceContext = serviceGroupContext.getServiceContext(axisService);
            AxisService service = serviceContext.getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            Parameter implInfoParam = service.getParameter("ServiceClass");
            if (implInfoParam == null) continue;
            try {
                ThreadContextDescriptor tc = ThreadContextDescriptor.setThreadContext(axisService);
                Class implClass = Loader.loadClass(classLoader, ((String)implInfoParam.getValue()).trim());
                Object serviceImpl = DependencyManager.makeNewServiceObject(service);
                serviceContext.setProperty("serviceObject", serviceImpl);
                DependencyManager.initServiceObject(serviceImpl, serviceContext);
                DependencyManager.restoreThreadContext(tc);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
    }

    protected static Object makeNewServiceObject(AxisService service) throws AxisFault {
        Object serviceObject = Utils.createServiceObject(service);
        if (serviceObject == null) {
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        return serviceObject;
    }

    public static void destroyServiceObject(ServiceContext serviceContext) {
        Object obj = serviceContext.getProperty("serviceObject");
        if (obj != null) {
            if (obj instanceof Lifecycle) {
                ((Lifecycle)obj).destroy(serviceContext);
                return;
            }
            Class<?> classToLoad = obj.getClass();
            Method method = null;
            try {
                method = classToLoad.getMethod(SERVICE_DESTROY_METHOD, ServiceContext.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                try {
                    method.invoke(obj, serviceContext);
                }
                catch (IllegalAccessException e) {
                    log.info("Exception trying to call destroy", e);
                }
                catch (InvocationTargetException e) {
                    log.info("Exception trying to call destroy", e);
                }
            }
        }
    }

    protected static void restoreThreadContext(final ThreadContextDescriptor tc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(tc.getOldClassLoader());
                return null;
            }
        });
        MessageContext.currentMessageContext.set(tc.getOldMessageContext());
    }
}

