/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.api;

import java.io.ByteArrayOutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.message.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageAccessor {
    private static final Log log = LogFactory.getLog(MessageAccessor.class);
    private MessageContext mc;

    MessageAccessor(MessageContext mc) {
        this.mc = mc;
    }

    public String getMessageAsString() {
        if (log.isDebugEnabled()) {
            log.debug("Enter MessageAccessor");
        }
        Message msg = this.mc.getMessage();
        String text = null;
        if (msg != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OMOutputFormat format = new OMOutputFormat();
                String charSetEncoding = (String)this.mc.getProperty("CHARACTER_SET_ENCODING");
                charSetEncoding = charSetEncoding == null ? "UTF-8" : charSetEncoding;
                format.setCharSetEncoding(charSetEncoding);
                MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(baos, format);
                msg.outputTo(writer, false);
                writer.flush();
                text = baos.toString(charSetEncoding);
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug("Cannot access message as string", t);
                }
                text = null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit MessageAccessor");
        }
        return text;
    }

    public String toString() {
        return this.getMessageAsString();
    }
}

