/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.dispatch;

import javax.activation.DataSource;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.dispatch.BaseDispatch;
import org.apache.axis2.jaxws.client.dispatch.XMLDispatchAsyncListener;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.DataSourceBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.factory.OMBlockFactory;
import org.apache.axis2.jaxws.message.factory.SOAPEnvelopeBlockFactory;
import org.apache.axis2.jaxws.message.factory.SourceBlockFactory;
import org.apache.axis2.jaxws.message.factory.XMLStringBlockFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.jaxws.utility.DataSourceFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDispatch<T>
extends BaseDispatch<T> {
    private static final Log log = LogFactory.getLog(XMLDispatch.class);
    private Class type;
    private Class blockFactoryType;

    public XMLDispatch(ServiceDelegate svcDelegate, EndpointDescription endpointDesc, WebServiceFeature ... features) {
        this(svcDelegate, endpointDesc, (EndpointReference)null, (String)null, features);
    }

    public XMLDispatch(ServiceDelegate svcDelegate, EndpointDescription endpointDesc, EndpointReference epr, String addressingNamespace, WebServiceFeature ... features) {
        super(svcDelegate, endpointDesc, epr, addressingNamespace, features);
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class c) {
        this.type = c;
    }

    @Override
    public AsyncResponse createAsyncResponseListener() {
        if (log.isDebugEnabled()) {
            log.debug("Creating new AsyncListener for XMLDispatch");
        }
        XMLDispatchAsyncListener al = new XMLDispatchAsyncListener(this.getEndpointDescription());
        al.setMode(this.mode);
        al.setType(this.type);
        al.setBlockFactoryType(this.blockFactoryType);
        return al;
    }

    @Override
    public Message createMessageFromValue(Object value) {
        if (value != null) {
            this.type = value.getClass();
            if (log.isDebugEnabled()) {
                log.debug("Parameter type: " + this.type.getName());
                log.debug("Message mode: " + this.mode.name());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Dispatch invoked with null parameter Value");
                log.debug("creating empty soap message");
            }
            try {
                this.blockFactoryType = this.getBlockFactory();
                return this.createEmptyMessage(Protocol.getProtocolForBinding(this.endpointDesc.getClientBindingID()));
            }
            catch (XMLStreamException e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        Block block = null;
        this.blockFactoryType = this.getBlockFactory(value);
        BlockFactory factory = (BlockFactory)FactoryRegistry.getFactory(this.blockFactoryType);
        if (log.isDebugEnabled()) {
            log.debug("Loaded block factory type [" + this.blockFactoryType.getName());
        }
        Protocol proto = Protocol.getProtocolForBinding(this.endpointDesc.getClientBindingID());
        Message message = null;
        if (this.mode.equals((Object)Service.Mode.PAYLOAD)) {
            try {
                MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                block = factory.createFrom(value, null, null);
                message = mf.create(proto);
                message.setBodyBlock(block);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        if (this.mode.equals((Object)Service.Mode.MESSAGE)) {
            try {
                MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                if (value instanceof SOAPMessage) {
                    message = mf.createFrom((SOAPMessage)value);
                } else {
                    block = factory.createFrom(value, null, null);
                    message = mf.createFrom(block, null, proto);
                }
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        return message;
    }

    @Override
    public Object getValueFromMessage(Message message) {
        return XMLDispatch.getValue(message, this.mode, this.blockFactoryType);
    }

    static Object getValue(Message message, Service.Mode mode, Class blockFactoryType) {
        Object value = null;
        Block block = null;
        if (log.isDebugEnabled()) {
            log.debug("Attempting to get the value object from the returned message");
        }
        try {
            BlockFactory factory;
            if (mode.equals((Object)Service.Mode.PAYLOAD)) {
                BlockFactory factory2 = (BlockFactory)FactoryRegistry.getFactory(blockFactoryType);
                block = message.getBodyBlock(null, factory2);
                if (block != null) {
                    value = block.getBusinessObject(true);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("There are no elements in the body to unmarshal.  XMLDispatch returns a null value");
                    }
                    value = null;
                }
            } else if (mode.equals((Object)Service.Mode.MESSAGE) && (value = (factory = (BlockFactory)FactoryRegistry.getFactory(blockFactoryType)) instanceof OMBlockFactory ? message.getAsOMElement() : message.getValue(null, factory)) == null && log.isDebugEnabled()) {
                log.debug("There are no elements to unmarshal.  XMLDispatch returns a null value");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("An error occured while creating the block");
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
        finally {
            if (!(value instanceof OMElement)) {
                message.close();
            }
        }
        if (log.isDebugEnabled()) {
            if (value == null) {
                log.debug("Returning a null value");
            } else {
                log.debug("Returning value of type: " + value.getClass().getName());
            }
        }
        return value;
    }

    private Class getBlockFactory(Object o) {
        if (o instanceof String) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning XMLStringBlockFactory");
            }
            return XMLStringBlockFactory.class;
        }
        if (Source.class.isAssignableFrom(o.getClass())) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning SourceBlockFactory");
            }
            return SourceBlockFactory.class;
        }
        if (DataSource.class.isAssignableFrom(o.getClass())) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning DataSourceBlockFactory");
            }
            return DataSourceBlockFactory.class;
        }
        if (SOAPMessage.class.isAssignableFrom(o.getClass())) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning SOAPMessageFactory");
            }
            return SOAPEnvelopeBlockFactory.class;
        }
        if (SOAPEnvelope.class.isAssignableFrom(o.getClass())) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning SOAPEnvelope");
            }
            return SOAPEnvelopeBlockFactory.class;
        }
        if (OMElement.class.isAssignableFrom(o.getClass())) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning OMBlockFactory");
            }
            return OMBlockFactory.class;
        }
        if (log.isDebugEnabled()) {
            log.debug(">> ERROR: Factory not found");
        }
        return null;
    }

    private Class getBlockFactory() {
        if (String.class.isAssignableFrom(this.type)) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning XMLStringBlockFactory");
            }
            return XMLStringBlockFactory.class;
        }
        if (Source.class.isAssignableFrom(this.type)) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning SourceBlockFactory");
            }
            return SourceBlockFactory.class;
        }
        if (SOAPMessage.class.isAssignableFrom(this.type)) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning SOAPMessageFactory");
            }
            return SOAPEnvelopeBlockFactory.class;
        }
        if (SOAPEnvelope.class.isAssignableFrom(this.type)) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning SOAPEnvelope");
            }
            return SOAPEnvelopeBlockFactory.class;
        }
        if (OMElement.class.isAssignableFrom(this.type)) {
            if (log.isDebugEnabled()) {
                log.debug(">> returning OMBlockFactory");
            }
            return OMBlockFactory.class;
        }
        if (log.isDebugEnabled()) {
            log.debug(">> ERROR: Factory not found");
        }
        return null;
    }

    private Message createEmptyMessage(Protocol protocol) throws WebServiceException, XMLStreamException {
        MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
        Message m = mf.create(protocol);
        return m;
    }

    @Override
    protected void initMessageContext(Object obj, MessageContext requestMsgCtx) {
        super.initMessageContext(obj, requestMsgCtx);
        if (obj instanceof DataSource) {
            requestMsgCtx.setProperty("messageFormatter", new DataSourceFormatter(((DataSource)obj).getContentType()));
        }
    }
}

