/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceContextImpl
implements WebServiceContext {
    private static final Log log = LogFactory.getLog(WebServiceContext.class);
    private MessageContext soapMessageContext;

    @Override
    public MessageContext getMessageContext() {
        if (log.isDebugEnabled() && this.soapMessageContext == null) {
            log.debug("The MessageContext is not available");
        }
        return this.soapMessageContext;
    }

    @Override
    public Principal getUserPrincipal() {
        if (log.isDebugEnabled() && this.soapMessageContext == null) {
            log.debug("The MessageContext is not available");
        }
        if (this.soapMessageContext != null) {
            HttpServletRequest request = (HttpServletRequest)this.soapMessageContext.get("javax.xml.ws.servlet.request");
            if (request != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Access to the user Principal was requested.");
                }
                return request.getUserPrincipal();
            }
            if (log.isDebugEnabled()) {
                log.debug("No HttpServletRequest object was found, so no Principal can be found.");
            }
        }
        return null;
    }

    @Override
    public boolean isUserInRole(String user) {
        if (log.isDebugEnabled() && this.soapMessageContext == null) {
            log.debug("The MessageContext is not available");
        }
        if (this.soapMessageContext != null) {
            HttpServletRequest request = (HttpServletRequest)this.soapMessageContext.get("javax.xml.ws.servlet.request");
            if (request != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Checking to see if the user in the role.");
                }
                return request.isUserInRole(user);
            }
            if (log.isDebugEnabled()) {
                log.debug("No HttpServletRequest object was found, so no role check can be performed.");
            }
        }
        return false;
    }

    public void setSoapMessageContext(MessageContext soapMessageContext) {
        this.soapMessageContext = soapMessageContext;
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        if (log.isDebugEnabled() && this.soapMessageContext == null) {
            log.debug("The MessageContext is not available");
        }
        EndpointReference jaxwsEPR = null;
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(clazz);
        if (this.soapMessageContext != null) {
            QName service = (QName)this.soapMessageContext.get("javax.xml.ws.wsdl.service");
            QName endpoint = (QName)this.soapMessageContext.get("javax.xml.ws.wsdl.port");
            String wsdlLocation = "?wsdl";
            org.apache.axis2.addressing.EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference(null, service, endpoint, wsdlLocation, addressingNamespace);
            try {
                EndpointReferenceUtils.addReferenceParameters(axis2EPR, referenceParameters);
                jaxwsEPR = EndpointReferenceUtils.convertFromAxis2(axis2EPR, addressingNamespace);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointRefConstructionFailure3", e.toString()));
            }
        } else {
            throw new IllegalStateException(Messages.getMessage("webServiceContextErr1"));
        }
        return (T)((EndpointReference)clazz.cast(jaxwsEPR));
    }

    @Override
    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    public void releaseResources() {
        if (log.isDebugEnabled()) {
            log.debug("Releasing WebServiceContextImpl resources");
        }
        this.soapMessageContext = null;
    }
}

