/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.extensions.AttributeExtensible;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.FaultAction;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.wsdl.WSDL11ActionHelper;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.OperationDescriptionJava;
import org.apache.axis2.jaxws.description.OperationDescriptionWSDL;
import org.apache.axis2.jaxws.description.OperationRuntimeDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ParameterDescriptionJava;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.FaultActionAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.OneWayAnnot;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointInterfaceDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.FaultDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.ParameterDescriptionImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OperationDescriptionImpl
implements OperationDescription,
OperationDescriptionJava,
OperationDescriptionWSDL {
    private final EndpointInterfaceDescription parentEndpointInterfaceDescription;
    private final AxisOperation axisOperation;
    private final QName operationQName;
    private Method seiMethod;
    private final MethodDescriptionComposite methodComposite;
    private ParameterDescription[] parameterDescriptions;
    private FaultDescription[] faultDescriptions;
    private static final Log log = LogFactory.getLog(OperationDescriptionImpl.class);
    private Oneway onewayAnnotation;
    private Boolean onewayIsOneway;
    private boolean isListType = false;
    private RequestWrapper requestWrapperAnnotation;
    private String requestWrapperTargetNamespace;
    private String requestWrapperLocalName;
    private String requestWrapperClassName;
    private String requestWrapperPartName;
    private ResponseWrapper responseWrapperAnnotation;
    private String responseWrapperLocalName;
    private String responseWrapperTargetNamespace;
    private String responseWrapperClassName;
    private String responseWrapperPartName;
    private Action actionAnnotation;
    private SOAPBinding soapBindingAnnotation;
    private SOAPBinding.Style soapBindingStyle;
    public static final SOAPBinding.Style SoapBinding_Style_VALID = SOAPBinding.Style.DOCUMENT;
    private SOAPBinding.Use soapBindingUse;
    public static final SOAPBinding.Use SOAPBinding_Use_DEFAULT = SOAPBinding.Use.LITERAL;
    private SOAPBinding.ParameterStyle soapBindingParameterStyle;
    public static final SOAPBinding.ParameterStyle SOAPBinding_ParameterStyle_DEFAULT = SOAPBinding.ParameterStyle.WRAPPED;
    private WebMethod webMethodAnnotation;
    private String webMethodOperationName;
    public static final String WebMethod_Action_DEFAULT = "";
    private String webMethodAction;
    public static final Boolean WebMethod_Exclude_DEFAULT = Boolean.FALSE;
    private Boolean webMethodExclude;
    private String[] webParamNames;
    private WebParam.Mode[] webParamMode;
    private String[] webParamTargetNamespace;
    private WebResult webResultAnnotation;
    private String webResultName;
    private String webResultPartName;
    public static final String WebResult_TargetNamespace_DEFAULT = "";
    private String webResultTargetNamespace;
    public static final Boolean WebResult_Header_DEFAULT = Boolean.FALSE;
    private Boolean webResultHeader;
    private boolean _setAttachmentDesc = false;
    private AttachmentDescription attachmentDesc = null;
    private boolean hasRequestSwaRefAttachments = false;
    private boolean hasResponseSwaRefAttachments = false;
    private Map<String, AttachmentDescription> partAttachmentMap;
    private Method serviceImplMethod;
    private boolean serviceImplMethodFound = false;
    private OperationDescription syncOperationDescription = null;
    Map<String, OperationRuntimeDescription> runtimeDescMap = Collections.synchronizedMap(new HashMap());
    private Class resultActualTypeClazz;

    OperationDescriptionImpl(Method method, EndpointInterfaceDescription parent) {
        this.parentEndpointInterfaceDescription = parent;
        this.methodComposite = null;
        this.partAttachmentMap = new HashMap<String, AttachmentDescription>();
        this.setSEIMethod(method);
        this.operationQName = new QName("", this.getOperationName());
        this.axisOperation = this.getEndpointInterfaceDescription().getEndpointDescription() != null ? (!this.getEndpointInterfaceDescription().getEndpointDescription().getServiceDescription().isServerSide() ? this.createClientAxisOperation() : null) : null;
        if (this.axisOperation != null) {
            try {
                this.axisOperation.addParameter(new Parameter("org.apache.axis2.jaxws.description.OperationDescription.axisOperationParameter", this));
            }
            catch (AxisFault af) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("operationDescriptionErr1"));
            }
        }
        this.buildAttachmentInformation();
    }

    OperationDescriptionImpl(AxisOperation operation, EndpointInterfaceDescription parent) {
        this.parentEndpointInterfaceDescription = parent;
        this.partAttachmentMap = new HashMap<String, AttachmentDescription>();
        this.axisOperation = operation;
        this.methodComposite = null;
        if (this.axisOperation != null) {
            this.operationQName = this.axisOperation.getName();
            try {
                this.axisOperation.addParameter(new Parameter("org.apache.axis2.jaxws.description.OperationDescription.axisOperationParameter", this));
            }
            catch (AxisFault af) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("operationDescriptionErr1"));
            }
        } else {
            this.operationQName = null;
        }
        this.buildAttachmentInformation();
    }

    OperationDescriptionImpl(MethodDescriptionComposite mdc, EndpointInterfaceDescription parent, AxisOperation axisOperation) {
        this.parentEndpointInterfaceDescription = parent;
        this.partAttachmentMap = new HashMap<String, AttachmentDescription>();
        this.methodComposite = mdc;
        this.operationQName = new QName("", this.getOperationName());
        this.webMethodAnnotation = this.methodComposite.getWebMethodAnnot();
        this.parameterDescriptions = this.createParameterDescriptions();
        this.faultDescriptions = this.createFaultDescriptions();
        this.isListType = mdc.isListType();
        this.buildAttachmentInformation();
        this.axisOperation = axisOperation != null ? axisOperation : this.createAxisOperation();
        if (this.axisOperation != null) {
            try {
                this.axisOperation.addParameter(new Parameter("org.apache.axis2.jaxws.description.OperationDescription.axisOperationParameter", this));
            }
            catch (AxisFault af) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("operationDescriptionErr1"));
            }
        }
        this.registerMustUnderstandHeaders();
    }

    private AxisOperation createClientAxisOperation() {
        AxisOperation newAxisOperation = null;
        try {
            newAxisOperation = this.isOneWay() ? AxisOperationFactory.getOperationDescription("http://www.w3.org/ns/wsdl/out-only") : AxisOperationFactory.getOperationDescription("http://www.w3.org/ns/wsdl/out-in");
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("clientAxisOprErr"), e);
        }
        newAxisOperation.setName(OperationDescriptionImpl.determineOperationQName(this.seiMethod));
        newAxisOperation.setSoapAction(this.getAction());
        String messageExchangePattern = newAxisOperation.getMessageExchangePattern();
        String operationName = newAxisOperation.getName().getLocalPart();
        String targetNS = this.getEndpointInterfaceDescriptionImpl().getTargetNamespace();
        String portTypeName = this.getEndpointInterfaceDescriptionImpl().getPortType().getLocalPart();
        String inputName = null;
        String inputAction = this.getOutputAction();
        if (inputAction == null || inputAction.length() == 0) {
            inputAction = WSDL11ActionHelper.getInputActionFromStringInformation(messageExchangePattern, targetNS, portTypeName, operationName, inputName);
        }
        ArrayList<String> inputActions = new ArrayList<String>();
        inputActions.add(inputAction);
        newAxisOperation.setWsamappingList(inputActions);
        this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getAxisService().mapActionToOperation(inputAction, newAxisOperation);
        String outputName = null;
        String outputAction = this.getInputAction();
        if (outputAction == null || outputAction.length() == 0) {
            outputAction = WSDL11ActionHelper.getOutputActionFromStringInformation(messageExchangePattern, targetNS, portTypeName, operationName, outputName);
        }
        newAxisOperation.setOutputAction(outputAction);
        this.setFaultActions(newAxisOperation, operationName, targetNS, portTypeName);
        this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getAxisService().addOperation(newAxisOperation);
        return newAxisOperation;
    }

    private AxisOperation createAxisOperation() {
        AxisOperation newAxisOperation = null;
        try {
            newAxisOperation = this.isOneWay() ? AxisOperationFactory.getOperationDescription("http://www.w3.org/ns/wsdl/in-only") : AxisOperationFactory.getOperationDescription("http://www.w3.org/ns/wsdl/in-out");
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("clientAxisOprErr"), e);
        }
        newAxisOperation.setName(OperationDescriptionImpl.determineOperationQName(this.getEndpointInterfaceDescriptionImpl(), this.methodComposite));
        newAxisOperation.setSoapAction(this.getAction());
        String messageExchangePattern = newAxisOperation.getMessageExchangePattern();
        String operationName = newAxisOperation.getName().getLocalPart();
        String targetNS = this.getEndpointInterfaceDescriptionImpl().getTargetNamespace();
        String portTypeName = this.getEndpointInterfaceDescriptionImpl().getPortType().getLocalPart();
        String inputName = null;
        String inputAction = this.getInputAction();
        if (inputAction == null || inputAction.length() == 0) {
            inputAction = WSDL11ActionHelper.getInputActionFromStringInformation(messageExchangePattern, targetNS, portTypeName, operationName, inputName);
        }
        ArrayList<String> inputActions = new ArrayList<String>();
        inputActions.add(inputAction);
        newAxisOperation.setWsamappingList(inputActions);
        this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getAxisService().mapActionToOperation(inputAction, newAxisOperation);
        String outputName = null;
        String outputAction = this.getOutputAction();
        if (outputAction == null || outputAction.length() == 0) {
            outputAction = WSDL11ActionHelper.getOutputActionFromStringInformation(messageExchangePattern, targetNS, portTypeName, operationName, outputName);
        }
        newAxisOperation.setOutputAction(outputAction);
        this.setFaultActions(newAxisOperation, operationName, targetNS, portTypeName);
        if (this.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getSoapBindingUse() == SOAPBinding.Use.LITERAL && this.getSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.BARE) {
            ParameterDescription[] paramDescs = this.getParameterDescriptions();
            if (paramDescs != null && paramDescs.length > 0) {
                for (ParameterDescription paramDesc : paramDescs) {
                    WebParam.Mode paramMode = paramDesc.getMode();
                    if (paramDesc.isHeader() || paramMode != WebParam.Mode.IN && paramMode != WebParam.Mode.INOUT) continue;
                    AxisMessage axisMessage = newAxisOperation.getMessage("In");
                    String elementName = paramDesc.getParameterName();
                    String partNamespace = paramDesc.getTargetNamespace();
                    if (log.isDebugEnabled()) {
                        log.debug("Setting up annotation based Doc/Lit/Bare operation: " + newAxisOperation.getName() + "; axisMessage: " + axisMessage + "; name: " + elementName + "; partTNS: " + partNamespace);
                    }
                    if (axisMessage == null) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createAxisOprErr1"));
                    }
                    if (DescriptionUtils.isEmpty(partNamespace)) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createAxisOprErr2"));
                    }
                    if (DescriptionUtils.isEmpty(elementName)) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createAxisOprErr3"));
                    }
                    QName partQName = new QName(partNamespace, elementName);
                    if (log.isDebugEnabled()) {
                        log.debug("Setting AxisMessage element QName for bare mapping: " + partQName);
                    }
                    axisMessage.setElementQName(partQName);
                    this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getAxisService().addMessageElementQNameToOperationMapping(partQName, newAxisOperation);
                    break;
                }
            } else {
                this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getAxisService().addMessageElementQNameToOperationMapping(null, newAxisOperation);
            }
        }
        return newAxisOperation;
    }

    private void setFaultActions(AxisOperation newAxisOperation, String operationName, String targetNS, String portTypeName) {
        FaultAction[] faultActions;
        FaultDescription[] faultDescs = this.getFaultDescriptions();
        if (faultDescs != null) {
            for (FaultDescription faultDesc : faultDescs) {
                AxisMessage faultMessage = new AxisMessage();
                String faultName = faultDesc.getName();
                if (faultName == null || faultName.equals("")) {
                    faultName = faultDesc.getExceptionClassName();
                    faultName = faultName.substring(faultName.lastIndexOf(46) + 1);
                }
                faultMessage.setName(faultName);
                if (log.isDebugEnabled()) {
                    log.debug("Set faultName = " + faultName + " for faultMessage = " + faultMessage + " and faultDesc = " + faultDesc);
                }
                String faultAction = WSDL11ActionHelper.getFaultActionFromStringInformation(targetNS, portTypeName, operationName, faultMessage.getName());
                if (log.isDebugEnabled()) {
                    log.debug("Default faultAction = " + faultAction);
                }
                newAxisOperation.addFaultAction(faultDesc.getExceptionClassName(), faultAction);
                newAxisOperation.setFaultMessages(faultMessage);
            }
        }
        if ((faultActions = this.getFaultActions()) != null) {
            for (FaultAction faultAction : faultActions) {
                FaultDescription faultDesc;
                String className = null;
                if (faultAction instanceof FaultActionAnnot && ((FaultActionAnnot)faultAction).classNameString() != null) {
                    className = ((FaultActionAnnot)faultAction).classNameString();
                } else if (faultAction.className() != null) {
                    className = faultAction.className().getName();
                }
                if (className == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Looking for FaultDescription for class: " + className + " from @FaultAction annotation");
                }
                if ((faultDesc = this.resolveFaultByExceptionName(className)) == null) continue;
                String faultActionString = faultAction.value();
                if (log.isDebugEnabled()) {
                    log.debug("faultAction value = " + faultActionString);
                }
                if (faultActionString == null || faultActionString.equals("")) continue;
                newAxisOperation.addFaultAction(className, faultActionString);
            }
        }
    }

    void addToAxisService(AxisService axisService) {
        AxisOperation newAxisOperation = this.getAxisOperation();
        QName axisOpQName = newAxisOperation.getName();
        AxisOperation existingAxisOperation = (AxisOperation)axisService.getChild(axisOpQName);
        if (existingAxisOperation == null) {
            axisService.addOperation(newAxisOperation);
        }
        if (this.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getSoapBindingUse() == SOAPBinding.Use.LITERAL && this.getSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.BARE) {
            QName elementQName;
            AxisMessage axisMessage = null;
            axisMessage = existingAxisOperation != null ? existingAxisOperation.getMessage("In") : newAxisOperation.getMessage("In");
            if (axisMessage != null && !DescriptionUtils.isEmpty(elementQName = axisMessage.getElementQName()) && axisService.getOperationByMessageElementQName(elementQName) == null) {
                axisService.addMessageElementQNameToOperationMapping(elementQName, newAxisOperation);
            }
        }
    }

    void setSEIMethod(Method method) {
        if (this.seiMethod != null) {
            throw ExceptionFactory.makeWebServiceException(new UnsupportedOperationException(Messages.getMessage("seiMethodErr")));
        }
        this.webMethodAnnotation = null;
        this.webMethodOperationName = null;
        this.webMethodAction = null;
        this.webMethodExclude = null;
        this.requestWrapperAnnotation = null;
        this.requestWrapperLocalName = null;
        this.requestWrapperTargetNamespace = null;
        this.requestWrapperClassName = null;
        this.requestWrapperPartName = null;
        this.responseWrapperAnnotation = null;
        this.responseWrapperLocalName = null;
        this.responseWrapperTargetNamespace = null;
        this.responseWrapperClassName = null;
        this.responseWrapperPartName = null;
        this.webParamNames = null;
        this.webParamTargetNamespace = null;
        this.webParamMode = null;
        this.webResultAnnotation = null;
        this.webResultName = null;
        this.webResultPartName = null;
        this.webResultTargetNamespace = null;
        this.webResultHeader = null;
        this.soapBindingAnnotation = null;
        this.soapBindingStyle = null;
        this.soapBindingUse = null;
        this.soapBindingParameterStyle = null;
        this.actionAnnotation = null;
        this.onewayAnnotation = null;
        this.onewayIsOneway = null;
        this.resultActualTypeClazz = null;
        this.seiMethod = method;
        this.webMethodAnnotation = (WebMethod)OperationDescriptionImpl.getAnnotation(this.seiMethod, WebMethod.class);
        this.parameterDescriptions = this.createParameterDescriptions();
        this.faultDescriptions = this.createFaultDescriptions();
        this.isListType = ConverterUtils.hasXmlListAnnotation(this.seiMethod.getAnnotations());
        this.registerMustUnderstandHeaders();
    }

    public EndpointInterfaceDescription getEndpointInterfaceDescription() {
        return this.parentEndpointInterfaceDescription;
    }

    public EndpointInterfaceDescriptionImpl getEndpointInterfaceDescriptionImpl() {
        return (EndpointInterfaceDescriptionImpl)this.parentEndpointInterfaceDescription;
    }

    public AxisOperation getAxisOperation() {
        OperationDescription opDesc;
        if (this.axisOperation == null && (opDesc = this.getSyncOperation()) != null && opDesc != this) {
            return this.getSyncOperation().getAxisOperation();
        }
        return this.axisOperation;
    }

    public QName getName() {
        return this.operationQName;
    }

    public String getJavaMethodName() {
        String returnString = null;
        if (!this.isDBC()) {
            if (this.seiMethod != null) {
                returnString = this.seiMethod.getName();
            }
        } else if (this.methodComposite != null) {
            returnString = this.methodComposite.getMethodName();
        }
        return returnString;
    }

    public String getJavaDeclaringClassName() {
        if (!this.isDBC() && this.seiMethod != null) {
            Class<?> clazz = this.seiMethod.getDeclaringClass();
            return clazz.getCanonicalName();
        }
        if (this.methodComposite != null) {
            return this.methodComposite.getDeclaringClass();
        }
        return null;
    }

    public String[] getJavaParameters() {
        ArrayList<String> returnParameters;
        block4: {
            block3: {
                Class<?>[] paramaters;
                returnParameters = new ArrayList<String>();
                if (this.isDBC()) break block3;
                if (this.seiMethod == null) break block4;
                for (Class<?> param : paramaters = this.seiMethod.getParameterTypes()) {
                    returnParameters.add(param.getName());
                }
                break block4;
            }
            if (this.methodComposite != null) {
                Iterator<ParameterDescriptionComposite> iter = this.methodComposite.getParameterDescriptionCompositeList().iterator();
                while (iter.hasNext()) {
                    returnParameters.add(iter.next().getParameterType());
                }
            }
        }
        return returnParameters.toArray(new String[0]);
    }

    public Method getSEIMethod() {
        return this.seiMethod;
    }

    MethodDescriptionComposite getMethodDescriptionComposite() {
        return this.methodComposite;
    }

    private boolean isWrappedParameters() {
        return this.getSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
    }

    private ParameterDescription[] createParameterDescriptions() {
        ArrayList<ParameterDescriptionImpl> buildParameterList = new ArrayList<ParameterDescriptionImpl>();
        if (!this.isDBC()) {
            Class<?>[] parameters = this.seiMethod.getParameterTypes();
            Type[] paramaterTypes = this.seiMethod.getGenericParameterTypes();
            Annotation[][] annotations = this.seiMethod.getParameterAnnotations();
            for (int i = 0; i < parameters.length; ++i) {
                ParameterDescriptionImpl paramDesc = new ParameterDescriptionImpl(i, parameters[i], paramaterTypes[i], annotations[i], this);
                buildParameterList.add(paramDesc);
            }
        } else {
            for (int i = 0; i < this.methodComposite.getParameterDescriptionCompositeList().size(); ++i) {
                ParameterDescriptionImpl paramDesc = new ParameterDescriptionImpl(i, this.methodComposite.getParameterDescriptionComposite(i), this);
                buildParameterList.add(paramDesc);
            }
        }
        return buildParameterList.toArray(new ParameterDescription[buildParameterList.size()]);
    }

    private FaultDescription[] createFaultDescriptions() {
        ArrayList<FaultDescriptionImpl> buildFaultList;
        block4: {
            block3: {
                Class<?>[] webFaultClasses;
                buildFaultList = new ArrayList<FaultDescriptionImpl>();
                if (this.isDBC()) break block3;
                for (Class<?> wfClass : webFaultClasses = this.seiMethod.getExceptionTypes()) {
                    WebFault wfanno = null;
                    for (Annotation anno : wfClass.getAnnotations()) {
                        if (anno.annotationType() != WebFault.class) continue;
                        wfanno = (WebFault)anno;
                    }
                    buildFaultList.add(new FaultDescriptionImpl(wfClass, wfanno, this));
                }
                break block4;
            }
            String[] webFaultClassNames = this.methodComposite.getExceptions();
            HashMap<String, DescriptionBuilderComposite> dbcMap = this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap();
            if (webFaultClassNames == null) break block4;
            for (String wfClassName : webFaultClassNames) {
                DescriptionBuilderComposite faultDBC = dbcMap.get(wfClassName);
                if (faultDBC == null) continue;
                buildFaultList.add(new FaultDescriptionImpl(faultDBC, this));
            }
        }
        return buildFaultList.toArray(new FaultDescription[0]);
    }

    public WebMethod getAnnoWebMethod() {
        if (this.webMethodAnnotation == null) {
            if (this.isDBC() && this.methodComposite != null) {
                this.webMethodAnnotation = this.methodComposite.getWebMethodAnnot();
            } else if (!this.isDBC() && this.seiMethod != null) {
                this.webMethodAnnotation = (WebMethod)OperationDescriptionImpl.getAnnotation(this.seiMethod, WebMethod.class);
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get WebMethod annotation");
            }
        }
        return this.webMethodAnnotation;
    }

    static QName determineOperationQName(Method javaMethod) {
        if (log.isDebugEnabled()) {
            log.debug("Operation QName determined to be: " + new QName(OperationDescriptionImpl.determineOperationName(javaMethod)));
        }
        return new QName(OperationDescriptionImpl.determineOperationName(javaMethod));
    }

    public static QName determineOperationQName(EndpointInterfaceDescription eid, MethodDescriptionComposite mdc) {
        if (log.isDebugEnabled()) {
            log.debug("Operation QName determined to be: " + (eid != null ? new QName(eid.getTargetNamespace(), OperationDescriptionImpl.determineOperationName(mdc)) : new QName(OperationDescriptionImpl.determineOperationName(mdc))));
        }
        return eid != null ? new QName(eid.getTargetNamespace(), OperationDescriptionImpl.determineOperationName(mdc)) : new QName(OperationDescriptionImpl.determineOperationName(mdc));
    }

    private static String determineOperationName(Method javaMethod) {
        String operationName = null;
        if (javaMethod == null) {
            return null;
        }
        WebMethod wmAnnotation = (WebMethod)OperationDescriptionImpl.getAnnotation(javaMethod, WebMethod.class);
        operationName = wmAnnotation != null && !DescriptionUtils.isEmpty(wmAnnotation.operationName()) ? wmAnnotation.operationName() : javaMethod.getName();
        return operationName;
    }

    private static String determineOperationName(MethodDescriptionComposite mdc) {
        String operationName = null;
        if (mdc == null) {
            return null;
        }
        WebMethodAnnot wmAnnotation = mdc.getWebMethodAnnot();
        operationName = wmAnnotation != null && !DescriptionUtils.isEmpty(wmAnnotation.operationName()) ? wmAnnotation.operationName() : mdc.getMethodName();
        return operationName;
    }

    public String getOperationName() {
        return this.getAnnoWebMethodOperationName();
    }

    public String getAnnoWebMethodOperationName() {
        if (this.webMethodOperationName == null) {
            if (!this.isDBC() && this.seiMethod != null) {
                this.webMethodOperationName = OperationDescriptionImpl.determineOperationName(this.seiMethod);
            } else if (this.methodComposite != null) {
                this.webMethodOperationName = OperationDescriptionImpl.determineOperationName(this.methodComposite);
            }
        }
        return this.webMethodOperationName;
    }

    public OperationDescription getSyncOperation() {
        if (log.isDebugEnabled()) {
            log.debug("Current OperationDescription Web Method annotation \"operation\" name: " + this.getOperationName());
            log.debug("Current OperationDescription java method name: " + this.getJavaMethodName());
        }
        if (this.syncOperationDescription == null) {
            if (!this.isJAXWSAsyncClientMethod()) {
                this.syncOperationDescription = this;
            } else {
                EndpointInterfaceDescription eid;
                OperationDescription opDesc = null;
                String webMethodAnnoName = this.getOperationName();
                String javaMethodName = this.getJavaMethodName();
                if (webMethodAnnoName != null && webMethodAnnoName.length() > 0 && webMethodAnnoName != javaMethodName && (eid = this.getEndpointInterfaceDescription()) != null) {
                    OperationDescription[] allOperations;
                    for (OperationDescription operation : allOperations = eid.getOperations()) {
                        if (!webMethodAnnoName.equals(operation.getOperationName()) || operation.isJAXWSAsyncClientMethod()) continue;
                        opDesc = operation;
                        break;
                    }
                }
                this.syncOperationDescription = opDesc;
            }
        }
        if (log.isDebugEnabled()) {
            if (this.syncOperationDescription != null) {
                log.debug("Synchronous operationDescription: " + this.syncOperationDescription.getOperationName());
            } else {
                log.debug("Synchronous operationDescription: null");
            }
        }
        return this.syncOperationDescription;
    }

    public String getAction() {
        return this.getAnnoWebMethodAction();
    }

    public String getAnnoWebMethodAction() {
        if (this.webMethodAction == null) {
            this.webMethodAction = this.getAnnoWebMethod() != null && !DescriptionUtils.isEmpty(this.getAnnoWebMethod().action()) ? this.getAnnoWebMethod().action() : "";
        }
        return this.webMethodAction;
    }

    public boolean isExcluded() {
        return this.getAnnoWebMethodExclude();
    }

    public boolean getAnnoWebMethodExclude() {
        if (this.webMethodExclude == null) {
            this.webMethodExclude = this.getAnnoWebMethod() != null ? Boolean.valueOf(this.getAnnoWebMethod().exclude()) : WebMethod_Exclude_DEFAULT;
        }
        return this.webMethodExclude;
    }

    public RequestWrapper getAnnoRequestWrapper() {
        if (this.requestWrapperAnnotation == null) {
            if (!this.isDBC() && this.seiMethod != null) {
                this.requestWrapperAnnotation = (RequestWrapper)OperationDescriptionImpl.getAnnotation(this.seiMethod, RequestWrapper.class);
            } else if (this.isDBC() && this.methodComposite != null) {
                this.requestWrapperAnnotation = this.methodComposite.getRequestWrapperAnnot();
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get RequestWrapper annotation");
            }
        }
        return this.requestWrapperAnnotation;
    }

    public String getRequestWrapperLocalName() {
        return this.getAnnoRequestWrapperLocalName();
    }

    public String getAnnoRequestWrapperLocalName() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.requestWrapperLocalName == null) {
            this.requestWrapperLocalName = this.getAnnoRequestWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoRequestWrapper().localName()) ? this.getAnnoRequestWrapper().localName() : this.getAnnoWebMethodOperationName();
        }
        return this.requestWrapperLocalName;
    }

    public String getRequestWrapperTargetNamespace() {
        return this.getAnnoRequestWrapperTargetNamespace();
    }

    public String getAnnoRequestWrapperTargetNamespace() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.requestWrapperTargetNamespace == null) {
            this.requestWrapperTargetNamespace = this.getAnnoRequestWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoRequestWrapper().targetNamespace()) ? this.getAnnoRequestWrapper().targetNamespace() : this.getEndpointInterfaceDescription().getTargetNamespace();
        }
        return this.requestWrapperTargetNamespace;
    }

    public String getRequestWrapperClassName() {
        return this.getAnnoRequestWrapperClassName();
    }

    public String getAnnoRequestWrapperClassName() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.requestWrapperClassName == null) {
            this.requestWrapperClassName = this.getAnnoRequestWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoRequestWrapper().className()) ? this.getAnnoRequestWrapper().className() : null;
        }
        return this.requestWrapperClassName;
    }

    public String getRequestWrapperPartName() {
        return this.getAnnoRequestWrapperPartName();
    }

    public String getAnnoRequestWrapperPartName() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.requestWrapperPartName == null) {
            this.requestWrapperPartName = this.getAnnoRequestWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoRequestWrapper().partName()) ? this.getAnnoRequestWrapper().partName() : null;
        }
        if (log.isDebugEnabled()) {
            if (this.requestWrapperPartName != null) {
                log.debug("RequestWrapperPartName =" + this.requestWrapperPartName);
            } else {
                log.debug("RequestWrapperPartName = NULL");
            }
        }
        return this.requestWrapperPartName;
    }

    public ResponseWrapper getAnnoResponseWrapper() {
        if (this.responseWrapperAnnotation == null) {
            if (!this.isDBC() && this.seiMethod != null) {
                this.responseWrapperAnnotation = (ResponseWrapper)OperationDescriptionImpl.getAnnotation(this.seiMethod, ResponseWrapper.class);
            } else if (this.isDBC() && this.methodComposite != null) {
                this.responseWrapperAnnotation = this.methodComposite.getResponseWrapperAnnot();
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get ResponseWrapper annotation");
            }
        }
        return this.responseWrapperAnnotation;
    }

    public String getResponseWrapperLocalName() {
        return this.getAnnoResponseWrapperLocalName();
    }

    public String getAnnoResponseWrapperLocalName() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.responseWrapperLocalName == null) {
            this.responseWrapperLocalName = this.getAnnoResponseWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoResponseWrapper().localName()) ? this.getAnnoResponseWrapper().localName() : this.getAnnoWebMethodOperationName() + "Response";
        }
        return this.responseWrapperLocalName;
    }

    public String getResponseWrapperTargetNamespace() {
        return this.getAnnoResponseWrapperTargetNamespace();
    }

    public String getAnnoResponseWrapperTargetNamespace() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.responseWrapperTargetNamespace == null) {
            this.responseWrapperTargetNamespace = this.getAnnoResponseWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoResponseWrapper().targetNamespace()) ? this.getAnnoResponseWrapper().targetNamespace() : this.getEndpointInterfaceDescription().getTargetNamespace();
        }
        return this.responseWrapperTargetNamespace;
    }

    public String getResponseWrapperClassName() {
        return this.getAnnoResponseWrapperClassName();
    }

    public String getAnnoResponseWrapperClassName() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.responseWrapperClassName == null) {
            this.responseWrapperClassName = this.getAnnoResponseWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoResponseWrapper().className()) ? this.getAnnoResponseWrapper().className() : null;
        }
        return this.responseWrapperClassName;
    }

    public String getResponseWrapperPartName() {
        return this.getAnnoResponseWrapperPartName();
    }

    public String getAnnoResponseWrapperPartName() {
        if (!this.isWrappedParameters()) {
            return null;
        }
        if (this.responseWrapperPartName == null) {
            this.responseWrapperPartName = this.getAnnoResponseWrapper() != null && !DescriptionUtils.isEmpty(this.getAnnoResponseWrapper().partName()) ? this.getAnnoResponseWrapper().partName() : null;
        }
        if (log.isDebugEnabled()) {
            if (this.responseWrapperPartName != null) {
                log.debug("ResponseWrapperPartName =" + this.responseWrapperPartName);
            } else {
                log.debug("ResponseWrapperPartName = NULL");
            }
        }
        return this.responseWrapperPartName;
    }

    public FaultDescription[] getFaultDescriptions() {
        return this.faultDescriptions;
    }

    public FaultDescription resolveFaultByExceptionName(String exceptionClassName) {
        if (this.faultDescriptions != null) {
            for (FaultDescription fd : this.faultDescriptions) {
                if (!exceptionClassName.equals(fd.getExceptionClassName())) continue;
                return fd;
            }
        }
        return null;
    }

    public ParameterDescription[] getParameterDescriptions() {
        return this.parameterDescriptions;
    }

    public ParameterDescription getParameterDescription(String parameterName) {
        ParameterDescription matchingParamDesc = null;
        if (parameterName != null && !parameterName.equals("")) {
            for (ParameterDescription paramDesc : this.parameterDescriptions) {
                if (!parameterName.equals(paramDesc.getParameterName())) continue;
                matchingParamDesc = paramDesc;
                break;
            }
        }
        return matchingParamDesc;
    }

    public ParameterDescription getParameterDescription(int parameterNumber) {
        return this.parameterDescriptions[parameterNumber];
    }

    public String[] getParamNames() {
        return this.getAnnoWebParamNames();
    }

    public String[] getAnnoWebParamNames() {
        if (this.webParamNames == null) {
            ParameterDescription[] paramDescs;
            ArrayList<String> buildNames = new ArrayList<String>();
            for (ParameterDescription currentParamDesc : paramDescs = this.getParameterDescriptions()) {
                buildNames.add(currentParamDesc.getParameterName());
            }
            this.webParamNames = buildNames.toArray(new String[0]);
        }
        return this.webParamNames;
    }

    public String[] getAnnoWebParamTargetNamespaces() {
        if (this.webParamTargetNamespace == null) {
            ParameterDescription[] paramDescs;
            ArrayList<String> buildTargetNS = new ArrayList<String>();
            for (ParameterDescription currentParamDesc : paramDescs = this.getParameterDescriptions()) {
                buildTargetNS.add(currentParamDesc.getTargetNamespace());
            }
            this.webParamTargetNamespace = buildTargetNS.toArray(new String[0]);
        }
        return this.webParamTargetNamespace;
    }

    public String getAnnoWebParamTargetNamespace(String name) {
        String returnTargetNS = null;
        ParameterDescription paramDesc = this.getParameterDescription(name);
        if (paramDesc != null) {
            returnTargetNS = paramDesc.getTargetNamespace();
        }
        return returnTargetNS;
    }

    public WebParam.Mode[] getAnnoWebParamModes() {
        if (this.webParamMode == null) {
            ParameterDescription[] paramDescs;
            ArrayList<WebParam.Mode> buildModes = new ArrayList<WebParam.Mode>();
            for (ParameterDescription currentParamDesc : paramDescs = this.getParameterDescriptions()) {
                buildModes.add(((ParameterDescriptionJava)((Object)currentParamDesc)).getAnnoWebParamMode());
            }
            this.webParamMode = buildModes.toArray(new WebParam.Mode[0]);
        }
        return this.webParamMode;
    }

    public boolean isAnnoWebParamHeader(String name) {
        ParameterDescription paramDesc = this.getParameterDescription(name);
        if (paramDesc != null) {
            return paramDesc.isHeader();
        }
        return false;
    }

    public WebResult getAnnoWebResult() {
        if (this.webResultAnnotation == null) {
            if (!this.isDBC() && this.seiMethod != null) {
                this.webResultAnnotation = (WebResult)OperationDescriptionImpl.getAnnotation(this.seiMethod, WebResult.class);
            } else if (this.methodComposite != null) {
                this.webResultAnnotation = this.methodComposite.getWebResultAnnot();
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get WebResult annotation");
            }
        }
        return this.webResultAnnotation;
    }

    public boolean isWebResultAnnotationSpecified() {
        return this.getAnnoWebResult() != null;
    }

    public boolean isOperationReturningResult() {
        boolean isResult = false;
        if (!this.isAnnoOneWay()) {
            if (!this.isDBC() && this.seiMethod != null) {
                if (this.seiMethod.getReturnType() != Void.TYPE) {
                    isResult = true;
                }
            } else if (this.methodComposite != null) {
                if (!DescriptionUtils.isEmpty(this.methodComposite.getReturnType()) && !this.methodComposite.getReturnType().equals("void")) {
                    isResult = true;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("No class to determine if result is returned");
            }
        }
        return isResult;
    }

    public String getResultName() {
        return this.getAnnoWebResultName();
    }

    public String getAnnoWebResultName() {
        if (!this.isOperationReturningResult()) {
            return null;
        }
        if (this.webResultName == null) {
            this.webResultName = this.getAnnoWebResult() != null && !DescriptionUtils.isEmpty(this.getAnnoWebResult().name()) ? this.getAnnoWebResult().name() : (this.getAnnoSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getAnnoSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.BARE ? this.getAnnoWebMethodOperationName() + "Response" : "return");
        }
        return this.webResultName;
    }

    public String getResultPartName() {
        return this.getAnnoWebResultPartName();
    }

    public String getAnnoWebResultPartName() {
        if (!this.isOperationReturningResult()) {
            return null;
        }
        if (this.webResultPartName == null) {
            this.webResultPartName = this.getAnnoWebResult() != null && !DescriptionUtils.isEmpty(this.getAnnoWebResult().partName()) ? this.getAnnoWebResult().partName() : this.getAnnoWebResultName();
        }
        return this.webResultPartName;
    }

    public String getResultTargetNamespace() {
        return this.getAnnoWebResultTargetNamespace();
    }

    public String getAnnoWebResultTargetNamespace() {
        if (!this.isOperationReturningResult()) {
            return null;
        }
        if (this.webResultTargetNamespace == null) {
            this.webResultTargetNamespace = this.getAnnoWebResult() != null && !DescriptionUtils.isEmpty(this.getAnnoWebResult().targetNamespace()) ? this.getAnnoWebResult().targetNamespace() : (this.getAnnoSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getAnnoSoapBindingParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED && !this.getAnnoWebResultHeader() ? "" : ((EndpointDescriptionJava)((Object)this.getEndpointInterfaceDescription().getEndpointDescription())).getAnnoWebServiceTargetNamespace());
        }
        return this.webResultTargetNamespace;
    }

    public boolean isResultHeader() {
        return this.getAnnoWebResultHeader();
    }

    public boolean getAnnoWebResultHeader() {
        if (!this.isOperationReturningResult()) {
            return false;
        }
        if (this.webResultHeader == null) {
            this.webResultHeader = this.getAnnoWebResult() != null ? Boolean.valueOf(this.getAnnoWebResult().header()) : WebResult_Header_DEFAULT;
        }
        return this.webResultHeader;
    }

    public SOAPBinding getAnnoSoapBinding() {
        if (this.soapBindingAnnotation == null) {
            if (!this.isDBC() && this.seiMethod != null) {
                this.soapBindingAnnotation = (SOAPBinding)OperationDescriptionImpl.getAnnotation(this.seiMethod, SOAPBinding.class);
            } else if (this.isDBC() && this.methodComposite != null) {
                this.soapBindingAnnotation = this.methodComposite.getSoapBindingAnnot();
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get SOAP Binding annotation");
            }
        }
        return this.soapBindingAnnotation;
    }

    public SOAPBinding.Style getSoapBindingStyle() {
        return this.getAnnoSoapBindingStyle();
    }

    public SOAPBinding.Style getAnnoSoapBindingStyle() {
        if (this.soapBindingStyle == null) {
            this.soapBindingStyle = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().style() != null ? this.getAnnoSoapBinding().style() : this.getEndpointInterfaceDescription().getSoapBindingStyle();
        }
        return this.soapBindingStyle;
    }

    public SOAPBinding.Use getSoapBindingUse() {
        return this.getAnnoSoapBindingUse();
    }

    public SOAPBinding.Use getAnnoSoapBindingUse() {
        if (this.soapBindingUse == null) {
            this.soapBindingUse = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().use() != null ? this.getAnnoSoapBinding().use() : this.getEndpointInterfaceDescription().getSoapBindingUse();
        }
        return this.soapBindingUse;
    }

    public SOAPBinding.ParameterStyle getSoapBindingParameterStyle() {
        return this.getAnnoSoapBindingParameterStyle();
    }

    public SOAPBinding.ParameterStyle getAnnoSoapBindingParameterStyle() {
        if (this.soapBindingParameterStyle == null) {
            this.soapBindingParameterStyle = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().parameterStyle() != null ? this.getAnnoSoapBinding().parameterStyle() : this.getEndpointInterfaceDescription().getSoapBindingParameterStyle();
        }
        return this.soapBindingParameterStyle;
    }

    public Action getAnnoAction() {
        if (this.actionAnnotation == null) {
            if (!this.isDBC() && this.seiMethod != null) {
                this.actionAnnotation = (Action)OperationDescriptionImpl.getAnnotation(this.seiMethod, Action.class);
            } else if (this.methodComposite != null) {
                this.actionAnnotation = this.methodComposite.getActionAnnot();
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get Action annotation.");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("getAnnoAction: " + this.actionAnnotation);
        }
        return this.actionAnnotation;
    }

    private String getInputAction() {
        String inputAction = null;
        Action action = this.getAnnoAction();
        if (action != null) {
            inputAction = action.input();
        }
        if (log.isDebugEnabled()) {
            log.debug("getInputAction: " + inputAction);
        }
        return inputAction;
    }

    private String getOutputAction() {
        String outputAction = null;
        Action action = this.getAnnoAction();
        if (action != null) {
            outputAction = action.output();
        }
        if (log.isDebugEnabled()) {
            log.debug("getOutputAction: " + outputAction);
        }
        return outputAction;
    }

    private FaultAction[] getFaultActions() {
        Object[] faultActions = null;
        Action action = this.getAnnoAction();
        if (action != null) {
            faultActions = action.fault();
        }
        if (log.isDebugEnabled()) {
            log.debug("getFaultActions: " + Arrays.toString(faultActions));
        }
        return faultActions;
    }

    public Oneway getAnnoOneway() {
        if (this.onewayAnnotation == null) {
            if (this.isDBC() && this.methodComposite != null) {
                if (this.methodComposite.isOneWay()) {
                    this.onewayAnnotation = OneWayAnnot.createOneWayAnnotImpl();
                }
            } else if (!this.isDBC() && this.seiMethod != null) {
                this.onewayAnnotation = (Oneway)OperationDescriptionImpl.getAnnotation(this.seiMethod, Oneway.class);
            } else if (log.isDebugEnabled()) {
                log.debug("Unable to get OneWay annotation");
            }
        }
        return this.onewayAnnotation;
    }

    public boolean isOneWay() {
        return this.isAnnoOneWay();
    }

    public boolean isAnnoOneWay() {
        if (this.onewayIsOneway == null) {
            this.onewayIsOneway = this.getAnnoOneway() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.onewayIsOneway;
    }

    private boolean isDBC() {
        return this.methodComposite != null;
    }

    public Class getResultType() {
        Class<?> returnClass = null;
        if (!this.isDBC() && this.getSEIMethod() != null) {
            Method seiMethod = this.getSEIMethod();
            returnClass = seiMethod.getReturnType();
        } else if (this.methodComposite != null) {
            returnClass = this.methodComposite.getReturnTypeClass();
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to get result type from null class");
        }
        return returnClass;
    }

    public Class getResultActualType() {
        if (this.resultActualTypeClazz == null) {
            this.resultActualTypeClazz = this.findResultActualType();
        }
        return this.resultActualTypeClazz;
    }

    public Class findResultActualType() {
        Class returnType = this.getResultType();
        if (returnType == null) {
            return null;
        }
        if (this.isJAXWSAsyncClientMethod()) {
            if (Response.class == returnType) {
                if (!this.isDBC()) {
                    Type type = this.seiMethod.getGenericReturnType();
                    ParameterizedType pType = (ParameterizedType)type;
                    Type aType = pType.getActualTypeArguments()[0];
                    if (aType != null && ParameterizedType.class.isInstance(aType)) {
                        return (Class)((ParameterizedType)aType).getRawType();
                    }
                    return (Class)aType;
                }
                return returnType;
            }
            Type[] type = this.getGenericParameterTypes();
            Class[] parameters = this.getParameterTypes();
            int i = 0;
            for (Class param : parameters) {
                if (AsyncHandler.class.isAssignableFrom(param)) {
                    ParameterizedType pType = (ParameterizedType)type[i];
                    Type aType = pType.getActualTypeArguments()[0];
                    if (aType != null && ParameterizedType.class.isInstance(aType)) {
                        return (Class)((ParameterizedType)aType).getRawType();
                    }
                    return (Class)aType;
                }
                ++i;
            }
        }
        return returnType;
    }

    private Type[] getGenericParameterTypes() {
        if (this.isDBC()) {
            throw ExceptionFactory.makeWebServiceException(new UnsupportedOperationException(Messages.getMessage("genParamTypesErr")));
        }
        Type[] type = this.seiMethod.getGenericParameterTypes();
        return type;
    }

    private Class[] getParameterTypes() {
        if (this.isDBC()) {
            Class[] parameters = new Class[this.parameterDescriptions.length];
            for (int i = 0; i < this.parameterDescriptions.length; ++i) {
                parameters[i] = this.parameterDescriptions[i].getParameterType();
            }
            return parameters;
        }
        Class[] parameters = this.seiMethod.getParameterTypes();
        return parameters;
    }

    public boolean isJAXWSAsyncClientMethod() {
        boolean answer = false;
        String methodName = null;
        String returnTypeName = null;
        if (this.isDBC()) {
            methodName = this.getMethodDescriptionComposite().getMethodName();
            returnTypeName = this.getMethodDescriptionComposite().getReturnType();
        } else {
            Method method = this.getSEIMethod();
            if (method != null) {
                methodName = method.getName();
                returnTypeName = method.getReturnType().getName();
            }
        }
        if (methodName != null && returnTypeName != null) {
            boolean bl = answer = returnTypeName.contains(Response.class.getName()) || returnTypeName.contains(Future.class.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Method = " + methodName);
            log.debug("Return Type = " + returnTypeName);
            log.debug("Is client async = " + answer);
        }
        return answer;
    }

    private Method getMethodFromServiceImpl() {
        return this.serviceImplMethod;
    }

    public Method getMethodFromServiceImpl(Class serviceImpl) {
        if (!this.serviceImplMethodFound) {
            Method[] methods = serviceImpl.getMethods();
            String opDescMethodName = this.getJavaMethodName();
            ParameterDescription[] paramDesc = this.getParameterDescriptions();
            int numberOfParams = 0;
            if (paramDesc != null) {
                numberOfParams = paramDesc.length;
            }
            for (Method checkMethod : methods) {
                Class[] methodParams;
                if (!checkMethod.getName().equals(opDescMethodName) || (methodParams = checkMethod.getParameterTypes()).length != numberOfParams || !this.paramTypesMatch(paramDesc, methodParams)) continue;
                this.serviceImplMethod = checkMethod;
                break;
            }
            this.serviceImplMethodFound = true;
        }
        return this.serviceImplMethod;
    }

    private boolean paramTypesMatch(ParameterDescription[] paramDescs, Class[] methodParams) {
        for (int i = 0; i < paramDescs.length; ++i) {
            String mParamType = methodParams[i].getName();
            String pdType = this.getPDType(paramDescs[i]);
            if (mParamType != null && mParamType.equals(pdType)) continue;
            return false;
        }
        return true;
    }

    private String getPDType(ParameterDescription pd) {
        String type = null;
        if (pd.getParameterType() != null) {
            type = pd.getParameterType().getName();
        } else if (pd.getParameterActualType() != null) {
            type = pd.getParameterActualType().getName();
        }
        return type;
    }

    public OperationRuntimeDescription getOperationRuntimeDesc(String name) {
        return this.runtimeDescMap.get(name);
    }

    public void setOperationRuntimeDesc(OperationRuntimeDescription ord) {
        this.runtimeDescMap.put(ord.getKey(), ord);
    }

    public boolean isListType() {
        return this.isListType;
    }

    public String getBindingInputNamespace() {
        String tns = null;
        Binding binding = this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getWSDLBinding();
        if (binding != null) {
            BindingOperation bindingOp;
            if (log.isDebugEnabled()) {
                log.debug("Found WSDL binding");
            }
            if ((bindingOp = binding.getBindingOperation(this.getOperationName(), null, null)) != null && bindingOp.getBindingInput() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found WSDL binding operation and input");
                }
                if ((tns = this.getBindingNamespace(bindingOp.getBindingInput())) != null && log.isDebugEnabled()) {
                    log.debug("For operation: " + bindingOp.getName() + " returning the following namespace for input message from WSDL: " + tns);
                }
            }
        }
        if (tns == null) {
            tns = this.getEndpointInterfaceDescription().getTargetNamespace();
            if (log.isDebugEnabled()) {
                log.debug("For binding input returning @WebService.targetNamespace: " + tns);
            }
        }
        return tns;
    }

    public String getBindingOutputNamespace() {
        String tns = null;
        Binding binding = this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getWSDLBinding();
        if (binding != null) {
            BindingOperation bindingOp;
            if (log.isDebugEnabled()) {
                log.debug("Found WSDL binding");
            }
            if ((bindingOp = binding.getBindingOperation(this.getOperationName(), null, null)) != null && bindingOp.getBindingOutput() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found WSDL binding operation and output");
                }
                if ((tns = this.getBindingNamespace(bindingOp.getBindingOutput())) != null && log.isDebugEnabled()) {
                    log.debug("For operation: " + bindingOp.getName() + " returning the following namespace for output message from WSDL: " + tns);
                }
            }
        }
        if (tns == null) {
            tns = this.getEndpointInterfaceDescription().getTargetNamespace();
            if (log.isDebugEnabled()) {
                log.debug("For binding output returning @WebService.targetNamespace: " + tns);
            }
        }
        return tns;
    }

    private String getBindingNamespace(AttributeExtensible opInfo) {
        if (opInfo instanceof BindingInput) {
            BindingInput input = (BindingInput)opInfo;
            return DescriptionUtils.getNamespaceFromSOAPElement(input.getExtensibilityElements());
        }
        if (opInfo instanceof BindingOutput) {
            BindingOutput output = (BindingOutput)opInfo;
            return DescriptionUtils.getNamespaceFromSOAPElement(output.getExtensibilityElements());
        }
        return null;
    }

    public AttachmentDescription getResultAttachmentDescription() {
        String partName = this.getResultPartName();
        if (partName != null) {
            if (log.isDebugEnabled()) {
                log.debug("Returning result AttachmentDescription for partName: " + partName);
            }
            return this.partAttachmentMap.get(partName);
        }
        if (log.isDebugEnabled()) {
            log.debug("Did not find result AttachmentDescription for partName");
        }
        return null;
    }

    private void buildAttachmentInformation() {
        if (log.isDebugEnabled()) {
            log.debug("Start buildAttachmentInformation");
        }
        if (this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().isWSDLFullySpecified()) {
            if (log.isDebugEnabled()) {
                log.debug("A full WSDL is available.  Query the WSDL binding for the AttachmentDescription information.");
            }
            DescriptionUtils.getAttachmentFromBinding(this, this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getWSDLBinding());
        } else {
            String wsdlLocation;
            if (log.isDebugEnabled()) {
                log.debug("The WSDL is not available.  Looking for @WebService wsdlLocation.");
            }
            if ((wsdlLocation = this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getAnnoWebServiceWSDLLocation()) == null || wsdlLocation.length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("@WebService wsdlLocation is not specified.  Processing continues without AttachmentDescription information");
                }
            } else {
                WSDL4JWrapper wsdl4j;
                Definition def;
                block18: {
                    if (log.isDebugEnabled()) {
                        log.debug("@WebService wsdlLocation is " + wsdlLocation);
                    }
                    def = null;
                    wsdl4j = null;
                    try {
                        File file = new File(wsdlLocation);
                        URL url = file.toURI().toURL();
                        wsdl4j = new WSDL4JWrapper(url, true, 2);
                        def = wsdl4j.getDefinition();
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block18;
                        log.debug("Error occurred while loading WSDL.  Procesing continues without AttachmentDescription information. " + t);
                    }
                }
                if (def != null) {
                    Binding binding;
                    this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getServiceDescriptionImpl().setWsdlWrapper(wsdl4j);
                    if (log.isDebugEnabled()) {
                        log.debug("WSDL Definition is loaded.  Get the WSDL Binding.");
                    }
                    if ((binding = this.getEndpointInterfaceDescriptionImpl().getEndpointDescriptionImpl().getWSDLBinding()) == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("WSDL Binding was not found for serviceName=" + this.getEndpointInterfaceDescription().getEndpointDescription().getServiceQName() + " and portName=" + this.getEndpointInterfaceDescription().getEndpointDescription().getPortQName());
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Query Binding for AttachmentDescription Information");
                        }
                        DescriptionUtils.getAttachmentFromBinding(this, binding);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End buildAttachmentInformation");
        }
    }

    public AttachmentDescription getPartAttachmentDescription(String partName) {
        return this.partAttachmentMap.get(partName);
    }

    public void addPartAttachmentDescription(String partName, AttachmentDescription attachmentDesc) {
        this.partAttachmentMap.put(partName, attachmentDesc);
    }

    public boolean hasRequestSwaRefAttachments() {
        return this.hasRequestSwaRefAttachments;
    }

    public void setHasRequestSwaRefAttachments(boolean b) {
        this.hasRequestSwaRefAttachments = b;
    }

    public boolean hasResponseSwaRefAttachments() {
        return this.hasResponseSwaRefAttachments;
    }

    public void setHasResponseSwaRefAttachments(boolean b) {
        this.hasResponseSwaRefAttachments = b;
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Name: " + this.getName());
            string.append("; ");
            string.append("Operation Name: " + this.getOperationName());
            string.append("; ");
            string.append("Action: " + this.getAction());
            string.append("\n");
            string.append("Operation excluded: " + this.isExcluded());
            string.append("; ");
            string.append("Is oneway: " + this.isOneWay());
            string.append("; ");
            string.append("Is returning result: " + this.isOperationReturningResult());
            string.append("; ");
            string.append("Is result header: " + this.isResultHeader());
            string.append("; ");
            string.append("Is JAXWS Client Async method: " + this.isJAXWSAsyncClientMethod());
            string.append("\n");
            string.append("SOAP Style: " + (Object)((Object)this.getSoapBindingStyle()));
            string.append("; ");
            string.append("SOAP Use: " + (Object)((Object)this.getSoapBindingUse()));
            string.append("; ");
            string.append("SOAP Parameter Style: " + (Object)((Object)this.getSoapBindingParameterStyle()));
            string.append("\n");
            string.append("Result name: " + this.getResultName());
            string.append("; ");
            string.append("Result part name: " + this.getResultPartName());
            string.append("; ");
            string.append("Result type: " + this.getResultType());
            string.append("; ");
            string.append("Result actual type: " + this.getResultActualType());
            if (this.getResultAttachmentDescription() != null) {
                string.append("\n");
                string.append(this.getResultAttachmentDescription().toString());
            }
            string.append("\n");
            string.append("Request Wrapper class: " + this.getRequestWrapperClassName());
            string.append("; ");
            string.append("Response Wrapper class: " + this.getResponseWrapperClassName());
            string.append("\n");
            string.append("Java declaring class name: " + this.getJavaDeclaringClassName());
            string.append("\n");
            string.append("Java method name: " + this.getJavaMethodName());
            string.append("\n");
            string.append("Java parameters: " + Arrays.toString(this.getJavaParameters()));
            string.append("\n");
            string.append("Service Implementation method: " + this.getMethodFromServiceImpl());
            string.append("\n");
            string.append("Axis Operation: " + this.getAxisOperation());
            string.append("\n");
            ParameterDescription[] paramDescs = this.getParameterDescriptions();
            if (paramDescs != null && paramDescs.length > 0) {
                string.append("Number of Parameter Descriptions: " + paramDescs.length);
                for (ParameterDescription paramDesc : paramDescs) {
                    string.append("\n");
                    string.append("Parameter Description: " + paramDesc.toString());
                }
            } else {
                string.append("No Parameter Descriptions");
            }
            string.append("\n");
            FaultDescription[] faultDescs = this.getFaultDescriptions();
            if (faultDescs != null && faultDescs.length > 0) {
                string.append("Number of Fault Descriptions: " + faultDescs.length);
                for (FaultDescription faultDesc : faultDescs) {
                    string.append("\n");
                    string.append("Fault Description: " + faultDesc.toString());
                }
            } else {
                string.append("No Fault Descriptions");
            }
            if (!this.partAttachmentMap.isEmpty()) {
                string.append("\n");
                string.append("Number of Attachment Descriptions: " + this.partAttachmentMap.size());
                string.append("\n");
                Iterator<AttachmentDescription> adIter = this.partAttachmentMap.values().iterator();
                while (adIter.hasNext()) {
                    string.append(adIter.next().toString());
                    string.append("\n");
                }
            } else {
                string.append("\n");
                string.append("No Attachment Descriptions");
                string.append("\n");
            }
            string.append("RuntimeDescriptions:" + this.runtimeDescMap.size());
            string.append("\n");
            for (OperationRuntimeDescription runtimeDesc : this.runtimeDescMap.values()) {
                string.append(runtimeDesc.toString());
                string.append("\n");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for OperationDescription");
            return string.toString();
        }
        return string.toString();
    }

    private void registerMustUnderstandHeaders() {
        block10: {
            AxisOperation theAxisOperation = this.getAxisOperation();
            if (theAxisOperation == null) {
                if (log.isDebugEnabled()) {
                    log.debug("The axis operation is null, so header QNames could not be registered.  OpDesc = " + this);
                }
                return;
            }
            ParameterDescription[] paramDescs = this.getParameterDescriptions();
            ArrayList<QName> understoodQNames = new ArrayList<QName>();
            if (paramDescs != null && paramDescs.length > 0) {
                for (ParameterDescription paramDesc : paramDescs) {
                    QName headerQN;
                    if (paramDesc.isHeader() && (paramDesc.getMode() == WebParam.Mode.IN || paramDesc.getMode() == WebParam.Mode.INOUT)) {
                        headerQN = new QName(paramDesc.getTargetNamespace(), paramDesc.getParameterName());
                        understoodQNames.add(headerQN);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("OpDesc: understoodQName added to AxisOperation (if not null) as IN or INOUT param " + headerQN);
                        continue;
                    }
                    if (!paramDesc.isHeader() || paramDesc.getMode() != WebParam.Mode.OUT) continue;
                    headerQN = new QName(paramDesc.getTargetNamespace(), paramDesc.getParameterName());
                    understoodQNames.add(headerQN);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("OpDesc: understoodQName added to AxisOperation (if not null) as OUT param " + headerQN);
                }
            }
            if (this.isResultHeader() && this.getResultName() != null) {
                QName headerQN = new QName(this.getResultTargetNamespace(), this.getResultName());
                understoodQNames.add(headerQN);
                if (log.isDebugEnabled()) {
                    log.debug("OpDesc: understoodQName added to AxisOperation (if not null) as result param " + headerQN);
                }
            }
            if (!understoodQNames.isEmpty()) {
                Parameter headerQNParameter = new Parameter("org.apache.axis2.jaxws.description.OperationDescription.headerParameterQNames", understoodQNames);
                try {
                    theAxisOperation.addParameter(headerQNParameter);
                }
                catch (AxisFault e) {
                    log.warn(Messages.getMessage("regMUHeadersErr", theAxisOperation.getClass().getName(), e.getMessage()));
                    if (!log.isDebugEnabled()) break block10;
                    log.debug("Unable to add Parameter for header QNames to AxisOperation: " + theAxisOperation.getClass().getName(), e);
                }
            }
        }
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation2) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation2);
            }
        });
    }
}

