/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.framework;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDeployerSupport {
    private static final Log log = LogFactory.getLog(JAXWSDeployerSupport.class);
    private ConfigurationContext configurationContext;
    private String directory;

    public JAXWSDeployerSupport() {
        this(null, null);
    }

    public JAXWSDeployerSupport(ConfigurationContext configurationContext) {
        this(configurationContext, null);
    }

    public JAXWSDeployerSupport(ConfigurationContext configurationContext, String directory) {
        this.configurationContext = configurationContext;
        this.directory = directory;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    protected AxisServiceGroup deployClasses(String groupName, URL location, ClassLoader classLoader, List<String> classList) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        String serviceHierarchy = Utils.getServiceHierarchy(location.getPath(), this.directory);
        Collection<AxisService> axisServiceList = this.deployClasses(location, classLoader, classList).values();
        if (axisServiceList.size() > 0) {
            AxisServiceGroup serviceGroup = new AxisServiceGroup();
            Iterator<AxisService> axItr = axisServiceList.iterator();
            while (axItr.hasNext()) {
                serviceGroup.addService(axItr.next());
            }
            if (serviceHierarchy != null) {
                serviceGroup.setServiceGroupName(serviceHierarchy + groupName);
            }
            this.getConfigurationContext().getAxisConfiguration().addServiceGroup(serviceGroup);
            this.configureAddressing(serviceGroup);
            return serviceGroup;
        }
        return null;
    }

    protected HashMap<String, AxisService> deployClasses(URL location, ClassLoader classLoader, List<String> classList) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        HashMap<String, AxisService> services = new HashMap<String, AxisService>();
        String serviceHierarchy = Utils.getServiceHierarchy(location.getPath(), this.getDirectory());
        for (String className : classList) {
            AxisService axisService;
            Class pojoClass;
            try {
                pojoClass = Loader.loadClass(classLoader, className);
            }
            catch (Exception e) {
                continue;
            }
            WebService wsAnnotation = pojoClass.getAnnotation(WebService.class);
            WebServiceProvider wspAnnotation = null;
            if (wsAnnotation == null) {
                wspAnnotation = pojoClass.getAnnotation(WebServiceProvider.class);
            }
            if (wsAnnotation == null && wspAnnotation == null || pojoClass.isInterface() || (axisService = this.createAxisService(classLoader, className, location)) == null) continue;
            log.info("Deploying JAXWS annotated class " + className + " as a service - " + serviceHierarchy + axisService.getName());
            services.put(axisService.getName(), axisService);
        }
        return services;
    }

    protected AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        Class pojoClass = Loader.loadClass(classLoader, className);
        try {
            axisService = DescriptionFactory.createAxisService(pojoClass, this.getConfigurationContext());
        }
        catch (Throwable t) {
            log.info("Exception creating Axis Service : " + t.getCause(), t);
            return null;
        }
        if (axisService != null) {
            Iterator<AxisOperation> operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation axisOperation = operations.next();
                if (axisOperation.getMessageReceiver() != null) continue;
                axisOperation.setMessageReceiver(new JAXWSMessageReceiver());
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            axisService.setClassLoader(classLoader);
            axisService.addParameter(new Parameter("CACHE_CLASSLOADER", classLoader));
        }
        return axisService;
    }

    public List<String> getListOfClasses(DeploymentFileData deploymentFileData) throws DeploymentException {
        return Utils.getListOfClasses(deploymentFileData);
    }

    public List<String> getServiceClassNameFromMetaData(OMElement serviceMetaData) {
        ArrayList<String> classNames;
        block4: {
            block3: {
                classNames = new ArrayList<String>();
                if (!serviceMetaData.getLocalName().equals("serviceGroup")) break block3;
                Iterator services = serviceMetaData.getChildrenWithLocalName("service");
                while (services.hasNext()) {
                    Iterator parameters = ((OMElement)services.next()).getChildrenWithLocalName("parameter");
                    while (parameters.hasNext()) {
                        String value;
                        OMElement parameter = (OMElement)parameters.next();
                        OMAttribute att = parameter.getAttribute(new QName("name"));
                        if (att == null || (value = att.getAttributeValue()) == null || !"ServiceClass".equals(value)) continue;
                        classNames.add(parameter.getText());
                    }
                }
                break block4;
            }
            if (!serviceMetaData.getLocalName().equals("service")) break block4;
            Iterator parameters = serviceMetaData.getChildrenWithLocalName("parameter");
            while (parameters.hasNext()) {
                String value;
                OMElement parameter = (OMElement)parameters.next();
                OMAttribute att = parameter.getAttribute(new QName("name"));
                if (att == null || (value = att.getAttributeValue()) == null || !"ServiceClass".equals(value)) continue;
                classNames.add(parameter.getText());
            }
        }
        return classNames;
    }

    private void configureAddressing(AxisServiceGroup serviceGroup) {
        EndpointContextMap map = (EndpointContextMap)this.getConfigurationContext().getProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap");
        if (map == null) {
            map = EndpointContextMapManager.getEndpointContextMap();
            this.getConfigurationContext().setProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap", map);
        }
        Iterator<AxisService> iterator = serviceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService axisService = iterator.next();
            Parameter param = axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            QName serviceName = ed.getServiceQName();
            QName portName = ed.getPortQName();
            EndpointKey key = new EndpointKey(serviceName, portName);
            map.put(key, axisService);
        }
    }
}

