/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.attachments;

import javax.activation.DataHandler;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.AttachmentContext;
import org.apache.axis2.jaxws.message.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MessageAttachmentContext
implements AttachmentContext {
    private static final Log log = LogFactory.getLog(MessageAttachmentContext.class);
    private final Message message;

    public MessageAttachmentContext(Message message) {
        this.message = message;
    }

    public MessageContext getMessageContext() {
        MessageContext axisMessageContext = null;
        if (this.message != null && this.message.getMessageContext() != null) {
            axisMessageContext = this.message.getMessageContext().getAxisMessageContext();
        }
        return axisMessageContext;
    }

    public boolean isMTOMEnabled() {
        if (this.message == null) {
            return false;
        }
        return this.message.isMTOMEnabled();
    }

    public void setDoingSWA() {
        if (this.message != null) {
            this.message.setDoingSWA(true);
        }
    }

    public void addDataHandler(DataHandler dh, String cid) {
        if (this.message != null) {
            this.message.addDataHandler(dh, cid);
        } else if (log.isDebugEnabled()) {
            log.debug("The msgContext is null.  The attachment is not stored");
            log.debug("   content id=" + cid);
            log.debug("   dataHandler  =" + dh);
        }
    }

    public DataHandler getDataHandlerForSwA(String blobcid) {
        return this.message.getDataHandler(blobcid);
    }
}

