/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.XMLPart;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.MessageImpl;
import org.apache.axis2.jaxws.message.impl.XMLSpine;
import org.apache.axis2.jaxws.message.impl.XMLSpineImpl;
import org.apache.axis2.jaxws.message.util.XMLFaultUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLPartBase
implements XMLPart {
    private static Log log = LogFactory.getLog(XMLPartBase.class);
    Protocol protocol = Protocol.unknown;
    SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    int indirection = 0;
    Object content = null;
    int contentType = 0;
    static final int UNKNOWN = 0;
    static final int OM = 1;
    static final int SOAPENVELOPE = 2;
    static final int SPINE = 3;
    boolean consumed = false;
    MessageImpl parent;

    XMLPartBase(Protocol protocol) throws WebServiceException {
        if (protocol.equals((Object)Protocol.unknown)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ProtocolIsNotKnown"));
        }
        this.content = XMLPartBase._createSpine(protocol, this.getStyle(), this.getIndirection(), null);
        this.protocol = ((XMLSpine)this.content).getProtocol();
        this.contentType = 3;
    }

    XMLPartBase(OMElement root, Protocol protocol) throws WebServiceException {
        this.content = root;
        this.contentType = 1;
        QName qName = root.getQName();
        if (protocol == null) {
            if (qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                this.protocol = Protocol.soap11;
            } else if (qName.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                this.protocol = Protocol.soap12;
            }
        } else if (protocol == Protocol.rest) {
            this.protocol = Protocol.rest;
            if (!qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !qName.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                this.content = XMLPartBase._createSpine(Protocol.rest, SOAPBinding.Style.DOCUMENT, 0, root);
                this.contentType = 3;
            }
        } else {
            this.protocol = protocol;
        }
    }

    XMLPartBase(SOAPEnvelope root) throws WebServiceException {
        this.content = root;
        this.contentType = 2;
        String ns = root.getNamespaceURI();
        if (ns.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            this.protocol = Protocol.soap11;
        } else if (ns.equals("http://www.w3.org/2003/05/soap-envelope")) {
            this.protocol = Protocol.soap12;
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("RESTIsNotSupported"));
        }
    }

    private void setContent(Object content, int contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    private OMElement getContentAsOMElement() throws WebServiceException {
        OMElement om = null;
        switch (this.contentType) {
            case 1: {
                om = (OMElement)this.content;
                break;
            }
            case 3: {
                om = this._convertSpine2OM((XMLSpine)this.content);
                break;
            }
            case 2: {
                om = this._convertSE2OM((SOAPEnvelope)this.content);
                break;
            }
            default: {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("XMLPartImplErr2"));
            }
        }
        this.setContent(om, 1);
        return om;
    }

    private SOAPEnvelope getContentAsSOAPEnvelope() throws WebServiceException {
        SOAPEnvelope se = null;
        switch (this.contentType) {
            case 2: {
                se = (SOAPEnvelope)this.content;
                break;
            }
            case 3: {
                se = this._convertSpine2SE((XMLSpine)this.content);
                break;
            }
            case 1: {
                se = this._convertOM2SE((OMElement)this.content);
                break;
            }
            default: {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("XMLPartImplErr2"));
            }
        }
        this.setContent(se, 2);
        return se;
    }

    private XMLSpine getContentAsXMLSpine() throws WebServiceException {
        XMLSpine spine = null;
        switch (this.contentType) {
            case 3: {
                spine = (XMLSpine)this.content;
                break;
            }
            case 2: {
                spine = this._convertSE2Spine((SOAPEnvelope)this.content);
                break;
            }
            case 1: {
                spine = this._convertOM2Spine((OMElement)this.content);
                break;
            }
            default: {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("XMLPartImplErr2"));
            }
        }
        spine.setParent(this.getParent());
        this.setContent(spine, 3);
        return spine;
    }

    @Override
    public OMElement getAsOMElement() throws WebServiceException {
        return this.getContentAsOMElement();
    }

    @Override
    public SOAPEnvelope getAsSOAPEnvelope() throws WebServiceException {
        return this.getContentAsSOAPEnvelope();
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public SOAPBinding.Style getStyle() {
        return this.style;
    }

    @Override
    public int getIndirection() {
        return this.indirection;
    }

    @Override
    public void setStyle(SOAPBinding.Style style) throws WebServiceException {
        if (this.style != style && this.contentType == 3) {
            this.getContentAsOMElement();
        }
        this.style = style;
        if (style == SOAPBinding.Style.RPC) {
            this.setIndirection(1);
        } else {
            this.setIndirection(0);
        }
    }

    @Override
    public void setIndirection(int indirection) {
        if (this.indirection != indirection && this.contentType == 3) {
            this.getContentAsOMElement();
        }
        this.indirection = indirection;
    }

    @Override
    public QName getOperationElement() throws WebServiceException {
        try {
            if (this.style != SOAPBinding.Style.RPC) {
                return null;
            }
            switch (this.contentType) {
                case 1: {
                    return ((org.apache.axiom.soap.SOAPEnvelope)this.content).getBody().getFirstElement().getQName();
                }
                case 3: {
                    return ((XMLSpine)this.content).getOperationElement();
                }
                case 2: {
                    Iterator it = ((SOAPEnvelope)this.content).getBody().getChildElements();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        if (!(node instanceof SOAPElement)) continue;
                        Name name = ((SOAPElement)node).getElementName();
                        return new QName(name.getURI(), name.getLocalName(), name.getPrefix());
                    }
                    break;
                }
            }
            return null;
        }
        catch (SOAPException se) {
            throw ExceptionFactory.makeWebServiceException(se);
        }
    }

    @Override
    public void setOperationElement(QName operationQName) throws WebServiceException {
        if (this.indirection == 1) {
            this.getContentAsXMLSpine().setOperationElement(operationQName);
        }
    }

    @Override
    public String getXMLPartContentType() {
        switch (this.contentType) {
            case 1: {
                return "OM";
            }
            case 2: {
                return "SOAPENVELOPE";
            }
            case 3: {
                return "SPINE";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean consume) throws WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("XMLPartImplErr1"));
        }
        XMLStreamReader reader = null;
        if (this.contentType == 3) {
            reader = this.getContentAsXMLSpine().getXMLStreamReader(consume);
        } else {
            OMElement omElement = this.getContentAsOMElement();
            reader = consume ? omElement.getXMLStreamReaderWithoutCaching() : omElement.getXMLStreamReader();
        }
        this.setConsumed(consume);
        return reader;
    }

    @Override
    public XMLFault getXMLFault() throws WebServiceException {
        XMLSpine spine;
        Block[] blocks;
        XMLFault xmlFault = null;
        if (this.isFault() && (blocks = (xmlFault = (spine = this.getContentAsXMLSpine()).getXMLFault()).getDetailBlocks()) != null) {
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i].setParent(this.getParent());
            }
        }
        return xmlFault;
    }

    @Override
    public void setXMLFault(XMLFault xmlFault) throws WebServiceException {
        Block[] blocks = xmlFault.getDetailBlocks();
        if (blocks != null) {
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i].setParent(this.getParent());
            }
        }
        XMLSpine spine = this.getContentAsXMLSpine();
        spine.setXMLFault(xmlFault);
    }

    @Override
    public boolean isFault() throws WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("XMLPartImplErr1"));
        }
        try {
            switch (this.contentType) {
                case 1: {
                    return XMLFaultUtils.isFault((org.apache.axiom.soap.SOAPEnvelope)this.getContentAsOMElement());
                }
                case 2: {
                    return XMLFaultUtils.isFault(this.getContentAsSOAPEnvelope());
                }
                case 3: {
                    return this.getContentAsXMLSpine().isFault();
                }
            }
        }
        catch (SOAPException se) {
            throw ExceptionFactory.makeWebServiceException(se);
        }
        return false;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void outputTo(XMLStreamWriter writer, boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("XMLPartImplErr1"));
        }
        if (this.contentType == 3) {
            this.getContentAsXMLSpine().outputTo(writer, consume);
        } else {
            OMElement omElement = this.getContentAsOMElement();
            if (consume) {
                omElement.serializeAndConsume(writer);
            } else {
                omElement.serialize(writer);
            }
        }
        this.setConsumed(consume);
    }

    @Override
    public String traceString(String indent) {
        return null;
    }

    @Override
    public Block getBodyBlock(int index, Object context, BlockFactory blockFactory) throws WebServiceException {
        Block block = this.getContentAsXMLSpine().getBodyBlock(index, context, blockFactory);
        if (block != null) {
            block.setParent(this.getParent());
        }
        return block;
    }

    @Override
    public Block getBodyBlock(Object context, BlockFactory blockFactory) throws WebServiceException {
        Block block = this.getContentAsXMLSpine().getBodyBlock(context, blockFactory);
        if (block != null) {
            block.setParent(this.getParent());
        }
        return block;
    }

    @Override
    public Block getHeaderBlock(String namespace, String localPart, Object context, BlockFactory blockFactory) throws WebServiceException {
        Block block = this.getContentAsXMLSpine().getHeaderBlock(namespace, localPart, context, blockFactory);
        if (block != null) {
            block.setParent(this.getParent());
        }
        return block;
    }

    @Override
    public Set<QName> getHeaderQNames() {
        try {
            switch (this.contentType) {
                case 1: {
                    org.apache.axiom.soap.SOAPEnvelope se;
                    SOAPHeader header;
                    HashSet<QName> qnames = new HashSet<QName>();
                    OMElement om = this.getAsOMElement();
                    if (om instanceof org.apache.axiom.soap.SOAPEnvelope && (header = (se = (org.apache.axiom.soap.SOAPEnvelope)om).getHeader()) != null) {
                        Iterator it = header.getChildElements();
                        while (it != null && it.hasNext()) {
                            Object node = it.next();
                            if (!(node instanceof OMElement)) continue;
                            qnames.add(((OMElement)node).getQName());
                        }
                    }
                    return qnames;
                }
                case 2: {
                    javax.xml.soap.SOAPHeader header;
                    HashSet<QName> qnames = new HashSet<QName>();
                    SOAPEnvelope se = this.getContentAsSOAPEnvelope();
                    if (se != null && (header = se.getHeader()) != null) {
                        Iterator it = header.getChildElements();
                        while (it != null && it.hasNext()) {
                            Object node = it.next();
                            if (!(node instanceof SOAPElement)) continue;
                            qnames.add(((SOAPElement)node).getElementQName());
                        }
                    }
                    return qnames;
                }
                case 3: {
                    return this.getContentAsXMLSpine().getHeaderQNames();
                }
            }
            return null;
        }
        catch (SOAPException se) {
            throw ExceptionFactory.makeWebServiceException(se);
        }
    }

    @Override
    public List<Block> getHeaderBlocks(String namespace, String localPart, Object context, BlockFactory blockFactory, RolePlayer rolePlayer) throws WebServiceException {
        List<Block> blocks = this.getContentAsXMLSpine().getHeaderBlocks(namespace, localPart, context, blockFactory, rolePlayer);
        for (Block block : blocks) {
            if (block == null) continue;
            block.setParent(this.getParent());
        }
        return blocks;
    }

    @Override
    public int getNumBodyBlocks() throws WebServiceException {
        return this.getContentAsXMLSpine().getNumBodyBlocks();
    }

    @Override
    public List<QName> getBodyBlockQNames() throws WebServiceException {
        return this.getContentAsXMLSpine().getBodyBlockQNames();
    }

    @Override
    public int getNumHeaderBlocks() throws WebServiceException {
        return this.getContentAsXMLSpine().getNumHeaderBlocks();
    }

    @Override
    public void removeBodyBlock(int index) throws WebServiceException {
        this.getContentAsXMLSpine().removeBodyBlock(index);
    }

    @Override
    public void removeHeaderBlock(String namespace, String localPart) throws WebServiceException {
        this.getContentAsXMLSpine().removeHeaderBlock(namespace, localPart);
    }

    @Override
    public void setBodyBlock(int index, Block block) throws WebServiceException {
        block.setParent(this.getParent());
        this.getContentAsXMLSpine().setBodyBlock(index, block);
    }

    @Override
    public void setBodyBlock(Block block) throws WebServiceException {
        block.setParent(this.getParent());
        this.getContentAsXMLSpine().setBodyBlock(block);
    }

    @Override
    public void setHeaderBlock(String namespace, String localPart, Block block) throws WebServiceException {
        block.setParent(this.getParent());
        this.getContentAsXMLSpine().setHeaderBlock(namespace, localPart, block);
    }

    @Override
    public void appendHeaderBlock(String namespace, String localPart, Block block) throws WebServiceException {
        block.setParent(this.getParent());
        this.getContentAsXMLSpine().appendHeaderBlock(namespace, localPart, block);
    }

    @Override
    public Message getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Message p) {
        this.parent = (MessageImpl)p;
    }

    protected abstract OMElement _convertSE2OM(SOAPEnvelope var1) throws WebServiceException;

    protected abstract OMElement _convertSpine2OM(XMLSpine var1) throws WebServiceException;

    protected abstract SOAPEnvelope _convertOM2SE(OMElement var1) throws WebServiceException;

    protected abstract SOAPEnvelope _convertSpine2SE(XMLSpine var1) throws WebServiceException;

    protected abstract XMLSpine _convertOM2Spine(OMElement var1) throws WebServiceException;

    protected abstract XMLSpine _convertSE2Spine(SOAPEnvelope var1) throws WebServiceException;

    protected static XMLSpine _createSpine(Protocol protocol, SOAPBinding.Style style, int indirection, OMElement payload) throws WebServiceException {
        return new XMLSpineImpl(protocol, style, indirection, payload);
    }

    private void setConsumed(boolean consume) {
        if (consume) {
            this.consumed = true;
            if (log.isDebugEnabled()) {
                log.debug("Debug Monitoring When Block is Consumed");
                log.trace(JavaUtils.stackToString());
            }
        } else {
            this.consumed = false;
        }
    }

    @Override
    public void close() {
        OMXMLParserWrapper builder;
        OMElement om = this.getContentAsOMElement();
        if (om != null && (builder = om.getBuilder()) instanceof StAXBuilder) {
            StAXBuilder staxBuilder = (StAXBuilder)builder;
            staxBuilder.releaseParserOnClose(true);
            if (!staxBuilder.isClosed()) {
                staxBuilder.close();
            }
        }
    }
}

