/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util;

import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Reader2Writer {
    private XMLStreamReader reader;
    private boolean closeReader = true;
    private static final Log log = LogFactory.getLog(Reader2Writer.class);

    public Reader2Writer(XMLStreamReader reader) {
        this.reader = reader;
    }

    public Reader2Writer(XMLStreamReader reader, boolean closeReader) {
        this(reader);
        this.closeReader = closeReader;
    }

    public void outputTo(XMLStreamWriter writer) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(this.reader);
        OMDocument omDocument = builder.getDocument();
        Iterator it = omDocument.getChildren();
        while (it.hasNext()) {
            OMNode omNode = (OMNode)it.next();
            omNode.serializeAndConsume(writer);
        }
        if (this.closeReader) {
            if (log.isDebugEnabled()) {
                log.debug("closing reader, builder: " + JavaUtils.stackToString());
            }
            this.reader.close();
        }
    }

    public String getAsString() throws XMLStreamException {
        StringWriter sw = new StringWriter();
        XMLStreamWriter writer = StAXUtils.createXMLStreamWriter(sw);
        this.outputTo(writer);
        writer.flush();
        sw.flush();
        String str = sw.toString();
        writer.close();
        return str;
    }
}

