/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import java.security.PrivilegedAction;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.registry.InvocationListenerRegistry;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointController;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSMessageReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(JAXWSMessageReceiver.class);
    private static String PARAM_SERVICE_CLASS = "ServiceClass";
    public static String PARAM_BINDING = "Binding";

    public void receive(MessageContext axisRequestMsgCtx) throws AxisFault {
        AxisFault faultToReturn = null;
        if (log.isDebugEnabled()) {
            log.debug("new request received");
        }
        AxisService service = axisRequestMsgCtx.getAxisService();
        this.setContextClassLoader(service.getClassLoader());
        Parameter svcClassParam = service.getParameter(PARAM_SERVICE_CLASS);
        if (svcClassParam == null) {
            throw new RuntimeException(Messages.getMessage("JAXWSMessageReceiverNoServiceClass"));
        }
        Parameter endpointDescParam = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        if (endpointDescParam == null) {
            throw new RuntimeException(Messages.getMessage("JAXWSMessageReceiverNoServiceClass"));
        }
        AxisOperation operation = axisRequestMsgCtx.getAxisOperation();
        String mep = operation.getMessageExchangePattern();
        if (log.isDebugEnabled()) {
            log.debug("MEP: " + mep);
        }
        try {
            ThreadContextMigratorUtil.performMigrationToThread("JAXWS-ThreadContextMigrator-List", axisRequestMsgCtx);
            EndpointController endpointCtlr = new EndpointController();
            org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = new org.apache.axis2.jaxws.core.MessageContext(axisRequestMsgCtx);
            requestMsgCtx.setServer(true);
            requestMsgCtx.setMEPContext(new MEPContext(requestMsgCtx));
            ClassLoader loader = this.getCachedClassLoader(axisRequestMsgCtx);
            if (loader != null) {
                requestMsgCtx.setProperty("CACHE_CLASSLOADER", loader);
            }
            AttachmentsAdapter.install(requestMsgCtx);
            TransportHeadersAdapter.install(requestMsgCtx);
            SOAPHeadersAdapter.install(requestMsgCtx);
            Binding binding = (Binding)axisRequestMsgCtx.getProperty(PARAM_BINDING);
            EndpointInvocationContext eic = InvocationContextFactory.createEndpointInvocationContext(binding);
            this.addInvocationListenerFactories(eic);
            eic.setRequestMessageContext(requestMsgCtx);
            eic.getRequestMessageContext().setProperty("serverDisableThreadSwitch", true);
            if (this.isMepInOnly(mep)) {
                if (log.isDebugEnabled()) {
                    log.debug("Detected a one way invocation.");
                }
                eic.setIsOneWay(true);
                endpointCtlr.invokeOneWay(eic);
            } else if (JavaUtils.isTrueExplicitly(axisRequestMsgCtx.getProperty("IsAddressingProcessed")) && axisRequestMsgCtx.getReplyTo() != null && !axisRequestMsgCtx.getReplyTo().hasAnonymousAddress()) {
                if (log.isDebugEnabled()) {
                    log.debug("Detected an async invocation.");
                }
                EndpointCallback ecb = new EndpointCallback();
                eic.setCallback(ecb);
                endpointCtlr.invokeAsync(eic);
            } else {
                org.apache.axis2.jaxws.core.MessageContext responseMsgCtx;
                if (log.isDebugEnabled()) {
                    log.debug("Detected a sync invocation.");
                }
                if ((responseMsgCtx = (eic = endpointCtlr.invoke(eic)).getResponseMessageContext()) == null && MessageContextUtils.getJaxwsProviderInterpretNullOneway(requestMsgCtx)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Detected a null return from a Provider, sending back an ack instead of a response.");
                    }
                    this.sendAckBack(axisRequestMsgCtx);
                } else {
                    MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
                    if (loader != null) {
                        responseMsgCtx.setProperty("CACHE_CLASSLOADER", loader);
                    }
                    MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
                    OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
                    opCtx.addMessageContext(axisResponseMsgCtx);
                    if (responseMsgCtx.getMessage().isFault()) {
                        if (responseMsgCtx.getCausedByException() != null) {
                            faultToReturn = responseMsgCtx.getCausedByException();
                            if (log.isDebugEnabled()) {
                                log.debug("Setting causedByException from response MessageContext");
                            }
                        } else if (requestMsgCtx.getCausedByException() != null) {
                            faultToReturn = requestMsgCtx.getCausedByException();
                            if (log.isDebugEnabled()) {
                                log.debug("Setting causedByException from request MessageContext..which indicates an exception occured in the inbound handler processing");
                            }
                        } else {
                            faultToReturn = new AxisFault("An error was detected during JAXWS processing", axisResponseMsgCtx);
                            if (log.isDebugEnabled()) {
                                log.debug("No causedByException detected");
                            }
                        }
                    } else {
                        ThreadContextMigratorUtil.performMigrationToContext("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
                        AxisEngine.send(axisResponseMsgCtx);
                        ThreadContextMigratorUtil.performContextCleanup("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
                    }
                }
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception e) {
            ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", axisRequestMsgCtx);
            WebServiceException wse = ExceptionFactory.makeWebServiceException(e);
            throw AxisFault.makeFault(wse);
        }
        ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", axisRequestMsgCtx);
        if (faultToReturn != null) {
            throw faultToReturn;
        }
    }

    private void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private void sendAckBack(MessageContext axisMsgCtx) {
        block5: {
            if (log.isDebugEnabled()) {
                log.debug("sendAckBack entry");
            }
            try {
                Object requestResponseTransport = axisMsgCtx.getProperty("RequestResponseTransportControl");
                if (requestResponseTransport != null) {
                    ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(axisMsgCtx);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Ignoring exception from acknowledgeMessage.", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("sendAckBack exit");
        }
    }

    private boolean isMepInOnly(String mep) {
        boolean inOnly = mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only");
        return inOnly;
    }

    void addInvocationListenerFactories(EndpointInvocationContext eic) {
        eic.setInvocationListenerFactories(InvocationListenerRegistry.getFactories());
    }

    public ClassLoader getCachedClassLoader(MessageContext msgContext) {
        return (ClassLoader)msgContext.getAxisService().getParameterValue("CACHE_CLASSLOADER");
    }
}

