/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.common.config.WSDLValidatorElement;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLExtensionUtils {
    private static final Log log = LogFactory.getLog(WSDLExtensionUtils.class);

    public static void search(WSDLElement element, Set<WSDLValidatorElement> set, List<QName> unusedExtensions) {
        if (log.isDebugEnabled()) {
            log.debug("Start Searching for WSDLExtensions");
        }
        if (element == null) {
            return;
        }
        LinkedList<WSDLElement> queue = new LinkedList<WSDLElement>();
        queue.offer(element);
        while (!queue.isEmpty()) {
            WSDLElement wsdlElement = (WSDLElement)queue.remove();
            WSDLExtensionUtils.processWSDLElement(wsdlElement, set, unusedExtensions);
            if (wsdlElement instanceof Binding) {
                List operations = ((Binding)wsdlElement).getBindingOperations();
                for (BindingOperation op : operations) {
                    queue.offer(op);
                }
            }
            if (!(wsdlElement instanceof BindingOperation)) continue;
            BindingInput bi = ((BindingOperation)wsdlElement).getBindingInput();
            queue.offer(bi);
            BindingOutput bo = ((BindingOperation)wsdlElement).getBindingOutput();
            queue.offer(bo);
            Map map = ((BindingOperation)wsdlElement).getBindingFaults();
            Collection c = map.values();
            for (Object o : c) {
                if (!(o instanceof BindingFault)) continue;
                BindingFault bf = (BindingFault)o;
                queue.offer(bf);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End Searching for WSDLExtensions");
        }
    }

    private static void processWSDLElement(WSDLElement wsdlElement, Set<WSDLValidatorElement> set, List<QName> unusedExtensions) {
        List list;
        if (log.isDebugEnabled()) {
            log.debug("Start processWSDLElement");
        }
        if ((list = wsdlElement.getExtensibilityElements()) == null || list.size() == 0) {
            return;
        }
        for (ExtensibilityElement e : list) {
            boolean wsdl_attribute;
            if (e instanceof SOAPBinding || e instanceof SOAP12Binding || !(e instanceof UnknownExtensibilityElement)) continue;
            UnknownExtensibilityElement ue = (UnknownExtensibilityElement)e;
            String reqd = ue.getElement().getAttribute("required");
            boolean wsdl_required = e.getRequired() != null && e.getRequired() != false;
            boolean bl = wsdl_attribute = reqd != null && reqd.equalsIgnoreCase("true");
            if (wsdl_attribute || wsdl_required) {
                if (log.isDebugEnabled()) {
                    log.debug("Found a required element: " + e.getElementType());
                }
                WSDLValidatorElement element = new WSDLValidatorElement();
                element.setExtensionElement(e);
                element.setState(WSDLValidatorElement.State.NOT_RECOGNIZED);
                set.add(element);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found a NOT required element: " + e.getElementType());
            }
            unusedExtensions.add(e.getElementType());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit processWSDLElement");
        }
    }

    public static void processExtensions(EndpointDescription endpointDescription) {
        if (endpointDescription == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("RespectBindingConfiguratorErr1"));
        }
        EndpointDescriptionWSDL edw = (EndpointDescriptionWSDL)((Object)endpointDescription);
        if (endpointDescription == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("RespectBindingConfiguratorErr2"));
        }
        Binding wsdlBinding = edw.getWSDLBinding();
        Set<WSDLValidatorElement> set = endpointDescription.getRequiredBindings();
        if (set.size() > 0) {
            return;
        }
        ArrayList<QName> unusedExtensions = new ArrayList<QName>();
        WSDLExtensionUtils.search(wsdlBinding, set, unusedExtensions);
        if (log.isDebugEnabled()) {
            log.debug("The following extensibility elements were found, but were not required.");
            for (int n = 0; n < unusedExtensions.size(); ++n) {
                log.debug("[" + (n + 1) + "] - " + unusedExtensions.get(n));
            }
        }
    }
}

