/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.wsdl.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.jaxws.wsdl.SchemaReader;
import org.apache.axis2.jaxws.wsdl.SchemaReaderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaReaderImpl
implements SchemaReader {
    private static String JAXB_SCHEMA_BINDING = "schemaBindings";
    private static String JAXB_SCHEMA_BINDING_PACKAGE = "package";
    private static String JAXB_SCHEMA_Binding_PACKAGENAME = "name";
    private static String SCHEMA_TARGETNAMESPACE = "targetNamespace";
    private Definition wsdlDefinition = null;
    private static Log log = LogFactory.getLog(SchemaReaderImpl.class);
    private static List<String> ignoreSchema = null;

    @Override
    public Set<String> readPackagesFromSchema(Definition wsdlDefinition) throws SchemaReaderException {
        Types types;
        if (wsdlDefinition == null) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid wsdl definition provided, NULL");
            }
            throw new SchemaReaderException(Messages.getMessage("SchemaReaderErr1"));
        }
        this.wsdlDefinition = wsdlDefinition;
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        TreeSet<String> packageList = new TreeSet<String>();
        String namespace = wsdlDefinition.getTargetNamespace();
        List packages = JavaUtils.getPackagesFromNamespace(namespace);
        if (packages != null && packages.size() > 0) {
            packageList.addAll(packages);
        }
        if ((types = wsdlDefinition.getTypes()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("WARNING: Could not find any Schema/Types from WSDL");
                log.debug("no packages will derived from WSDL schema");
            }
            return packageList;
        }
        List extensibilityElements = types.getExtensibilityElements();
        for (Object obj : extensibilityElements) {
            if (obj == null || !this.isSchema((ExtensibilityElement)obj)) continue;
            Schema schema = (Schema)obj;
            this.processSchema(schema, schemaList, packageList);
        }
        return packageList;
    }

    private void processSchema(Schema schema, List<Schema> schemaList, Set<String> packageList) throws SchemaReaderException {
        if (schemaList.contains(schema)) {
            return;
        }
        ArrayList<SchemaImport> importList = new ArrayList<SchemaImport>();
        String packageString = this.readSchemaBindingPackageName(schema);
        List packages = null;
        if (packageString == null) {
            String namespace = this.readSchemaTargetnamespace(schema);
            if (ignoreSchema.contains(namespace)) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring targetnamespace " + namespace);
                }
                schemaList.add(schema);
                return;
            }
            if (namespace != null) {
                packages = JavaUtils.getPackagesFromNamespace(namespace);
            }
        }
        Map map = schema.getImports();
        Collection collection = map.values();
        for (Vector value : collection) {
            for (Object vectorObj : value) {
                SchemaImport si = (SchemaImport)vectorObj;
                importList.add(si);
                if (!log.isDebugEnabled() || si == null) continue;
                log.debug("Reading import for SchemaLocation =" + si.getSchemaLocationURI());
            }
        }
        schemaList.add(schema);
        if (packageString != null) {
            packageList.add(packageString);
        }
        if (packages != null && packages.size() > 0) {
            packageList.addAll(packages);
        }
        for (SchemaImport si : importList) {
            this.processImport(si, schemaList, packageList);
        }
    }

    private void processImport(SchemaImport si, List<Schema> schemaList, Set<String> packageList) throws SchemaReaderException {
        Schema refSchema = si.getReferencedSchema();
        if (refSchema != null) {
            this.processSchema(refSchema, schemaList, packageList);
        }
    }

    private String readSchemaTargetnamespace(Schema schema) {
        NamedNodeMap nodeMap;
        Node attributeNode;
        Element root = schema.getElement();
        if (root != null && (attributeNode = (nodeMap = root.getAttributes()).getNamedItem(SCHEMA_TARGETNAMESPACE)) != null) {
            return attributeNode.getNodeValue();
        }
        return null;
    }

    private String readSchemaBindingPackageName(Schema schema) {
        Element root = schema.getElement();
        if (root.hasChildNodes()) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode = list.item(i);
                if (!this.isElementName(JAXB_SCHEMA_BINDING, childNode)) continue;
                NodeList schemaBindingNodeList = childNode.getChildNodes();
                for (int j = 0; j < schemaBindingNodeList.getLength(); ++j) {
                    Node schemaBindingNode = schemaBindingNodeList.item(j);
                    if (!this.isElementName(JAXB_SCHEMA_BINDING_PACKAGE, schemaBindingNode)) continue;
                    NamedNodeMap nodeMap = schemaBindingNode.getAttributes();
                    Node attributeNode = nodeMap.getNamedItem(JAXB_SCHEMA_Binding_PACKAGENAME);
                    return attributeNode.getNodeValue();
                }
            }
        }
        return null;
    }

    private boolean isElementName(String name, Node domNode) {
        if (domNode == null) {
            return false;
        }
        if (domNode.getNodeType() == 1) {
            String localName = domNode.getLocalName();
            return localName != null && localName.equals(name);
        }
        return false;
    }

    private boolean isSchema(ExtensibilityElement exElement) {
        return WSDLWrapper.SCHEMA.equals(exElement.getElementType());
    }

    static {
        ignoreSchema = new ArrayList<String>();
        ignoreSchema.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ignoreSchema.add("http://www.w3.org/2005/08/addressing");
    }
}

