/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.w3c.dom.Element;

public class MessageFactoryImpl
extends MessageFactory {
    protected String soapVersion = "SOAP 1.1 Protocol";
    private boolean processMTOM;

    public SOAPMessage createMessage() throws SOAPException {
        SOAPEnvelope soapEnvelope;
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory("dom");
        if (this.soapVersion.equals("SOAP 1.2 Protocol")) {
            soapEnvelope = metaFactory.getSOAP12Factory().getDefaultEnvelope();
        } else {
            if (this.soapVersion.equals("Dynamic Protocol")) {
                throw new UnsupportedOperationException("createMessage() is not supported for DYNAMIC_SOAP_PROTOCOL");
            }
            soapEnvelope = metaFactory.getSOAP11Factory().getDefaultEnvelope();
        }
        Element domSoapEnvelope = (Element)((Object)soapEnvelope);
        domSoapEnvelope.getOwnerDocument().appendChild(domSoapEnvelope);
        SOAPMessageImpl soapMessage = new SOAPMessageImpl(new SOAPEnvelopeImpl(soapEnvelope));
        soapMessage.setSaveRequired();
        return soapMessage;
    }

    public SOAPMessage createMessage(MimeHeaders mimeheaders, InputStream inputstream) throws IOException, SOAPException {
        SOAPMessageImpl soapMessage = new SOAPMessageImpl(inputstream, mimeheaders, this.processMTOM);
        soapMessage.setSaveRequired();
        return soapMessage;
    }

    public void setSOAPVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public void setProcessMTOM(boolean processMTOM) {
        this.processMTOM = processMTOM;
    }
}

