/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFaultElement;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Constants;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.saaj.DetailImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.SOAPBodyElementImpl;
import org.apache.axis2.saaj.SOAPFaultElementImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPFaultImpl
extends SOAPBodyElementImpl<SOAPFault>
implements javax.xml.soap.SOAPFault {
    private boolean isDetailAdded;
    private Locale faultReasonLocale;
    private boolean defaultsSet;

    public SOAPFaultImpl(SOAPFault fault) {
        super(fault);
    }

    void setDefaults() throws SOAPException {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            this.setFaultCode(SOAP11Constants.QNAME_SENDER_FAULTCODE);
        } else {
            this.setFaultCode(SOAP12Constants.QNAME_SENDER_FAULTCODE);
        }
        this.setFaultString("Fault string, and possibly fault code, not set");
        this.defaultsSet = true;
    }

    void removeDefaults() {
        if (this.defaultsSet) {
            SOAPFaultReason reason = ((SOAPFault)this.omTarget).getReason();
            if (reason != null) {
                reason.detach();
            }
            this.defaultsSet = false;
        }
    }

    @Override
    public void setFaultCode(String faultCode) throws SOAPException {
        SOAPFactory soapFactory = null;
        SOAPFaultCode soapFaultCode = null;
        if (faultCode.indexOf(":") == -1) {
            throw new SOAPException("faultCode must be of the form prefix:localName");
        }
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
            soapFaultCode = soapFactory.createSOAPFaultCode((SOAPFault)this.omTarget);
            soapFaultCode.setText(faultCode);
        } else if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
            soapFaultCode = soapFactory.createSOAPFaultCode((SOAPFault)this.omTarget);
            SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
            soapFaultCode.setValue(soapFaultValue);
            soapFaultValue.setText(faultCode);
        }
        ((SOAPFault)this.omTarget).setCode(soapFaultCode);
    }

    @Override
    public String getFaultCode() {
        if (this.omTarget != null && ((SOAPFault)this.omTarget).getCode() != null) {
            if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
                return ((SOAPFault)this.omTarget).getCode().getText();
            }
            if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
                return ((SOAPFault)this.omTarget).getCode().getValue().getText();
            }
            return null;
        }
        return null;
    }

    @Override
    public void setFaultActor(String faultActor) throws SOAPException {
        if (((SOAPFault)this.omTarget).getRole() == null) {
            SOAPFaultRole faultRoleImpl = ((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).createSOAPFaultRole((SOAPFault)this.omTarget);
            faultRoleImpl.setRoleValue(faultActor);
            ((SOAPFault)this.omTarget).setRole(faultRoleImpl);
        } else {
            SOAPFaultRole role = ((SOAPFault)this.omTarget).getRole();
            role.setRoleValue(faultActor);
        }
    }

    @Override
    public String getFaultActor() {
        if (((SOAPFault)this.omTarget).getRole() != null) {
            return ((SOAPFault)this.omTarget).getRole().getRoleValue();
        }
        return null;
    }

    @Override
    public void setFaultString(String faultString) throws SOAPException {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            this.setFaultString(faultString, null);
        } else if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            this.setFaultString(faultString, Locale.getDefault());
        }
    }

    @Override
    public String getFaultString() {
        if (((SOAPFault)this.omTarget).getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return ((SOAPFault)this.omTarget).getReason().getText();
        }
        if (((SOAPFault)this.omTarget).getReason() != null && ((SOAPFault)this.omTarget).getReason().getFirstSOAPText() != null) {
            return ((SOAPFault)this.omTarget).getReason().getFirstSOAPText().getText();
        }
        return null;
    }

    @Override
    public Detail getDetail() {
        return (Detail)this.toSAAJNode((Node)((Object)((SOAPFault)this.omTarget).getDetail()));
    }

    @Override
    public void setFaultCode(Name faultCodeName) throws SOAPException {
        if (faultCodeName.getURI() == null || faultCodeName.getURI().trim().length() == 0) {
            throw new SOAPException("faultCodeQName must be namespace qualified.");
        }
        QName faultCodeQName = new QName(faultCodeName.getURI(), faultCodeName.getLocalName(), faultCodeName.getPrefix());
        this.setFaultCode(faultCodeQName);
    }

    @Override
    public Detail addDetail() throws SOAPException {
        if (this.isDetailAdded) {
            throw new SOAPException("This SOAPFault already contains a Detail element. Please remove the existing Detail element before calling addDetail()");
        }
        SOAPFactory factory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
        SOAPFaultDetail omDetail = factory.createSOAPFaultDetail((SOAPFault)this.omTarget);
        DetailImpl saajDetail = new DetailImpl(omDetail);
        this.isDetailAdded = true;
        return saajDetail;
    }

    @Override
    public Name getFaultCodeAsName() {
        return new PrefixedQName(this.getFaultCodeAsQName());
    }

    @Override
    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        if (((SOAPFault)this.omTarget).getReason() != null) {
            SOAPFaultReason reason = ((SOAPFault)this.omTarget).getReason();
            if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
                reason.setText(faultString);
            } else if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
                this.addFaultReasonText(faultString, locale);
            }
        } else if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            SOAPFaultReason reason = ((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).createSOAPFaultReason((SOAPFault)this.omTarget);
            reason.setText(faultString);
        } else if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            this.addFaultReasonText(faultString, locale);
        }
        this.faultReasonLocale = locale;
    }

    @Override
    public Locale getFaultStringLocale() {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            return this.faultReasonLocale;
        }
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            Locale locale = null;
            try {
                if (this.getFaultReasonLocales().hasNext()) {
                    locale = (Locale)this.getFaultReasonLocales().next();
                }
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            return locale;
        }
        return null;
    }

    @Override
    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        if (locale == null) {
            throw new SOAPException("Received null for locale");
        }
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("Not supported in SOAP 1.1");
        }
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            this.removeDefaults();
            String existingReasonText = this.getFaultReasonText(locale);
            if (existingReasonText == null) {
                SOAPFactory soapFactory = null;
                soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
                if (((SOAPFault)this.omTarget).getReason() == null) {
                    SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason((SOAPFault)this.omTarget);
                    ((SOAPFault)this.omTarget).setReason(soapFaultReason);
                }
                SOAPFaultText soapFaultText = soapFactory.createSOAPFaultText(((SOAPFault)this.omTarget).getReason());
                soapFaultText.setText(text);
                soapFaultText.setLang(locale.toString());
            } else {
                for (SOAPFaultText soapFaultText : ((SOAPFault)this.omTarget).getReason().getAllSoapTexts()) {
                    if (!soapFaultText.getLang().equals(locale.toString())) continue;
                    soapFaultText.setText(text);
                }
            }
        }
    }

    @Override
    public void appendFaultSubcode(QName subcode) throws SOAPException {
        SOAPFactory soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
        SOAPFaultSubCode soapFaultSubCode = null;
        if (subcode.getNamespaceURI() == null || subcode.getNamespaceURI().trim().length() == 0) {
            throw new SOAPException("Unqualified QName object : " + subcode);
        }
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException();
        }
        if (((SOAPFault)this.omTarget).getCode() == null) {
            soapFactory.createSOAPFaultCode((SOAPFault)this.omTarget);
            soapFaultSubCode = soapFactory.createSOAPFaultSubCode(((SOAPFault)this.omTarget).getCode());
        } else {
            soapFaultSubCode = ((SOAPFault)this.omTarget).getCode().getSubCode() != null ? soapFactory.createSOAPFaultSubCode(this.getLastSubCode(((SOAPFault)this.omTarget).getCode().getSubCode())) : soapFactory.createSOAPFaultSubCode(((SOAPFault)this.omTarget).getCode());
        }
        if (soapFaultSubCode != null) {
            SOAPFaultValue soapFaultValueimpl = soapFactory.createSOAPFaultValue(soapFaultSubCode);
            soapFaultValueimpl.setText(subcode.getPrefix() + ":" + subcode.getLocalPart());
            soapFaultValueimpl.declareNamespace(subcode.getNamespaceURI(), subcode.getPrefix());
        }
    }

    private SOAPFaultSubCode getLastSubCode(SOAPFaultSubCode firstSubCodeElement) {
        SOAPFaultSubCode soapFaultSubCode = firstSubCodeElement.getSubCode();
        if (soapFaultSubCode != null) {
            return this.getLastSubCode(soapFaultSubCode);
        }
        return firstSubCodeElement;
    }

    @Override
    public QName getFaultCodeAsQName() {
        SOAPFaultCode soapFaultCode = ((SOAPFault)this.omTarget).getCode();
        return soapFaultCode != null ? soapFaultCode.getValueAsQName() : null;
    }

    @Override
    public String getFaultNode() {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Node");
        }
        if (this.omTarget != null && ((SOAPFault)this.omTarget).getNode() != null && ((SOAPFault)this.omTarget).getNode().getText() != null) {
            return ((SOAPFault)this.omTarget).getNode().getText();
        }
        return null;
    }

    @Override
    public Iterator getFaultReasonLocales() throws SOAPException {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Reason");
        }
        ArrayList<Locale> faultReasonLocales = new ArrayList<Locale>();
        List soapTextList = ((SOAPFault)this.omTarget).getReason().getAllSoapTexts();
        if (soapTextList != null) {
            for (SOAPFaultText soapFaultText : soapTextList) {
                String lang = soapFaultText.getLang();
                if (lang == null) {
                    faultReasonLocales.add(Locale.getDefault());
                    continue;
                }
                if (lang.indexOf("_") != -1) {
                    String language = lang.substring(0, lang.indexOf("_"));
                    String country = lang.substring(lang.indexOf("_") + 1);
                    faultReasonLocales.add(new Locale(language, country));
                    continue;
                }
                faultReasonLocales.add(new Locale(lang));
            }
        }
        return faultReasonLocales.iterator();
    }

    @Override
    public String getFaultReasonText(Locale locale) throws SOAPException {
        List soapTexts;
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Reason");
        }
        Iterator soapTextsItr = null;
        SOAPFaultReason soapFaultReason = ((SOAPFault)this.omTarget).getReason();
        if (soapFaultReason != null && (soapTexts = soapFaultReason.getAllSoapTexts()) != null) {
            for (SOAPFaultText soapFaultText : soapTexts) {
                if (!soapFaultText.getLang().equals(locale.toString())) continue;
                return soapFaultText.getText();
            }
        }
        return null;
    }

    @Override
    public Iterator getFaultReasonTexts() throws SOAPException {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException();
        }
        Iterator soapTextsItr = ((SOAPFault)this.omTarget).getReason().getAllSoapTexts().iterator();
        ArrayList<String> reasonTexts = new ArrayList<String>();
        while (soapTextsItr.hasNext()) {
            SOAPFaultText soapFaultText = (SOAPFaultText)soapTextsItr.next();
            reasonTexts.add(soapFaultText.getText());
        }
        return reasonTexts.iterator();
    }

    @Override
    public String getFaultRole() {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("Message does not support the SOAP 1.2 concept of Fault Reason");
        }
        if (((SOAPFault)this.omTarget).getRole() != null) {
            return ((SOAPFault)this.omTarget).getRole().getText();
        }
        return null;
    }

    @Override
    public Iterator getFaultSubcodes() {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException();
        }
        ArrayList<QName> faultSubcodes = new ArrayList<QName>();
        for (SOAPFaultSubCode subCodeElement = ((SOAPFault)this.omTarget).getCode().getSubCode(); subCodeElement != null; subCodeElement = subCodeElement.getSubCode()) {
            faultSubcodes.add(subCodeElement.getValueAsQName());
        }
        return faultSubcodes.iterator();
    }

    @Override
    public boolean hasDetail() {
        return ((SOAPFault)this.omTarget).getDetail() != null;
    }

    @Override
    public void removeAllFaultSubcodes() {
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException();
        }
        ((SOAPFault)this.omTarget).getCode().getSubCode().detach();
    }

    @Override
    public void setFaultCode(QName qname2) throws SOAPException {
        if (qname2.getNamespaceURI() == null || qname2.getNamespaceURI().trim().length() == 0) {
            throw new SOAPException("Unqualified QName object : " + qname2);
        }
        SOAPFactory soapFactory = null;
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
        } else if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            if (!qname2.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                throw new SOAPException("Incorrect URI" + qname2.getNamespaceURI());
            }
            soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
        } else {
            throw new SOAPException("Invalid SOAP version");
        }
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode((SOAPFault)this.omTarget);
        String prefix = qname2.getPrefix() != null && !qname2.getPrefix().equals("") ? qname2.getPrefix() : ((SOAPFault)this.omTarget).getQName().getPrefix();
        OMFactory factory = ((SOAPFault)this.omTarget).getOMFactory();
        if (((SOAPFactory)factory).getSOAPVersion() == SOAP11Version.getSingleton()) {
            soapFaultCode.setText(prefix + ":" + qname2.getLocalPart());
            OMNamespace omNamespace = factory.createOMNamespace(qname2.getNamespaceURI(), qname2.getPrefix());
            soapFaultCode.declareNamespace(omNamespace);
        } else if (((SOAPFactory)factory).getSOAPVersion() == SOAP12Version.getSingleton()) {
            SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
            soapFaultValue.setText(prefix + ":" + qname2.getLocalPart());
            OMNamespace omNamespace = factory.createOMNamespace(qname2.getNamespaceURI(), qname2.getPrefix());
            soapFaultValue.declareNamespace(omNamespace);
            soapFaultCode.setValue(soapFaultValue);
        }
        ((SOAPFault)this.omTarget).setCode(soapFaultCode);
    }

    @Override
    public void setFaultNode(String s) throws SOAPException {
        SOAPFactory soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("message does not support the SOAP 1.2 concept of Fault Node");
        }
        SOAPFaultNode soapFaultNode = soapFactory.createSOAPFaultNode((SOAPFault)this.omTarget);
        soapFaultNode.setText(s);
        ((SOAPFault)this.omTarget).setNode(soapFaultNode);
    }

    @Override
    public void setFaultRole(String uri) throws SOAPException {
        SOAPFactory soapFactory = (SOAPFactory)((SOAPFault)this.omTarget).getOMFactory();
        if (((SOAPFactory)((SOAPFault)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException("message does not support the SOAP 1.2 concept of Fault Role");
        }
        SOAPFaultRole soapFaultRole = soapFactory.createSOAPFaultRole((SOAPFault)this.omTarget);
        soapFaultRole.setRoleValue(uri);
        ((SOAPFault)this.omTarget).setRole(soapFaultRole);
    }

    @Override
    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(((SOAPFault)this.omTarget).getChildrenWithName(qName));
    }

    @Override
    public Iterator getChildElements() {
        return this.getChildren(((SOAPFault)this.omTarget).getChildren());
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            Node domNode = (Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (!(saajNode instanceof SOAPFaultElement)) {
                childElements.add(new SOAPFaultElementImpl<OMElement>((OMElement)((Object)domNode)));
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }
}

