/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Iterator;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.MediaType;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.saaj.NodeListImpl;
import org.apache.axis2.saaj.ProxyNode;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.apache.axis2.saaj.TextImplEx;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private static final Log log = LogFactory.getLog(SOAPPartImpl.class);
    private Document document;
    private SOAPMessage soapMessage;
    private SOAPEnvelopeImpl envelope;
    private final MimeHeaders mimeHeaders;

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, SOAPEnvelopeImpl soapEnvelope) {
        this.mimeHeaders = SAAJUtil.copyMimeHeaders(parentSoapMsg.getMimeHeaders());
        this.soapMessage = parentSoapMsg;
        this.envelope = soapEnvelope;
        this.document = soapEnvelope.getOwnerDocument();
        this.envelope.setSOAPPartParent(this);
    }

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, InputStream inputStream, MimeHeaders mimeHeaders, Attachments attachments) throws SOAPException {
        XMLStreamReader streamReader;
        String soapEnvelopeNamespaceURI;
        SOAPFactory soapFactory;
        boolean isMTOM;
        String charset;
        ContentType contentType = null;
        if (mimeHeaders == null) {
            this.mimeHeaders = new MimeHeaders();
            this.mimeHeaders.addHeader("Content-ID", IDGenerator.generateID());
            this.mimeHeaders.addHeader("content-type", "application/soap+xml");
        } else {
            String[] contentTypes = mimeHeaders.getHeader("Content-Type");
            if (contentTypes != null && contentTypes.length > 0) {
                try {
                    contentType = new ContentType(contentTypes[0]);
                }
                catch (ParseException ex) {
                    throw new SOAPException("Invalid content type '" + contentTypes[0] + "'");
                }
            }
            this.mimeHeaders = SAAJUtil.copyMimeHeaders(mimeHeaders);
        }
        this.soapMessage = parentSoapMsg;
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory("dom");
        if (contentType == null) {
            charset = null;
            isMTOM = false;
            soapFactory = metaFactory.getSOAP11Factory();
            soapEnvelopeNamespaceURI = null;
        } else {
            MediaType soapContentType;
            MediaType baseType = contentType.getMediaType();
            if (baseType.equals(MediaType.APPLICATION_XOP_XML)) {
                isMTOM = true;
                String typeParam = contentType.getParameter("type");
                if (typeParam == null) {
                    throw new SOAPException("Missing 'type' parameter in XOP content type");
                }
                try {
                    soapContentType = new ContentType(typeParam).getMediaType();
                }
                catch (ParseException ex) {
                    throw new SOAPException("Failed to parse the 'type' parameter", ex);
                }
            } else {
                isMTOM = false;
                soapContentType = baseType;
            }
            if (soapContentType.equals(MediaType.TEXT_XML)) {
                soapEnvelopeNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
                soapFactory = metaFactory.getSOAP11Factory();
            } else if (soapContentType.equals(MediaType.APPLICATION_SOAP_XML)) {
                soapEnvelopeNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
                soapFactory = metaFactory.getSOAP12Factory();
            } else {
                throw new SOAPException("Unrecognized content type '" + soapContentType + "'");
            }
            charset = contentType.getParameter("charset");
        }
        try {
            streamReader = charset != null ? StAXUtils.createXMLStreamReader(inputStream, charset) : StAXUtils.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            throw new SOAPException(e);
        }
        StAXSOAPModelBuilder builder = isMTOM && attachments != null ? new MTOMStAXSOAPModelBuilder(streamReader, soapFactory, attachments, soapEnvelopeNamespaceURI) : new StAXSOAPModelBuilder(streamReader, soapFactory, soapEnvelopeNamespaceURI);
        try {
            SOAPEnvelope soapEnvelope = builder.getSOAPEnvelope();
            this.envelope = new SOAPEnvelopeImpl(soapEnvelope);
            ((SOAPEnvelope)this.envelope.omTarget).build();
            this.document = this.envelope.getOwnerDocument();
            this.envelope.setSOAPPartParent(this);
        }
        catch (Exception e) {
            throw new SOAPException(e);
        }
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        return this.envelope;
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public void setContent(Source source) throws SOAPException {
        try {
            XMLStreamReader reader;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (source instanceof StreamSource) {
                reader = inputFactory.createXMLStreamReader(source);
            } else {
                StreamResult result = new StreamResult(baos);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.transform(source, result);
                ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                reader = inputFactory.createXMLStreamReader(is);
            }
            StAXSOAPModelBuilder builder1 = new StAXSOAPModelBuilder(reader, (SOAPFactory)((SOAPEnvelope)this.envelope.omTarget).getOMFactory(), null);
            this.envelope = new SOAPEnvelopeImpl(builder1.getSOAPEnvelope());
            ((SOAPEnvelope)this.envelope.omTarget).build();
            this.document = this.envelope.getOwnerDocument();
            this.envelope.setSOAPPartParent(this);
        }
        catch (TransformerFactoryConfigurationError e) {
            log.error(e);
            throw new SOAPException(e);
        }
        catch (Exception e) {
            log.error(e);
            throw new SOAPException(e);
        }
    }

    public Source getContent() throws SOAPException {
        return new DOMSource(this.document);
    }

    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    public String getInputEncoding() {
        return this.envelope.getEncodingStyle();
    }

    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.document.setXmlStandalone(xmlStandalone);
    }

    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.document.setXmlVersion(xmlVersion);
    }

    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.document.setStrictErrorChecking(strictErrorChecking);
    }

    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    public void setDocumentURI(String documentURI) {
        this.document.setDocumentURI(documentURI);
    }

    public Node adoptNode(Node source) throws DOMException {
        return this.document.adoptNode(source);
    }

    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    public void normalizeDocument() {
        this.document.normalizeDocument();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.renameNode(n, namespaceURI, qualifiedName);
    }

    public String getNodeName() {
        return this.document.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    public void setNodeValue(String arg0) throws DOMException {
        this.document.setNodeValue(arg0);
    }

    public short getNodeType() {
        return this.document.getNodeType();
    }

    public Node getParentNode() {
        return this.toSAAJNode(this.document.getParentNode());
    }

    public NodeList getChildNodes() {
        NodeList childNodes = this.document.getChildNodes();
        NodeListImpl nodes = new NodeListImpl();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            nodes.addNode(this.toSAAJNode(childNodes.item(i)));
        }
        return nodes;
    }

    public Node getFirstChild() {
        return this.toSAAJNode(this.document.getFirstChild());
    }

    public Node getLastChild() {
        return this.toSAAJNode(this.document.getLastChild());
    }

    public Node getPreviousSibling() {
        return this.toSAAJNode(this.document.getPreviousSibling());
    }

    public Node getNextSibling() {
        return this.toSAAJNode(this.document.getNextSibling());
    }

    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild instanceof SOAPElementImpl) {
            oldChild = ((SOAPElementImpl)oldChild).getTarget();
        } else if (oldChild instanceof TextImplEx) {
            // empty if block
        }
        return this.document.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    public void normalize() {
        this.document.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    public String getPrefix() {
        return this.document.getPrefix();
    }

    public void setPrefix(String arg0) throws DOMException {
        this.document.setPrefix(arg0);
    }

    public String getLocalName() {
        return this.document.getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    protected void setMessage(SOAPMessageImpl message) {
        this.soapMessage = message;
    }

    public String getBaseURI() {
        return this.document.getBaseURI();
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return this.document.compareDocumentPosition(node);
    }

    public String getTextContent() throws DOMException {
        return this.document.getTextContent();
    }

    public void setTextContent(String textContent) throws DOMException {
        this.document.setTextContent(textContent);
    }

    public boolean isSameNode(Node other) {
        return this.document.isSameNode(other);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.document.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.document.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.document.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(Node node) {
        return this.document.isEqualNode(node);
    }

    public Object getFeature(String feature, String version) {
        return this.document.getFeature(feature, version);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.document.setUserData(key, data, handler);
    }

    public Object getUserData(String key) {
        return this.document.getUserData(key);
    }

    public String getValue() {
        return null;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        throw new SOAPException("Cannot set the parent element of SOAPPart");
    }

    public SOAPElement getParentElement() {
        return null;
    }

    public void detachNode() {
    }

    public void recycleNode() {
    }

    public void setValue(String value) {
        throw new IllegalStateException("Cannot set value of SOAPPart.");
    }

    Node toSAAJNode(Node domNode) {
        return ProxyNode.toSAAJNode(domNode, this);
    }
}

