/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.JavaUtils;

public abstract class AxisRequestEntity {
    private MessageFormatter messageFormatter;
    private boolean chunked = false;
    private MessageContext messageContext;
    private byte[] bytes;
    private boolean isAllowedRetry;
    private OMOutputFormat format;
    private String soapAction;

    public AxisRequestEntity(MessageFormatter messageFormatter, MessageContext msgContext, OMOutputFormat format, String soapAction, boolean chunked, boolean isAllowedRetry) {
        this.messageFormatter = messageFormatter;
        this.messageContext = msgContext;
        this.chunked = chunked;
        this.isAllowedRetry = isAllowedRetry;
        this.format = format;
        this.soapAction = soapAction;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream outStream) throws IOException {
        Object gzip = this.messageContext.getOptions().getProperty("transport.http.gzipRequest");
        if (gzip != null && JavaUtils.isTrueExplicitly(gzip) && this.chunked) {
            outStream = new GZIPOutputStream(outStream);
        }
        try {
            if (this.chunked) {
                this.messageFormatter.writeTo(this.messageContext, this.format, outStream, this.isAllowedRetry);
            } else {
                if (this.bytes == null) {
                    this.bytes = this.messageFormatter.getBytes(this.messageContext, this.format);
                }
                outStream.write(this.bytes);
            }
            if (outStream instanceof GZIPOutputStream) {
                ((GZIPOutputStream)outStream).finish();
            }
            outStream.flush();
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public long getContentLength() {
        if (this.chunked) {
            return -1L;
        }
        if (this.bytes == null) {
            try {
                this.bytes = this.messageFormatter.getBytes(this.messageContext, this.format);
            }
            catch (AxisFault e) {
                return -1L;
            }
        }
        return this.bytes.length;
    }

    public String getContentTypeAsString() {
        return this.messageFormatter.getContentType(this.messageContext, this.format, this.soapAction);
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public InputStream getRequestEntityContent() throws IOException {
        return new ByteArrayInputStream(this.messageFormatter.getBytes(this.messageContext, this.format));
    }
}

