/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.http.HTTPLocationTemplate;
import org.apache.woden.wsdl20.extensions.soap.SOAPFaultCode;
import org.apache.woden.wsdl20.extensions.soap.SOAPFaultSubcodes;

public class WSDL20Util {
    public static void extractWSDL20SoapFaultInfo(Map options, OMElement bindingMessageElement, OMFactory omFactory, OMNamespace wsoap) {
        QName[] faultCodes;
        SOAPFaultSubcodes soapFaultSubcodes;
        SOAPFaultCode faultCode = (SOAPFaultCode)options.get("wsoap:code");
        if (faultCode != null && faultCode.getQName() != null) {
            bindingMessageElement.addAttribute(omFactory.createOMAttribute("code", wsoap, faultCode.getQName().getLocalPart()));
        }
        if ((soapFaultSubcodes = (SOAPFaultSubcodes)options.get("wsoap:subcodes")) != null && (faultCodes = soapFaultSubcodes.getQNames()) != null) {
            for (int i = 0; i < faultCodes.length; ++i) {
                bindingMessageElement.addAttribute(omFactory.createOMAttribute("subcodes", wsoap, faultCodes[0].getLocalPart()));
            }
        }
    }

    public static String applyURITemplating(MessageContext messageContext, String rawURLString, boolean detach) throws AxisFault {
        OMElement firstElement = detach ? messageContext.getEnvelope().getBody().getFirstElement() : messageContext.getEnvelope().getBody().getFirstElement().cloneOMElement();
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = "&";
        }
        HTTPLocation httpLocation = new HTTPLocation(rawURLString);
        HTTPLocationTemplate[] templates = httpLocation.getTemplates();
        for (int i = 0; i < templates.length; ++i) {
            HTTPLocationTemplate template = templates[i];
            String localName = template.getName();
            String elementValue = WSDL20Util.getOMElementValue(localName, firstElement);
            if (template.isEncoded()) {
                try {
                    if (template.isQuery()) {
                        template.setValue(URIEncoderDecoder.quoteIllegal(elementValue, "-._~!$'()*,;=:@/?".replaceAll(queryParameterSeparator, "")));
                        continue;
                    }
                    template.setValue(URIEncoderDecoder.quoteIllegal(elementValue, "-._~!$'()*,;=:@"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new AxisFault("Unable to encode Query String");
                }
            }
            template.setValue(elementValue);
        }
        return httpLocation.getFormattedLocation();
    }

    private static String getOMElementValue(String elementName, OMElement parentElement) {
        OMNode httpURLParam = null;
        Iterator children = parentElement.getChildElements();
        while (children.hasNext()) {
            OMElement child = (OMElement)children.next();
            QName qName = child.getQName();
            if (!elementName.equals(qName.getLocalPart())) continue;
            httpURLParam = child;
            break;
        }
        if (httpURLParam != null) {
            httpURLParam.detach();
            if (parentElement.getFirstOMChild() == null && parentElement.getParent() != null) {
                parentElement.detach();
            }
            return httpURLParam.getText();
        }
        return "";
    }
}

