/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.SerializationStrategy;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.SingleFileSerializationStrategy;
import org.apache.woden.internal.WSDLContext;
import org.apache.woden.internal.wsdl20.BindingImpl;
import org.apache.woden.internal.wsdl20.ComponentModelBuilder;
import org.apache.woden.internal.wsdl20.ImportImpl;
import org.apache.woden.internal.wsdl20.IncludeImpl;
import org.apache.woden.internal.wsdl20.InterfaceImpl;
import org.apache.woden.internal.wsdl20.ServiceImpl;
import org.apache.woden.internal.wsdl20.TypesImpl;
import org.apache.woden.internal.wsdl20.WSDLComponentImpl;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.TypeDefinition;
import org.apache.woden.wsdl20.editable.EdBinding;
import org.apache.woden.wsdl20.editable.EdDescription;
import org.apache.woden.wsdl20.editable.EdInterface;
import org.apache.woden.wsdl20.editable.EdService;
import org.apache.woden.wsdl20.editable.EdTypeDefinition;
import org.apache.woden.wsdl20.fragids.DescriptionPart;
import org.apache.woden.wsdl20.fragids.FragmentIdentifier;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.NestedElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public class DescriptionImpl
extends WSDLComponentImpl
implements Description,
DescriptionElement,
EdDescription {
    private static final String emptyString = "".intern();
    private List fAllElementDeclarations = new Vector();
    private List fAllTypeDefinitions = new Vector();
    private URI fDocumentBaseURI = null;
    private URI fTargetNamespace = null;
    private Map fNamespaces = new HashMap();
    private List fImportElements = new Vector();
    private List fIncludeElements = new Vector();
    private TypesImpl fTypesElement = null;
    private List fInterfaceElements = new Vector();
    private List fBindingElements = new Vector();
    private List fServiceElements = new Vector();
    private boolean fComponentsInitialized = false;
    private WSDLContext fWsdlContext;
    private String serializationStrategy;

    private DescriptionImpl() {
    }

    public DescriptionImpl(WSDLContext wsdlContext) {
        this.fWsdlContext = wsdlContext;
    }

    public Interface[] getInterfaces() {
        Vector<Interface> allInterfaces = new Vector<Interface>();
        for (Interface intface : this.fInterfaceElements) {
            if (this.containsComponent(intface, allInterfaces)) continue;
            ((InterfaceImpl)intface).setDescriptionComponent(this);
            allInterfaces.add(intface);
        }
        Vector nestedDescs = new Vector(this.getNestedDescriptions());
        for (DescriptionElement desc : nestedDescs) {
            InterfaceElement[] interfaces = desc.getInterfaceElements();
            for (int j = 0; j < interfaces.length; ++j) {
                Interface intface = (Interface)((Object)interfaces[j]);
                if (this.containsComponent(intface, allInterfaces)) continue;
                ((InterfaceImpl)intface).setDescriptionComponent(this);
                allInterfaces.add(intface);
            }
        }
        Interface[] array = new Interface[allInterfaces.size()];
        allInterfaces.toArray(array);
        return array;
    }

    public Interface getInterface(QName name) {
        Interface intface = null;
        if (name != null) {
            Interface[] interfaces = this.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!name.equals(interfaces[i].getName())) continue;
                intface = interfaces[i];
                break;
            }
        }
        return intface;
    }

    public Binding[] getBindings() {
        Vector<Binding> allBindings = new Vector<Binding>();
        for (Binding binding : this.fBindingElements) {
            if (this.containsComponent(binding, allBindings)) continue;
            ((BindingImpl)binding).setDescriptionComponent(this);
            allBindings.add(binding);
        }
        Vector nestedDescs = new Vector(this.getNestedDescriptions());
        for (DescriptionElement desc : nestedDescs) {
            BindingElement[] bindings = desc.getBindingElements();
            for (int j = 0; j < bindings.length; ++j) {
                Binding binding = (Binding)((Object)bindings[j]);
                if (this.containsComponent(binding, allBindings)) continue;
                ((BindingImpl)binding).setDescriptionComponent(this);
                allBindings.add(binding);
            }
        }
        Binding[] array = new Binding[allBindings.size()];
        allBindings.toArray(array);
        return array;
    }

    public Binding getBinding(QName name) {
        Binding binding = null;
        if (name != null) {
            Binding[] bindings = this.getBindings();
            for (int i = 0; i < bindings.length; ++i) {
                if (!name.equals(bindings[i].getName())) continue;
                binding = bindings[i];
                break;
            }
        }
        return binding;
    }

    public Service[] getServices() {
        Vector<Service> allServices = new Vector<Service>();
        for (Service service : this.fServiceElements) {
            if (this.containsComponent(service, allServices)) continue;
            ((ServiceImpl)service).setDescriptionComponent(this);
            allServices.add(service);
        }
        Vector nestedDescs = new Vector(this.getNestedDescriptions());
        for (DescriptionElement desc : nestedDescs) {
            ServiceElement[] services = desc.getServiceElements();
            for (int j = 0; j < services.length; ++j) {
                Service service = (Service)((Object)services[j]);
                if (this.containsComponent(service, allServices)) continue;
                ((ServiceImpl)service).setDescriptionComponent(this);
                allServices.add(service);
            }
        }
        Service[] array = new Service[allServices.size()];
        allServices.toArray(array);
        return array;
    }

    public Service getService(QName name) {
        Service service = null;
        if (name != null) {
            Service[] services = this.getServices();
            for (int i = 0; i < services.length; ++i) {
                if (!name.equals(services[i].getName())) continue;
                service = services[i];
                break;
            }
        }
        return service;
    }

    public ElementDeclaration[] getElementDeclarations() {
        if (!this.fComponentsInitialized) {
            this.initComponents();
        }
        ElementDeclaration[] array = new ElementDeclaration[this.fAllElementDeclarations.size()];
        this.fAllElementDeclarations.toArray(array);
        return array;
    }

    public ElementDeclaration getElementDeclaration(QName qname2) {
        if (!this.fComponentsInitialized) {
            this.initComponents();
        }
        ElementDeclaration elDec = null;
        if (qname2 != null) {
            for (ElementDeclaration ed : this.fAllElementDeclarations) {
                if (!qname2.equals(ed.getName())) continue;
                elDec = ed;
                break;
            }
        }
        return elDec;
    }

    public TypeDefinition[] getTypeDefinitions() {
        if (!this.fComponentsInitialized) {
            this.initComponents();
        }
        TypeDefinition[] array = new TypeDefinition[this.fAllTypeDefinitions.size()];
        this.fAllTypeDefinitions.toArray(array);
        return array;
    }

    public TypeDefinition getTypeDefinition(QName qname2) {
        if (!this.fComponentsInitialized) {
            this.initComponents();
        }
        TypeDefinition typeDef = null;
        if (qname2 != null) {
            for (TypeDefinition td : this.fAllTypeDefinitions) {
                if (!qname2.equals(td.getName())) continue;
                typeDef = td;
                break;
            }
        }
        return typeDef;
    }

    public DescriptionElement toElement() {
        return this;
    }

    public void setDocumentBaseURI(URI documentBaseURI) {
        this.fDocumentBaseURI = documentBaseURI;
    }

    public URI getDocumentBaseURI() {
        return this.fDocumentBaseURI;
    }

    public void setTargetNamespace(URI namespace) {
        this.fTargetNamespace = namespace;
    }

    public URI getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public ImportElement[] getImportElements() {
        ImportElement[] array = new ImportElement[this.fImportElements.size()];
        this.fImportElements.toArray(array);
        return array;
    }

    public IncludeElement[] getIncludeElements() {
        IncludeElement[] array = new IncludeElement[this.fIncludeElements.size()];
        this.fIncludeElements.toArray(array);
        return array;
    }

    public TypesElement getTypesElement() {
        return this.fTypesElement;
    }

    public TypesElement addTypesElement() throws WSDLException {
        if (this.fTypesElement == null) {
            this.fTypesElement = new TypesImpl();
            this.fTypesElement.setParentElement(this);
            return this.fTypesElement;
        }
        String msg = this.fWsdlContext.errorReporter.getFormattedMessage("WSDL523", null);
        throw new WSDLException("OTHER_ERROR", msg);
    }

    public InterfaceElement[] getInterfaceElements() {
        InterfaceElement[] array = new InterfaceElement[this.fInterfaceElements.size()];
        this.fInterfaceElements.toArray(array);
        return array;
    }

    public BindingElement[] getBindingElements() {
        BindingElement[] array = new BindingElement[this.fBindingElements.size()];
        this.fBindingElements.toArray(array);
        return array;
    }

    public ServiceElement[] getServiceElements() {
        ServiceElement[] array = new ServiceElement[this.fServiceElements.size()];
        this.fServiceElements.toArray(array);
        return array;
    }

    public ImportElement addImportElement() {
        ImportImpl importEl = new ImportImpl();
        this.fImportElements.add(importEl);
        importEl.setParentElement(this);
        return importEl;
    }

    public IncludeElement addIncludeElement() {
        IncludeImpl include = new IncludeImpl();
        this.fIncludeElements.add(include);
        include.setParentElement(this);
        return include;
    }

    public InterfaceElement addInterfaceElement() {
        InterfaceImpl intface = new InterfaceImpl();
        this.fInterfaceElements.add(intface);
        intface.setParentElement(this);
        return intface;
    }

    public BindingElement addBindingElement() {
        BindingImpl binding = new BindingImpl();
        this.fBindingElements.add(binding);
        binding.setParentElement(this);
        return binding;
    }

    public ServiceElement addServiceElement() {
        ServiceImpl service = new ServiceImpl();
        this.fServiceElements.add(service);
        service.setParentElement(this);
        return service;
    }

    public Description toComponent() {
        if (!this.fComponentsInitialized) {
            this.initComponents();
        }
        return this;
    }

    WSDLContext getWsdlContext() {
        return this.fWsdlContext;
    }

    void addElementDeclaration(ElementDeclaration elDec) {
        if (elDec != null) {
            this.fAllElementDeclarations.add(elDec);
        }
    }

    void addTypeDefinition(TypeDefinition typeDef) {
        if (typeDef != null) {
            this.fAllTypeDefinitions.add(typeDef);
        }
    }

    private void initComponents() {
        this.fComponentsInitialized = true;
        new ComponentModelBuilder(this);
        this.getInterfaces();
        this.getBindings();
        this.getServices();
    }

    void resetComponentsInitialized() {
        this.fComponentsInitialized = false;
    }

    private List getNestedDescriptions() {
        Vector<DescriptionElement> descs = new Vector<DescriptionElement>();
        this.collectIncludedDescriptions(descs, this);
        ImportElement[] imports = this.getImportElements();
        for (int i = 0; i < imports.length; ++i) {
            DescriptionElement desc = imports[i].getDescriptionElement();
            if (desc == null) continue;
            descs.add(desc);
            this.collectIncludedDescriptions(descs, desc);
        }
        return descs;
    }

    private void collectIncludedDescriptions(List descs, DescriptionElement desc) {
        IncludeElement[] includes = desc.getIncludeElements();
        for (int i = 0; i < includes.length; ++i) {
            DescriptionElement includedDesc = includes[i].getDescriptionElement();
            if (includedDesc != null && !descs.contains(includedDesc)) {
                descs.add(includedDesc);
            }
            this.collectIncludedDescriptions(descs, includedDesc);
        }
    }

    public FragmentIdentifier getFragmentIdentifier() {
        return new FragmentIdentifier(new DescriptionPart());
    }

    static String[] getTargetNamespaceAndPrefix(WSDLElement wElem) {
        if (wElem instanceof NestedElement) {
            WSDLElement parent = ((NestedElement)wElem).getParentElement();
            return DescriptionImpl.getTargetNamespaceAndPrefix(parent);
        }
        DescriptionElement desc = (DescriptionElement)wElem;
        String[] namespace = new String[]{emptyString, emptyString};
        URI tns = desc.getTargetNamespace();
        if (tns != null) {
            namespace[0] = tns.toString();
            String prefix = desc.getNamespacePrefix(tns);
            if (prefix != null) {
                namespace[1] = prefix;
            }
        }
        return namespace;
    }

    public EdBinding addBinding() {
        BindingImpl binding = new BindingImpl();
        this.fBindingElements.add(binding);
        binding.setParentElement(this);
        return binding;
    }

    public EdInterface addInterface() {
        InterfaceImpl intface = new InterfaceImpl();
        this.fInterfaceElements.add(intface);
        intface.setParentElement(this);
        return intface;
    }

    public EdService addService() {
        ServiceImpl service = new ServiceImpl();
        this.fServiceElements.add(service);
        service.setParentElement(this);
        return service;
    }

    public void serialize(OutputStream sink) {
        PrintWriter pw = new PrintWriter(sink);
        this.serialize(pw);
    }

    public void serialize(Writer sink) {
        this.findSearalizationStrategy().serializeInternal(this, sink);
    }

    public EdTypeDefinition addTypeDefinition() {
        return null;
    }

    public String getserializationStrategy() {
        return this.serializationStrategy;
    }

    public void setserializationStrategy(String searalizationStrategy) {
        this.serializationStrategy = searalizationStrategy;
    }

    private SerializationStrategy findSearalizationStrategy() {
        SingleFileSerializationStrategy searalizationStrategy = this.getserializationStrategy() == "SingleFileSearalizationStrategy" ? new SingleFileSerializationStrategy(this.fWsdlContext) : new SingleFileSerializationStrategy(this.fWsdlContext);
        return searalizationStrategy;
    }
}

