/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.internal.schema.SchemaImpl;
import org.apache.woden.internal.wsdl20.DescriptionImpl;
import org.apache.woden.internal.wsdl20.DocumentableImpl;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.InlinedSchema;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;

public class TypesImpl
extends DocumentableImpl
implements TypesElement {
    private WSDLElement fParentElem = null;
    private String fTypeSystem = null;
    private List fSchemas = new Vector();

    public void setTypeSystem(String typeSystem) {
        this.fTypeSystem = typeSystem;
    }

    public String getTypeSystem() {
        return this.fTypeSystem;
    }

    public void addSchema(Schema schema) {
        if (schema != null) {
            this.fSchemas.add(schema);
            ((DescriptionImpl)this.getParentElement()).resetComponentsInitialized();
        }
    }

    public void removeSchema(Schema schema) {
        this.fSchemas.remove(schema);
    }

    public Schema[] getSchemas() {
        Schema[] array = new Schema[this.fSchemas.size()];
        this.fSchemas.toArray(array);
        return array;
    }

    public Schema[] getSchemas(URI namespace) {
        Schema s;
        Vector<Schema> schemas = new Vector<Schema>();
        Iterator i = this.fSchemas.iterator();
        if (namespace != null) {
            while (i.hasNext()) {
                s = (Schema)i.next();
                if (!namespace.equals(s.getNamespace())) continue;
                schemas.add(s);
            }
        } else {
            while (i.hasNext()) {
                s = (Schema)i.next();
                if (s.getNamespace() != null) continue;
                schemas.add(s);
            }
        }
        Schema[] array = new Schema[schemas.size()];
        schemas.toArray(array);
        return array;
    }

    public InlinedSchema[] getInlinedSchemas() {
        Vector<Schema> schemas = new Vector<Schema>();
        for (Schema s : this.fSchemas) {
            if (!(s instanceof InlinedSchema)) continue;
            schemas.add(s);
        }
        InlinedSchema[] array = new InlinedSchema[schemas.size()];
        schemas.toArray(array);
        return array;
    }

    public ImportedSchema[] getImportedSchemas() {
        Vector<Schema> schemas = new Vector<Schema>();
        for (Schema s : this.fSchemas) {
            if (!(s instanceof ImportedSchema)) continue;
            schemas.add(s);
        }
        ImportedSchema[] array = new ImportedSchema[schemas.size()];
        schemas.toArray(array);
        return array;
    }

    void setParentElement(WSDLElement parent) {
        this.fParentElem = parent;
    }

    public WSDLElement getParentElement() {
        return this.fParentElem;
    }

    public XmlSchemaElement getElementDeclaration(QName qname2) {
        XmlSchemaElement xmlSchemaElement;
        block2: {
            XmlSchema xmlSchema;
            if (qname2 == null) {
                return null;
            }
            xmlSchemaElement = null;
            List schemas = this.getReferenceableSchemaDefs(qname2.getNamespaceURI());
            if (schemas == null) break block2;
            Iterator i = schemas.iterator();
            while (i.hasNext() && (xmlSchemaElement = (xmlSchema = (XmlSchema)i.next()).getElementByName(qname2)) == null) {
            }
        }
        return xmlSchemaElement;
    }

    public XmlSchemaType getTypeDefinition(QName qname2) {
        XmlSchemaType xmlSchemaType;
        block1: {
            XmlSchema xmlSchema;
            List schemaRefs;
            xmlSchemaType = null;
            if (qname2 == null || (schemaRefs = this.getReferenceableSchemaDefs(qname2.getNamespaceURI())) == null) break block1;
            Iterator i = schemaRefs.iterator();
            while (i.hasNext() && (xmlSchemaType = (xmlSchema = (XmlSchema)i.next()).getTypeByName(qname2)) == null) {
            }
        }
        return xmlSchemaType;
    }

    private List getReferenceableSchemaDefs() {
        Vector<XmlSchema> schemas = new Vector<XmlSchema>();
        for (SchemaImpl s : this.fSchemas) {
            if (!s.isReferenceable() || s.getSchemaDefinition() == null) continue;
            schemas.add(s.getSchemaDefinition());
        }
        return schemas;
    }

    private List getReferenceableSchemaDefs(String namespace) {
        Vector<XmlSchema> schemas = new Vector<XmlSchema>();
        if (namespace != null) {
            for (SchemaImpl s : this.fSchemas) {
                if (!s.isReferenceable() || !namespace.equals(s.getNamespaceAsString()) || s.getSchemaDefinition() == null) continue;
                schemas.add(s.getSchemaDefinition());
            }
        }
        return schemas;
    }
}

