/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.ApplyTemplates;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.AttributeValueTemplate;
import org.apache.xalan.xsltc.compiler.CallTemplate;
import org.apache.xalan.xsltc.compiler.Choose;
import org.apache.xalan.xsltc.compiler.Comment;
import org.apache.xalan.xsltc.compiler.Copy;
import org.apache.xalan.xsltc.compiler.CopyOf;
import org.apache.xalan.xsltc.compiler.ForEach;
import org.apache.xalan.xsltc.compiler.If;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralAttribute;
import org.apache.xalan.xsltc.compiler.Number;
import org.apache.xalan.xsltc.compiler.Otherwise;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.ProcessingInstruction;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SimpleAttributeValue;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Text;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.ValueOf;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.When;
import org.apache.xalan.xsltc.compiler.XslAttribute;
import org.apache.xalan.xsltc.compiler.XslElement;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.ToHTMLStream;

final class LiteralElement
extends Instruction {
    private String _name;
    private LiteralElement _literalElemParent = null;
    private Vector _attributeElements = null;
    private Hashtable _accessedPrefixes = null;
    private boolean _allAttributesUnique = false;
    private static final String XMLNS_STRING = "xmlns";

    LiteralElement() {
    }

    public QName getName() {
        return this._qname;
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("LiteralElement name = " + this._name);
        this.displayContents(indent + 4);
    }

    private String accessedNamespace(String prefix) {
        String result;
        if (this._literalElemParent != null && (result = this._literalElemParent.accessedNamespace(prefix)) != null) {
            return result;
        }
        return this._accessedPrefixes != null ? (String)this._accessedPrefixes.get(prefix) : null;
    }

    public void registerNamespace(String prefix, String uri, SymbolTable stable, boolean declared) {
        String old;
        String parentUri;
        if (this._literalElemParent != null && (parentUri = this._literalElemParent.accessedNamespace(prefix)) != null && parentUri.equals(uri)) {
            return;
        }
        if (this._accessedPrefixes == null) {
            this._accessedPrefixes = new Hashtable();
        } else if (!declared && (old = (String)this._accessedPrefixes.get(prefix)) != null) {
            if (old.equals(uri)) {
                return;
            }
            prefix = stable.generateNamespacePrefix();
        }
        if (!prefix.equals("xml")) {
            this._accessedPrefixes.put(prefix, uri);
        }
    }

    private String translateQName(QName qname2, SymbolTable stable) {
        String uri;
        String localname = qname2.getLocalPart();
        String prefix = qname2.getPrefix();
        if (prefix == null) {
            prefix = "";
        } else if (prefix.equals(XMLNS_STRING)) {
            return XMLNS_STRING;
        }
        String alternative = stable.lookupPrefixAlias(prefix);
        if (alternative != null) {
            stable.excludeNamespaces(prefix);
            prefix = alternative;
        }
        if ((uri = this.lookupNamespace(prefix)) == null) {
            return localname;
        }
        this.registerNamespace(prefix, uri, stable, false);
        if (prefix != "") {
            return prefix + ":" + localname;
        }
        return localname;
    }

    public void addAttribute(SyntaxTreeNode attribute) {
        if (this._attributeElements == null) {
            this._attributeElements = new Vector(2);
        }
        this._attributeElements.add(attribute);
    }

    public void setFirstAttribute(SyntaxTreeNode attribute) {
        if (this._attributeElements == null) {
            this._attributeElements = new Vector(2);
        }
        this._attributeElements.insertElementAt(attribute, 0);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._attributeElements != null) {
            int count = this._attributeElements.size();
            int i = 0;
            while (i < count) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._attributeElements.elementAt(i);
                node.typeCheck(stable);
                ++i;
            }
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public Enumeration getNamespaceScope(SyntaxTreeNode node) {
        Hashtable all = new Hashtable();
        while (node != null) {
            Hashtable mapping = node.getPrefixMapping();
            if (mapping != null) {
                Enumeration prefixes = mapping.keys();
                while (prefixes.hasMoreElements()) {
                    String prefix = (String)prefixes.nextElement();
                    if (all.containsKey(prefix)) continue;
                    all.put(prefix, mapping.get(prefix));
                }
            }
            node = node.getParent();
        }
        return all.keys();
    }

    public void parseContents(Parser parser) {
        SymbolTable stable = parser.getSymbolTable();
        stable.setCurrentNode(this);
        SyntaxTreeNode parent = this.getParent();
        if (parent != null && parent instanceof LiteralElement) {
            this._literalElemParent = (LiteralElement)parent;
        }
        this._name = this.translateQName(this._qname, stable);
        int count = this._attributes.getLength();
        int i = 0;
        while (i < count) {
            QName qname2 = parser.getQName(this._attributes.getQName(i));
            String uri = qname2.getNamespace();
            String val = this._attributes.getValue(i);
            if (qname2 == parser.getUseAttributeSets()) {
                if (!Util.isValidQNames(val)) {
                    ErrorMsg err = new ErrorMsg("INVALID_QNAME_ERR", (Object)val, this);
                    parser.reportError(3, err);
                }
                this.setFirstAttribute(new UseAttributeSets(val, parser));
            } else if (qname2 == parser.getExtensionElementPrefixes()) {
                stable.excludeNamespaces(val);
            } else if (qname2 == parser.getExcludeResultPrefixes()) {
                stable.excludeNamespaces(val);
            } else {
                String prefix = qname2.getPrefix();
                if (!(prefix != null && prefix.equals(XMLNS_STRING) || prefix == null && qname2.getLocalPart().equals(XMLNS_STRING) || uri != null && uri.equals("http://www.w3.org/1999/XSL/Transform"))) {
                    String name = this.translateQName(qname2, stable);
                    LiteralAttribute attr = new LiteralAttribute(name, val, parser, this);
                    this.addAttribute(attr);
                    attr.setParent(this);
                    attr.parseContents(parser);
                }
            }
            ++i;
        }
        Enumeration include = this.getNamespaceScope(this);
        while (include.hasMoreElements()) {
            String uri;
            String prefix = (String)include.nextElement();
            if (prefix.equals("xml") || (uri = this.lookupNamespace(prefix)) == null || stable.isExcludedNamespace(uri)) continue;
            this.registerNamespace(prefix, uri, stable, true);
        }
        this.parseChildren(parser);
        int i2 = 0;
        while (i2 < count) {
            QName qname3 = parser.getQName(this._attributes.getQName(i2));
            String val = this._attributes.getValue(i2);
            if (qname3 == parser.getExtensionElementPrefixes()) {
                stable.unExcludeNamespaces(val);
            } else if (qname3 == parser.getExcludeResultPrefixes()) {
                stable.unExcludeNamespaces(val);
            }
            ++i2;
        }
    }

    protected boolean contextDependent() {
        return this.dependentContents();
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        this._allAttributesUnique = this.checkAttributesUnique();
        il.append(methodGen.loadHandler());
        il.append((CompoundInstruction)new PUSH(cpg, this._name));
        il.append((org.apache.bcel.generic.Instruction)InstructionConstants.DUP2);
        il.append(methodGen.startElement());
        int j = 0;
        while (j < this.elementCount()) {
            SyntaxTreeNode item = (SyntaxTreeNode)this.elementAt(j);
            if (item instanceof Variable) {
                item.translate(classGen, methodGen);
                this.removeElement(item);
                continue;
            }
            ++j;
        }
        if (this._accessedPrefixes != null) {
            boolean declaresDefaultNS = false;
            Enumeration e = this._accessedPrefixes.keys();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                String uri = (String)this._accessedPrefixes.get(prefix);
                if (uri == "" && prefix == "") continue;
                if (prefix == "") {
                    declaresDefaultNS = true;
                }
                il.append(methodGen.loadHandler());
                il.append((CompoundInstruction)new PUSH(cpg, prefix));
                il.append((CompoundInstruction)new PUSH(cpg, uri));
                il.append(methodGen.namespace());
            }
            if (!declaresDefaultNS && this._parent instanceof XslElement && ((XslElement)this._parent).declaresDefaultNS()) {
                il.append(methodGen.loadHandler());
                il.append((CompoundInstruction)new PUSH(cpg, ""));
                il.append((CompoundInstruction)new PUSH(cpg, ""));
                il.append(methodGen.namespace());
            }
        }
        if (this._attributeElements != null) {
            int count = this._attributeElements.size();
            int i = 0;
            while (i < count) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._attributeElements.elementAt(i);
                if (!(node instanceof XslAttribute)) {
                    node.translate(classGen, methodGen);
                }
                ++i;
            }
        }
        this.translateContents(classGen, methodGen);
        il.append(methodGen.endElement());
    }

    private boolean isHTMLOutput() {
        return this.getStylesheet().getOutputMethod() == 2;
    }

    public ElemDesc getElemDesc() {
        if (this.isHTMLOutput()) {
            return ToHTMLStream.getElemDesc(this._name);
        }
        return null;
    }

    public boolean allAttributesUnique() {
        return this._allAttributesUnique;
    }

    private boolean checkAttributesUnique() {
        boolean hasHiddenXslAttribute = this.canProduceAttributeNodes(this, true);
        if (hasHiddenXslAttribute) {
            return false;
        }
        if (this._attributeElements != null) {
            int numAttrs = this._attributeElements.size();
            Hashtable<String, Instruction> attrsTable = null;
            int i = 0;
            while (i < numAttrs) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._attributeElements.elementAt(i);
                if (node instanceof UseAttributeSets) {
                    return false;
                }
                if (node instanceof XslAttribute) {
                    XslAttribute xslAttr;
                    AttributeValue attrName;
                    if (attrsTable == null) {
                        attrsTable = new Hashtable<String, Instruction>();
                        int k = 0;
                        while (k < i) {
                            SyntaxTreeNode n = (SyntaxTreeNode)this._attributeElements.elementAt(k);
                            if (n instanceof LiteralAttribute) {
                                LiteralAttribute literalAttr = (LiteralAttribute)n;
                                attrsTable.put(literalAttr.getName(), literalAttr);
                            }
                            ++k;
                        }
                    }
                    if ((attrName = (xslAttr = (XslAttribute)node).getName()) instanceof AttributeValueTemplate) {
                        return false;
                    }
                    if (attrName instanceof SimpleAttributeValue) {
                        SimpleAttributeValue simpleAttr = (SimpleAttributeValue)attrName;
                        String name = simpleAttr.toString();
                        if (name != null && attrsTable.get(name) != null) {
                            return false;
                        }
                        if (name != null) {
                            attrsTable.put(name, xslAttr);
                        }
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private boolean canProduceAttributeNodes(SyntaxTreeNode node, boolean ignoreXslAttribute) {
        Vector contents = node.getContents();
        int size = contents.size();
        int i = 0;
        while (i < size) {
            SyntaxTreeNode child = (SyntaxTreeNode)contents.elementAt(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                if (!text.isIgnore()) {
                    return false;
                }
            } else {
                if (child instanceof LiteralElement || child instanceof ValueOf || child instanceof XslElement || child instanceof Comment || child instanceof Number || child instanceof ProcessingInstruction) {
                    return false;
                }
                if (child instanceof XslAttribute) {
                    if (!ignoreXslAttribute) {
                        return true;
                    }
                } else {
                    if (child instanceof CallTemplate || child instanceof ApplyTemplates || child instanceof Copy || child instanceof CopyOf) {
                        return true;
                    }
                    if ((child instanceof If || child instanceof ForEach) && this.canProduceAttributeNodes(child, false)) {
                        return true;
                    }
                    if (child instanceof Choose) {
                        Vector chooseContents = child.getContents();
                        int num = chooseContents.size();
                        int k = 0;
                        while (k < num) {
                            SyntaxTreeNode chooseChild = (SyntaxTreeNode)chooseContents.elementAt(k);
                            if ((chooseChild instanceof When || chooseChild instanceof Otherwise) && this.canProduceAttributeNodes(chooseChild, false)) {
                                return true;
                            }
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
        return false;
    }
}

