/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.benchmarking;

import java.util.ArrayList;
import org.hpccsystems.commons.benchmarking.IMetric;
import org.hpccsystems.commons.benchmarking.Units;
import org.json.JSONArray;
import org.json.JSONObject;

public class AveragedMetric
implements IMetric {
    private static final double[] THOMPSON_TAU_TABLE20 = new double[]{0.0, 0.0, 1.1511, 1.425, 1.5712, 1.6563, 1.711, 1.7491, 1.777, 1.7984, 1.8153, 1.829, 1.8403, 1.8498, 1.8579, 1.8649, 1.871, 1.8764, 1.8811, 1.8853};
    private static final int MAX_DATA_POINTS = 20;
    private static final int MIN_DATA_POINTS_FOR_OUTLIERS = 3;
    private ArrayList<Double> dataPoints = new ArrayList();
    private String name = "";
    private Units units = null;
    private String description = null;

    public AveragedMetric(String name) {
        this.name = name;
    }

    public AveragedMetric(String name, Units units) {
        this.name = name;
        this.units = units;
    }

    public AveragedMetric(String name, Units units, String desc) {
        this.name = name;
        this.units = units;
        this.description = desc;
    }

    public AveragedMetric(IMetric metric) {
        this.name = metric.getName();
        this.units = metric.getUnits();
        this.description = metric.getDescription();
        this.addDataPoint(metric.getValue());
    }

    public void addDataPoint(double dataPoint) {
        if (this.dataPoints.size() >= 20) {
            return;
        }
        this.dataPoints.add(dataPoint);
    }

    public void discardOutliers() {
        if (this.dataPoints.size() < 3) {
            return;
        }
        boolean hasOutliers = true;
        do {
            double avg = 0.0;
            for (int i = 0; i < this.dataPoints.size(); ++i) {
                avg += this.dataPoints.get(i).doubleValue();
            }
            avg /= (double)this.dataPoints.size();
            double stdDeviation = 0.0;
            double largestAbsDeviation = 1.4E-45f;
            int largestAbsDeviationIndex = 0;
            for (int i = 0; i < this.dataPoints.size(); ++i) {
                double absoluteDeviation = Math.abs(this.dataPoints.get(i) - avg);
                if (largestAbsDeviation < absoluteDeviation) {
                    largestAbsDeviation = absoluteDeviation;
                    largestAbsDeviationIndex = i;
                }
                stdDeviation += absoluteDeviation * absoluteDeviation;
            }
            stdDeviation /= (double)this.dataPoints.size();
            stdDeviation = Math.sqrt(stdDeviation);
            double tauDeviation = THOMPSON_TAU_TABLE20[this.dataPoints.size() - 1] * stdDeviation;
            if (largestAbsDeviation >= tauDeviation) {
                hasOutliers = true;
                this.dataPoints.remove(largestAbsDeviationIndex);
                continue;
            }
            hasOutliers = false;
        } while (hasOutliers && this.dataPoints.size() > 2);
    }

    public double getMin() {
        if (this.dataPoints.size() == 0) {
            return 0.0;
        }
        double smallestValue = this.dataPoints.get(0);
        for (int i = 1; i < this.dataPoints.size(); ++i) {
            if (!(this.dataPoints.get(i) < smallestValue)) continue;
            smallestValue = this.dataPoints.get(i);
        }
        return smallestValue;
    }

    public double getMax() {
        if (this.dataPoints.size() == 0) {
            return 0.0;
        }
        double largestValue = this.dataPoints.get(0);
        for (int i = 1; i < this.dataPoints.size(); ++i) {
            if (!(this.dataPoints.get(i) > largestValue)) continue;
            largestValue = this.dataPoints.get(i);
        }
        return largestValue;
    }

    public double getAvg() {
        if (this.dataPoints.size() == 0) {
            return 0.0;
        }
        double avgValue = 0.0;
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            avgValue += this.dataPoints.get(i).doubleValue();
        }
        return avgValue /= (double)this.dataPoints.size();
    }

    public double getStdDev() {
        double avg = this.getAvg();
        double stdDeviation = 0.0;
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            double absoluteDeviation = this.dataPoints.get(i) - avg;
            stdDeviation += absoluteDeviation * absoluteDeviation;
        }
        stdDeviation /= (double)this.dataPoints.size();
        stdDeviation = Math.sqrt(stdDeviation);
        return stdDeviation;
    }

    public void toJson(JSONArray metricArray) {
        this.discardOutliers();
        JSONObject obj = new JSONObject();
        obj.put("name", this.name + ".min");
        if (this.units != null) {
            obj.put("units", this.units);
        }
        if (this.description != null) {
            obj.put("description", this.description);
        }
        obj.put("value", this.getMin());
        metricArray.put(obj);
        obj = new JSONObject();
        obj.put("name", this.name + ".max");
        if (this.units != null) {
            obj.put("units", this.units);
        }
        if (this.description != null) {
            obj.put("description", this.description);
        }
        obj.put("value", this.getMax());
        metricArray.put(obj);
        obj = new JSONObject();
        obj.put("name", this.name + ".avg");
        if (this.units != null) {
            obj.put("units", this.units);
        }
        if (this.description != null) {
            obj.put("description", this.description);
        }
        obj.put("value", this.getAvg());
        metricArray.put(obj);
        obj = new JSONObject();
        obj.put("name", this.name + ".std_dev");
        if (this.units != null) {
            obj.put("units", this.units);
        }
        if (this.description != null) {
            obj.put("description", this.description);
        }
        obj.put("value", this.getStdDev());
        metricArray.put(obj);
    }

    @Override
    public double getValue() {
        this.discardOutliers();
        return this.getAvg();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Units getUnits() {
        return this.units;
    }
}

