/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.benchmarking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hpccsystems.commons.benchmarking.BenchmarkParam;
import org.hpccsystems.commons.benchmarking.IMetric;
import org.hpccsystems.commons.benchmarking.Units;
import org.json.JSONArray;
import org.json.JSONObject;

public class BenchmarkResult {
    private String testGroup = "";
    private String testName = "";
    private String testDescription = "";
    private ArrayList<BenchmarkParam> parameters = new ArrayList();
    private HashMap<String, MetricInfo> metrics = new HashMap();

    public BenchmarkResult(String group2, String name) {
        this.testGroup = group2;
        this.testName = name;
    }

    public BenchmarkResult(String group2, String name, String description) {
        this.testGroup = group2;
        this.testName = name;
        this.testDescription = description;
    }

    public IMetric getMetric(String name) {
        MetricInfo info = this.metrics.get(name);
        if (info == null) {
            return null;
        }
        return info.metric;
    }

    public void addMetric(IMetric metric) {
        if (metric == null) {
            throw new RuntimeException("BenchmarkResult: Error: A null IMetric was provided to addMetric.");
        }
        MetricInfo info = this.metrics.get(metric.getName());
        if (info == null) {
            this.metrics.put(metric.getName(), new MetricInfo(metric));
        } else {
            info.metric = metric;
        }
    }

    public void addMetrics(List<IMetric> metrics) {
        for (int i = 0; i < metrics.size(); ++i) {
            this.addMetric(metrics.get(i));
        }
    }

    public void addParameter(BenchmarkParam param) {
        this.parameters.add(param);
    }

    public void setMetricDesiredUnitScale(String name, Units.Scale scale) {
        MetricInfo info = this.metrics.get(name);
        if (info == null) {
            info = new MetricInfo(null);
            this.metrics.put(name, info);
        }
        info.desiredScale = scale;
    }

    public JSONObject toJson() {
        return this.toJson(null);
    }

    private JSONObject serializeMetric(MetricInfo info, boolean flat) {
        String desc;
        IMetric metric = info.metric;
        Units.Scale desiredScale = Units.Scale.UNIT;
        if (info.desiredScale != null) {
            desiredScale = info.desiredScale;
        } else if (metric.getUnits() != null) {
            desiredScale = metric.getUnits().scale;
        }
        float value = (float)(metric.getValue() * Units.calculateScaleConversion(metric.getUnits().scale, desiredScale));
        if (flat) {
            String desc2;
            JSONObject obj = new JSONObject();
            obj.put("group", this.testGroup);
            obj.put("test", this.testName);
            obj.put("result", metric.getName());
            obj.put("value", value);
            for (int i = 0; i < this.parameters.size(); ++i) {
                BenchmarkParam param = this.parameters.get(i);
                obj.put(param.name, param.value);
            }
            Units units = metric.getUnits();
            if (units != null) {
                Units scaledUnits = new Units(units.type, desiredScale);
                obj.put("units", scaledUnits.toString());
            }
            if ((desc2 = metric.getDescription()) != null) {
                obj.put("description", desc2);
            }
            return obj;
        }
        JSONObject obj = new JSONObject();
        obj.put("name", metric.getName());
        Units units = metric.getUnits();
        if (units != null) {
            Units scaledUnits = new Units(units.type, desiredScale);
            obj.put("units", scaledUnits.toString());
        }
        if ((desc = metric.getDescription()) != null) {
            obj.put("description", desc);
        }
        obj.put("value", value);
        return obj;
    }

    public JSONObject toJson(String[] selectedResults) {
        JSONObject test = new JSONObject();
        test.put("name", this.testName);
        test.put("description", this.testDescription);
        JSONArray jsonParams = new JSONArray();
        for (int i = 0; i < this.parameters.size(); ++i) {
            JSONObject param = this.parameters.get(i).toJson();
            jsonParams.put(param);
        }
        test.put("parameters", this.parameters);
        JSONArray jsonMetrics = new JSONArray();
        if (selectedResults == null || selectedResults.length == 0) {
            for (Map.Entry entry : this.metrics.entrySet()) {
                MetricInfo metricInfo = (MetricInfo)entry.getValue();
                if (metricInfo == null || metricInfo.metric == null) continue;
                JSONObject obj = this.serializeMetric(metricInfo, false);
                jsonMetrics.put(obj);
            }
        } else {
            for (int i = 0; i < selectedResults.length; ++i) {
                MetricInfo metricInfo = this.metrics.get(selectedResults[i]);
                if (metricInfo == null || metricInfo.metric == null) continue;
                JSONObject obj = this.serializeMetric(metricInfo, false);
                jsonMetrics.put(obj);
            }
        }
        test.put("results", jsonMetrics);
        return test;
    }

    public JSONArray toFlatJson() {
        return this.toFlatJson(null);
    }

    public JSONArray toFlatJson(String[] selectedResults) {
        JSONArray results = new JSONArray();
        if (selectedResults == null || selectedResults.length == 0) {
            for (Map.Entry<String, MetricInfo> entry : this.metrics.entrySet()) {
                MetricInfo metricInfo = entry.getValue();
                if (metricInfo == null || metricInfo.metric == null) continue;
                JSONObject obj = this.serializeMetric(metricInfo, true);
                results.put(obj);
            }
        } else {
            for (int i = 0; i < selectedResults.length; ++i) {
                MetricInfo metricInfo = this.metrics.get(selectedResults[i]);
                if (metricInfo == null || metricInfo.metric == null) continue;
                JSONObject obj = this.serializeMetric(metricInfo, true);
                results.put(obj);
            }
        }
        return results;
    }

    private class MetricInfo {
        public IMetric metric = null;
        public Units.Scale desiredScale = null;

        public MetricInfo(IMetric metric) {
            this.metric = metric;
        }
    }
}

