/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.benchmarking;

public class Units {
    public Type type;
    public Scale scale;

    public Units(Type type) {
        this.type = type;
        this.scale = Scale.UNIT;
    }

    public Units(Type type, Scale scale) {
        this.type = type;
        this.scale = scale;
    }

    public String toString() {
        return this.scale.scalePrefix + this.type.typePostfix;
    }

    public static double calculateScaleConversion(Scale from, Scale to) {
        return Math.pow(10.0, from.scalePower - to.scalePower);
    }

    public static enum Scale {
        NANO("n", -9),
        MICRO("u", -6),
        MILLI("m", -3),
        UNIT("", 0),
        KILO("K", 3),
        MEGA("M", 6),
        GIGA("G", 9);

        public String scalePrefix;
        public int scalePower = 0;

        private Scale(String prefix, int scalePower) {
            this.scalePrefix = prefix;
            this.scalePower = scalePower;
        }
    }

    public static enum Type {
        SECONDS("s"),
        BYTES("B"),
        COUNT(""),
        PERCENTAGE("%");

        public String typePostfix;

        private Type(String postFix) {
            this.typePostfix = postFix;
        }
    }
}

