/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.ecl;

import java.io.Serializable;
import java.util.Iterator;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.ecl.HpccSrcType;

public class FieldDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MASK_32_LOWER_HALF = 65535;
    private static final int MASK_32_UPPER_HALF = -65536;
    private String fieldName = "";
    private FieldType fieldType = FieldType.UNKNOWN;
    private String typeName = FieldType.UNKNOWN.description();
    private FieldDef[] defs = new FieldDef[0];
    private HpccSrcType srcType = HpccSrcType.UNKNOWN;
    private long len = 0L;
    private boolean fixedLength = false;
    private boolean isUnsigned = false;
    private int additionalFlags = 0;

    public FieldDef(FieldDef rhs) {
        this.fieldName = rhs.fieldName;
        this.fieldType = rhs.fieldType;
        this.typeName = rhs.typeName;
        this.defs = rhs.defs;
        this.srcType = rhs.srcType;
        this.len = rhs.len;
        this.fixedLength = rhs.fixedLength;
        this.isUnsigned = rhs.isUnsigned;
        this.additionalFlags = rhs.additionalFlags;
    }

    public FieldDef(String fieldName, FieldType fieldType, String typeName, long len, boolean isFixedLength, boolean isUnsigned, HpccSrcType sourceType, FieldDef[] childDefs) {
        this(fieldName, fieldType, typeName, len, isFixedLength, isUnsigned, 0, sourceType, childDefs);
    }

    public FieldDef(String fieldName, FieldType fieldType, String typeName, long len, boolean isFixedLength, boolean isUnsigned, int additionalFlags, HpccSrcType sourceType, FieldDef[] childDefs) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.typeName = typeName;
        this.additionalFlags = additionalFlags;
        this.defs = childDefs;
        if (this.defs == null) {
            this.defs = new FieldDef[0];
        }
        this.srcType = sourceType;
        this.fixedLength = isFixedLength;
        this.isUnsigned = isUnsigned;
        this.len = len;
        if (this.fieldType == FieldType.VAR_STRING && !sourceType.isUTF16() && sourceType != HpccSrcType.SINGLE_BYTE_CHAR) {
            throw new IllegalArgumentException("Invalid field defintion for: " + fieldName + "VarStrings must be encoded in either UTF16 or ASCII");
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String newFieldName) {
        this.fieldName = newFieldName;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public HpccSrcType getSourceType() {
        return this.srcType;
    }

    public void setDataLen(long dataLen) {
        this.len = dataLen;
    }

    public long getDataLen() {
        if (this.fieldType != FieldType.DECIMAL) {
            return this.len;
        }
        if (this.isUnsigned()) {
            int precision = (int)(this.len & 0xFFFFL);
            int dataLen = (precision + 1) / 2;
            return dataLen;
        }
        int precision = (int)(this.len & 0xFFFFL);
        int dataLen = (precision + 2) / 2;
        return dataLen;
    }

    public int getPrecision() {
        if (this.fieldType != FieldType.DECIMAL) {
            return 0;
        }
        return (int)(this.len & 0xFFFFL);
    }

    public void setPrecision(int precision) {
        if (this.fieldType != FieldType.DECIMAL) {
            return;
        }
        if (precision > 64) {
            precision = 64;
        }
        this.len &= 0xFFFFFFFFFFFF0000L;
        this.len |= (long)(precision & 0xFFFF);
    }

    public int getScale() {
        if (this.fieldType != FieldType.DECIMAL) {
            return 0;
        }
        int scale = (int)(this.len >> 16);
        return scale;
    }

    public void setScale(int scale) {
        if (this.fieldType != FieldType.DECIMAL) {
            return;
        }
        if (scale > 32) {
            scale = 32;
        }
        this.len &= 0xFFFFL;
        this.len |= (long)(scale << 16);
    }

    public boolean isFixed() {
        return this.fixedLength;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public int getAdditionalFlags() {
        return this.additionalFlags;
    }

    public void setAdditionalFlags(int flags) {
        this.additionalFlags = flags;
    }

    public int getNumDefs() {
        return this.defs.length;
    }

    public FieldDef getDef(int ndx) {
        return this.defs[ndx];
    }

    public void setDefs(FieldDef[] childDefs) {
        if (childDefs == null) {
            childDefs = new FieldDef[]{};
        }
        this.defs = childDefs;
        FieldDef.updateRecordMeta(this);
    }

    public int getDefIndexWithFieldName(String fieldName) {
        for (int i = 0; i < this.defs.length; ++i) {
            if (!this.defs[i].getFieldName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public Iterator<FieldDef> getDefinitions() {
        final FieldDef[] defRef = this.defs;
        Iterator<FieldDef> rslt = new Iterator<FieldDef>(){
            int pos = 0;
            FieldDef[] copy = defRef;

            @Override
            public boolean hasNext() {
                return this.pos < this.copy.length;
            }

            @Override
            public FieldDef next() {
                return this.copy[this.pos++];
            }
        };
        return rslt;
    }

    private static void updateRecordMeta(FieldDef recordDef) {
        FieldDef.updateRecordMinLength(recordDef);
    }

    private static void updateRecordMinLength(FieldDef recordDef) {
        for (int i = 0; i < recordDef.getNumDefs(); ++i) {
            FieldDef childDef = recordDef.getDef(i);
            if (childDef.getFieldType() != FieldType.RECORD) continue;
            FieldDef.updateRecordMinLength(childDef);
        }
        long minDataLength = FieldDef.getMinLengthInBytes(recordDef);
        recordDef.setDataLen(minDataLength);
    }

    private static long getMinLengthInBytes(FieldDef def) {
        switch (def.getFieldType()) {
            case RECORD: {
                long minDataLength = 0L;
                for (int i = 0; i < def.getNumDefs(); ++i) {
                    FieldDef childDef = def.getDef(i);
                    minDataLength += FieldDef.getMinLengthInBytes(childDef);
                }
                return minDataLength;
            }
            case SET: {
                return 5L;
            }
        }
        long dataLength = 0L;
        if (def.isFixed()) {
            dataLength = def.getDataLen();
            if (def.getFieldType() == FieldType.VAR_STRING) {
                ++dataLength;
            }
            if (def.getSourceType().isUTF16()) {
                dataLength *= 2L;
            }
        } else {
            dataLength = 4L;
        }
        return dataLength;
    }

    public String toString() {
        String output = "";
        for (int fieldIndex = 0; fieldIndex < this.defs.length; ++fieldIndex) {
            FieldDef currentFieldDef = this.defs[fieldIndex];
            long dataLen = currentFieldDef.getDataLen();
            output = output + currentFieldDef.getFieldName() + "(" + currentFieldDef.getFieldType() + (dataLen > 0L ? " - " + currentFieldDef.getDataLen() : "") + ")";
            if (fieldIndex >= this.defs.length - 1) continue;
            output = output + " | ";
        }
        return output;
    }
}

