/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.errors;

import org.hpccsystems.commons.errors.HpccErrorLevel;
import org.hpccsystems.commons.errors.IErrorCode;
import org.hpccsystems.commons.errors.IErrorSource;
import org.hpccsystems.commons.errors.IErrorType;

public class HpccError {
    private final IErrorCode errorCode;
    private IErrorType errorType;
    private final HpccErrorLevel errorLevel;
    private final String errorString;
    private String additionalInfo;
    private Integer linenum = 0;
    private Integer colnum = 0;
    private String filename;
    private String sourceID;
    private IErrorSource errorSource = null;
    private Exception exception;

    public HpccError(HpccErrorLevel errlevel, IErrorType errType, IErrorCode constraintViolated, String errorString) {
        this.errorLevel = errlevel;
        this.errorType = errType;
        this.errorCode = constraintViolated;
        this.errorString = errorString;
    }

    public HpccError(HpccErrorLevel errlevel, IErrorType errType, IErrorCode constraintViolated, String errorString, Exception ex) {
        this.errorLevel = errlevel;
        this.errorType = errType;
        this.errorCode = constraintViolated;
        this.errorString = errorString;
        this.exception = ex;
    }

    public HpccError(HpccErrorLevel errlevel, IErrorType errType, IErrorCode errCode, String errorString, String additional, Integer lineNum, Integer colNum, String filename) {
        this.errorLevel = errlevel;
        this.errorType = errType;
        this.errorCode = errCode;
        this.errorString = errorString;
        this.additionalInfo = additional;
        this.colnum = colNum;
        this.linenum = lineNum;
        this.filename = filename;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[HpccError errorType=").append(String.valueOf(this.errorType)).append(",\n");
        sb.append("errorLevel=").append(String.valueOf((Object)this.errorLevel)).append(",\n");
        sb.append("errorCode=").append(String.valueOf(this.errorCode)).append("(").append(String.valueOf(this.errorCode.getNumVal())).append("),\n");
        sb.append("errorSource=").append(String.valueOf(this.errorSource)).append(",\n");
        sb.append("sourceID=").append(String.valueOf(this.sourceID)).append(",\n");
        sb.append("fileName=").append(String.valueOf(this.filename)).append(",\n");
        sb.append("lineNum=").append(String.valueOf(this.linenum)).append(",\n");
        sb.append("colNum=").append(String.valueOf(this.colnum)).append(",\n");
        sb.append("message=\"").append(String.valueOf(this.errorString)).append("\",\n");
        sb.append("additional=\"").append(String.valueOf(this.additionalInfo)).append("\"]\n");
        return sb.toString();
    }

    public String toEclIdeString() {
        StringBuilder sb = new StringBuilder();
        String fname = this.getFilename();
        if (fname == null) {
            fname = "unknown file";
        }
        sb.append(fname).append("(").append(String.valueOf(this.getLineNum())).append(",").append(String.valueOf(this.getColNum())).append("):").append(this.getErrorLevel().toString().toLowerCase()).append(" ").append(this.getErrCodePrefix()).append(String.valueOf(this.errorCode.getNumVal()) + ":").append(this.getErrorString()).append("\n");
        return sb.toString();
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(String sourceID) {
        this.sourceID = sourceID;
    }

    public IErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public Integer getLineNum() {
        return this.linenum;
    }

    public void setLineNum(int l) {
        this.linenum = l;
    }

    public Integer getColNum() {
        return this.colnum;
    }

    public void setColNum(int c) {
        this.colnum = c;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setErrorSource(IErrorSource val) {
        this.errorSource = val;
    }

    public IErrorSource getErrorSource() {
        return this.errorSource;
    }

    public IErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(IErrorType val) {
        this.errorType = val;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String info) {
        this.additionalInfo = info;
    }

    public HpccErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public int hashCode() {
        return this.toEclIdeString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    private String getErrCodePrefix() {
        return "H";
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception ex) {
        this.exception = ex;
    }
}

