/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.filter;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.hpccsystems.commons.filter.SQLFragment;
import org.hpccsystems.commons.filter.SQLOperator;
import org.hpccsystems.commons.filter.SQLTable;

public class SQLExpression {
    private SQLOperator prevExpUnifier = null;
    private SQLFragment prefix = new SQLFragment();
    private SQLOperator operator = null;
    private SQLFragment postfix = new SQLFragment();
    public static final char PARENTFIELDSEP = '.';
    public static final char SINGLEBLANKBUFFER = ' ';

    public void ParseExpression(String expression) throws SQLException {
        String trimmedExpression = expression.trim();
        SQLOperator operator = new SQLOperator(trimmedExpression);
        if (operator == null || operator.getValue() == null || !operator.isValid()) {
            throw new SQLException("Invalid logical operator found: " + trimmedExpression);
        }
        String[] splitedsqlexp = operator.splitExpressionFragment(trimmedExpression);
        this.setPrefix(splitedsqlexp[0].trim());
        this.setOperator(operator);
        if (operator.isBinary()) {
            if (splitedsqlexp.length == 2) {
                this.setPostfix(splitedsqlexp[1].trim());
            } else {
                throw new SQLException("Invalid SQL Where clause found around: " + expression);
            }
        }
    }

    public String getPrefixValue() {
        return this.prefix.getValue();
    }

    public String getFullPrefix() {
        return this.prefix.getFullColumnName();
    }

    public String getFullPostfix() {
        return this.postfix.getFullColumnName();
    }

    public void setPrefix(String prefix) {
        this.prefix.parseExpressionFragment(prefix);
    }

    public SQLOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLOperator operator) {
        this.operator = operator;
    }

    public void setOperator(String operator) {
        this.operator = new SQLOperator(operator);
    }

    public boolean isOperatorValid() {
        return this.operator != null ? this.operator.isValid() : false;
    }

    public String getPostfixValue() {
        return this.postfix.getValue();
    }

    public void setPostfix(String postfixstr) {
        this.postfix.parseExpressionFragment(postfixstr);
    }

    public boolean isPrefixParameterized() {
        return this.prefix.isParameterized();
    }

    public boolean isPostfixParameterized() {
        return this.postfix.isParameterized();
    }

    public SQLFragment.FragmentType getPrefixType() {
        return this.prefix.getType();
    }

    public SQLFragment.FragmentType getPostfixType() {
        return this.postfix.getType();
    }

    public String toString() {
        return this.toStringFull(false);
    }

    public String toStringFull(boolean outputfull) {
        StringBuffer tmpsb = new StringBuffer();
        if (this.prevExpUnifier != null) {
            tmpsb.append(this.prevExpUnifier);
        }
        switch (this.operator.getType()) {
            case BINARY: {
                tmpsb.append(outputfull ? this.getFullPrefix() : this.prefix.getValue()).append(' ').append(this.operator.toString()).append(' ').append(outputfull ? this.getFullPostfix() : this.postfix.getValue());
                break;
            }
            case PRE_UNARY: {
                tmpsb.append(' ').append(this.operator.toString()).append(' ').append(outputfull ? this.getFullPrefix() : this.prefix.getValue()).append(' ');
                break;
            }
            case POST_UNARY: {
                tmpsb.append(' ').append(outputfull ? this.getFullPrefix() : this.prefix.getValue()).append(' ').append(this.operator.toString()).append(' ');
                break;
            }
            case NOOPFALSE: {
                tmpsb.append(" false ");
                break;
            }
            case NOOPTRUE: {
                tmpsb.append(" true ");
                break;
            }
            default: {
                return this.toString();
            }
        }
        return tmpsb.toString();
    }

    public String toStringTranslateSource(HashMap<String, String> map, boolean ignoreprevunifier, boolean ignoreMisTraslations) {
        StringBuffer tmpsb = new StringBuffer();
        if (!ignoreprevunifier && this.prevExpUnifier != null) {
            tmpsb.append(this.prevExpUnifier);
        }
        String prefixtranslate = map.get(this.prefix.getParent());
        String postfixtranslate = map.get(this.postfix.getParent());
        if (!ignoreMisTraslations && (prefixtranslate == null && this.prefix.getParent() != null || postfixtranslate == null && this.postfix.getParent() != null)) {
            return null;
        }
        switch (this.operator.getType()) {
            case BINARY: {
                if (prefixtranslate != null) {
                    tmpsb.append(prefixtranslate);
                    tmpsb.append('.');
                } else if (this.prefix.getParent() != null && this.prefix.getParent().length() > 0) {
                    tmpsb.append(this.prefix.getParent());
                    tmpsb.append('.');
                }
                tmpsb.append(this.prefix.getValue()).append(' ').append(this.operator.toString()).append(' ');
                if (postfixtranslate != null) {
                    tmpsb.append(postfixtranslate);
                    tmpsb.append('.');
                } else if (this.postfix.getParent() != null && this.postfix.getParent().length() > 0) {
                    tmpsb.append(this.postfix.getParent());
                    tmpsb.append('.');
                }
                tmpsb.append(this.postfix.getValue());
                break;
            }
            case PRE_UNARY: {
                tmpsb.append(' ').append(this.operator.toString()).append(' ');
                if (prefixtranslate != null) {
                    tmpsb.append(prefixtranslate);
                    tmpsb.append('.');
                } else if (this.prefix.getParent() != null && this.prefix.getParent().length() > 0) {
                    tmpsb.append(this.prefix.getParent());
                    tmpsb.append('.');
                }
                tmpsb.append(this.prefix.getValue()).append(' ');
                break;
            }
            case POST_UNARY: {
                if (prefixtranslate != null) {
                    tmpsb.append(prefixtranslate);
                    tmpsb.append('.');
                } else if (this.prefix.getParent() != null && this.prefix.getParent().length() > 0) {
                    tmpsb.append(this.prefix.getParent());
                    tmpsb.append('.');
                }
                tmpsb.append(this.prefix.getValue()).append(' ');
                tmpsb.append(this.operator.toString()).append(' ');
                break;
            }
            case NOOPFALSE: {
                tmpsb.append(" false ");
                break;
            }
            case NOOPTRUE: {
                tmpsb.append(" true ");
            }
        }
        return tmpsb.toString();
    }

    public boolean isEqualityCondition(HashMap<String, String> map, String first, String second) {
        String prefixtranslate = map.get(this.prefix.getParent());
        String postfixtranslate = map.get(this.postfix.getParent());
        if (prefixtranslate == null || postfixtranslate == null) {
            return false;
        }
        switch (this.operator.getType()) {
            case BINARY: {
                return !prefixtranslate.equals(postfixtranslate) && (prefixtranslate.equals(first) || postfixtranslate.equals(first) && prefixtranslate.equals(second) || postfixtranslate.equals(second));
            }
        }
        return false;
    }

    public void setPrefix(SQLFragment prefix) {
        this.prefix = prefix;
    }

    public void setPostfix(SQLFragment postfix) {
        this.postfix = postfix;
    }

    public void updateFragmentTables(List<SQLTable> sqlTables) throws Exception {
        if (this.postfix.getType() == SQLFragment.FragmentType.FIELD || this.postfix.getType() == SQLFragment.FragmentType.FIELD_CONTENT_MODIFIER || this.postfix.getType() == SQLFragment.FragmentType.AGGREGATE_FUNCTION) {
            this.postfix.updateFragmentColumParent(sqlTables);
        }
        if (this.prefix.getType() == SQLFragment.FragmentType.FIELD || this.prefix.getType() == SQLFragment.FragmentType.FIELD_CONTENT_MODIFIER) {
            this.prefix.updateFragmentColumParent(sqlTables);
        }
    }

    public boolean containsKey(String colname) {
        return this.getPrefixType() == SQLFragment.FragmentType.FIELD && this.getPrefixValue().equals(colname) || this.getPostfixType() == SQLFragment.FragmentType.FIELD && this.getPostfixValue().equals(colname);
    }

    public void setPreviousExpUnifier(SQLOperator prevexpunifier) {
        this.prevExpUnifier = prevexpunifier;
    }

    public SQLOperator getPreviousExpUnifier() {
        return this.prevExpUnifier;
    }
}

