/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.filter;

import java.util.List;
import java.util.StringTokenizer;
import org.hpccsystems.commons.filter.SQLTable;
import org.hpccsystems.commons.utils.Utils;

public class SQLFragment {
    private String fnname = null;
    private String parent = null;
    private String value = null;
    private FragmentType type = FragmentType.UNKNOWN_TYPE;

    public SQLFragment() {
    }

    public SQLFragment(String framentStr) {
        this.parseExpressionFragment(framentStr);
    }

    public boolean isParameterized() {
        return this.type == FragmentType.PARAMETERIZED;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent.toUpperCase();
    }

    public String getValue() {
        if (this.type == FragmentType.CONTENT_MODIFIER || this.type == FragmentType.FIELD_CONTENT_MODIFIER) {
            return this.fnname + "( " + this.value + " )";
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FragmentType getType() {
        return this.type;
    }

    public void setType(FragmentType type) {
        this.type = type;
    }

    private void handleFieldType(String fragment) {
        String[] fragsplit = fragment.split("\\.", 2);
        if (fragsplit.length == 1) {
            this.setValue(Utils.handleQuotedString(fragsplit[0]));
        } else {
            this.setParent(Utils.handleQuotedString(fragsplit[0]));
            this.setValue(Utils.handleQuotedString(fragsplit[1]));
        }
    }

    private void handleSQLFieldType(String fragment) {
        String[] fragsplit = fragment.split("\\.", 2);
        if (fragsplit.length == 1) {
            this.setValue(Utils.handleQuotedIdentifier(fragsplit[0]));
        } else {
            this.setParent(Utils.handleQuotedIdentifier(fragsplit[0]));
            this.setValue(Utils.handleQuotedIdentifier(fragsplit[1]));
        }
    }

    public void parseExpressionFragment(String fragment) {
        try {
            this.type = SQLFragment.determineFragmentType(fragment);
            switch (this.type) {
                case LITERAL_STRING: {
                    fragment = Utils.replaceSQLwithECLEscapeChar(fragment);
                }
                case NUMERIC_FRAGMENT: 
                case PARAMETERIZED: 
                case BOOLEAN: {
                    this.setValue(fragment);
                    break;
                }
                case FIELD: {
                    this.handleSQLFieldType(fragment);
                    break;
                }
                case LIST: {
                    if (Utils.hasPossibleEscapedQuoteLiteral(fragment)) {
                        StringBuilder tmp = new StringBuilder();
                        StringTokenizer comatokens = new StringTokenizer(Utils.getParenContents(fragment), ",");
                        while (comatokens.hasMoreTokens()) {
                            if (tmp.length() == 0) {
                                tmp.append("[");
                            } else {
                                tmp.append(", ");
                            }
                            tmp.append(Utils.replaceSQLwithECLEscapeChar(comatokens.nextToken().trim()));
                        }
                        tmp.append("]");
                        this.setValue(tmp.toString());
                        break;
                    }
                    this.setValue("[" + Utils.getParenContents(fragment) + "]");
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error while parsing SQL fragment: " + fragment);
        }
    }

    public static SQLFragment createExpressionFragment(String fragment) {
        SQLFragment frag = new SQLFragment();
        frag.parseExpressionFragment(fragment);
        return frag;
    }

    public static FragmentType determineFragmentType(String fragStr) {
        if (fragStr == null || fragStr.length() <= 0) {
            return FragmentType.UNKNOWN_TYPE;
        }
        if (Utils.isParameterizedStr(fragStr)) {
            return FragmentType.PARAMETERIZED;
        }
        if (Utils.isSQLLiteralString(fragStr)) {
            return FragmentType.LITERAL_STRING;
        }
        if (Utils.isBooleanKeyWord(fragStr)) {
            return FragmentType.BOOLEAN;
        }
        if (Utils.isNumeric(fragStr)) {
            return FragmentType.NUMERIC_FRAGMENT;
        }
        if (Utils.isInParenthesis(fragStr)) {
            return FragmentType.LIST;
        }
        if (Utils.isAggFunction(fragStr)) {
            return FragmentType.AGGREGATE_FUNCTION;
        }
        return FragmentType.FIELD;
    }

    public String getFullColumnName() {
        if (this.type == FragmentType.FIELD) {
            return this.getParent() + "." + this.getValue();
        }
        return this.getValue();
    }

    public void updateFragmentColumParent(List<SQLTable> sqlTables) throws Exception {
        if (this.type == FragmentType.FIELD || this.type == FragmentType.FIELD_CONTENT_MODIFIER) {
            if (this.parent != null && this.parent.length() > 0) {
                this.setParent(this.searchForPossibleTableName(sqlTables));
            } else if (sqlTables.size() == 1) {
                this.setParent(sqlTables.get(0).getName());
            } else {
                throw new Exception("Ambiguous field found: " + this.getValue());
            }
        }
    }

    private String searchForPossibleTableName(List<SQLTable> sqlTables) throws Exception {
        for (int i = 0; i < sqlTables.size(); ++i) {
            SQLTable currTable = sqlTables.get(i);
            if (!this.parent.equalsIgnoreCase(currTable.getAlias()) && !this.parent.equalsIgnoreCase(currTable.getName())) continue;
            return currTable.getName();
        }
        throw new Exception("Invalid field found: " + this.getFullColumnName());
    }

    public String getFnname() {
        return this.fnname;
    }

    public void setFnname(String fnname) {
        this.fnname = fnname;
    }

    public static enum FragmentType {
        UNKNOWN_TYPE,
        NUMERIC_FRAGMENT,
        LITERAL_STRING,
        PARAMETERIZED,
        FIELD,
        LIST,
        CONTENT_MODIFIER,
        FIELD_CONTENT_MODIFIER,
        AGGREGATE_FUNCTION,
        BOOLEAN;

    }
}

