/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.ecl.HpccSrcType;
import org.hpccsystems.dfs.client.IRecordAccessor;
import org.hpccsystems.dfs.client.IRecordWriter;
import org.hpccsystems.dfs.client.StreamOperationMessages;

public class BinaryRecordWriter
implements IRecordWriter {
    private static final Logger log = LogManager.getLogger(BinaryRecordWriter.class);
    private static final int DataLenFieldSize = 4;
    private static final int DefaultBufferSizeKB = 4096;
    private static final byte NegativeSignValue = 13;
    private static final byte PositiveSignValue = 15;
    private static final int MASK_32_LOWER_HALF = 65535;
    private static final int SCRATCH_BUFFER_SIZE = 256;
    private static final int QSTR_COMPRESSED_CHUNK_LEN = 3;
    private static final int QSTR_EXPANDED_CHUNK_LEN = 4;
    private byte[] scratchBuffer = new byte[256];
    private OutputStream outputStream = null;
    private ByteBuffer buffer = null;
    private long bytesWritten = 0L;
    private IRecordAccessor rootRecordAccessor = null;
    private StreamOperationMessages messages = new StreamOperationMessages();

    public String getStreamMessages() {
        return this.messages.getMessagesSummary();
    }

    public int getStreamMessageCount() {
        return this.messages.getTotalMessageCount();
    }

    public BinaryRecordWriter(OutputStream output) throws Exception {
        this(output, ByteOrder.nativeOrder());
    }

    public BinaryRecordWriter(OutputStream output, ByteOrder byteOrder) throws Exception {
        this.outputStream = output;
        this.buffer = ByteBuffer.allocate(0x400000);
        this.buffer.order(byteOrder);
    }

    @Override
    public void initialize(IRecordAccessor recordAccessor) {
        this.rootRecordAccessor = recordAccessor;
    }

    @Override
    public void writeRecord(Object record) throws Exception {
        this.writeRecord(this.rootRecordAccessor, record);
    }

    private void writeRecord(IRecordAccessor recordAccessor, Object record) throws Exception {
        if (this.buffer.remaining() <= 32) {
            this.flush();
        }
        recordAccessor.setRecord(record);
        block7: for (int i = 0; i < recordAccessor.getNumFields(); ++i) {
            FieldDef fd = recordAccessor.getFieldDefinition(i);
            Object fieldValue = recordAccessor.getFieldValue(i);
            switch (fd.getFieldType()) {
                case INTEGER: 
                case FILEPOS: 
                case REAL: 
                case DECIMAL: 
                case BINARY: 
                case BOOLEAN: 
                case STRING: 
                case CHAR: 
                case VAR_STRING: {
                    try {
                        this.writeField(fd, fieldValue);
                        continue block7;
                    }
                    catch (Exception e) {
                        throw new Exception("Error while writing field: " + fd.getFieldName() + " of type: " + fd.getFieldType() + ": ", e);
                    }
                }
                case RECORD: {
                    this.writeRecord(recordAccessor.getChildRecordAccessor(i), fieldValue);
                    continue block7;
                }
                case SET: 
                case DATASET: {
                    ArrayList<Object> listValue = null;
                    if (fieldValue instanceof List) {
                        listValue = (ArrayList<Object>)fieldValue;
                    } else if (fieldValue == null) {
                        listValue = new ArrayList<Object>();
                    } else {
                        throw new Exception("Error writing list. Expected List got: " + fieldValue.getClass().getName());
                    }
                    this.writeList(fd, recordAccessor.getChildRecordAccessor(i), listValue);
                    continue block7;
                }
                default: {
                    throw new Exception("Unsupported type: " + fd.getFieldType() + " for field: " + fd.getFieldName());
                }
            }
        }
    }

    @Override
    public void flush() throws Exception {
        byte[] data = this.buffer.array();
        int dataLen = this.buffer.position();
        this.outputStream.write(data, 0, dataLen);
        this.bytesWritten += (long)dataLen;
        this.buffer.clear();
    }

    @Override
    public int getBufferCapacity() {
        return this.buffer.capacity();
    }

    @Override
    public int getRemainingBufferCapacity() {
        return this.buffer.remaining();
    }

    @Override
    public void finalize() throws Exception {
        this.flush();
        this.outputStream.close();
    }

    @Override
    public long getTotalBytesWritten() {
        return this.bytesWritten;
    }

    private void writeField(FieldDef fd, Object fieldValue) throws Exception {
        if (this.buffer.remaining() <= 32) {
            this.flush();
        }
        switch (fd.getFieldType()) {
            case BINARY: {
                byte[] data;
                byte[] byArray = data = fieldValue == null ? new byte[]{} : (byte[])fieldValue;
                if (fd.isFixed()) {
                    int fillLength;
                    int bytesToWrite = data.length;
                    if ((long)bytesToWrite > fd.getDataLen()) {
                        this.messages.addMessage("Warning: Potential truncation of binary data for field: '" + fd.getFieldName() + "'");
                        bytesToWrite = (int)fd.getDataLen();
                    }
                    this.writeByteArray(data, 0, bytesToWrite);
                    for (int numFillBytes = (int)fd.getDataLen() - bytesToWrite; numFillBytes > 0; numFillBytes -= fillLength) {
                        fillLength = numFillBytes;
                        if (fillLength > 256) {
                            fillLength = 256;
                        }
                        Arrays.fill(this.scratchBuffer, 0, fillLength, (byte)0);
                        this.writeByteArray(this.scratchBuffer, 0, fillLength);
                    }
                    break;
                }
                long dataSize = data.length;
                this.writeUnsigned(dataSize);
                this.writeByteArray(data);
                break;
            }
            case BOOLEAN: {
                Boolean value = fieldValue == null ? Boolean.valueOf(false) : (Boolean)fieldValue;
                byte byteValue = 0;
                if (value.booleanValue()) {
                    byteValue = 1;
                }
                this.buffer.put(byteValue);
                break;
            }
            case INTEGER: 
            case FILEPOS: {
                Long value = null;
                if (fieldValue == null) {
                    value = 0L;
                } else if (fieldValue instanceof Long) {
                    value = (Long)fieldValue;
                } else if (fieldValue instanceof Integer) {
                    value = ((Integer)fieldValue).longValue();
                } else if (fieldValue instanceof BigInteger) {
                    value = ((BigInteger)fieldValue).longValue();
                } else if (fieldValue instanceof BigDecimal) {
                    value = ((BigDecimal)fieldValue).longValue();
                } else if (fieldValue instanceof Short) {
                    value = ((Short)fieldValue).longValue();
                } else if (fieldValue instanceof Byte) {
                    value = ((Byte)fieldValue).longValue();
                } else {
                    throw new Exception("Unsupported integer type: " + fieldValue.getClass().getName() + " for field " + fd.getFieldName());
                }
                if (fd.getDataLen() == 1L) {
                    this.buffer.put(value.byteValue());
                    break;
                }
                if (fd.getDataLen() == 2L) {
                    this.buffer.putShort(value.shortValue());
                    break;
                }
                if (fd.getDataLen() == 4L) {
                    this.buffer.putInt(value.intValue());
                    break;
                }
                if (fd.getDataLen() == 8L) {
                    this.buffer.putLong(value);
                    break;
                }
                if (fd.getDataLen() < 8L && fd.getDataLen() > 0L) {
                    long lastByteIdx = fd.getDataLen() - 1L;
                    int i = 0;
                    while ((long)i < lastByteIdx) {
                        this.buffer.put((byte)(value >> i * 8 & 0xFFL));
                        ++i;
                    }
                    long signBit = value < 0L ? 128L : 0L;
                    this.buffer.put((byte)(value >> (int)(lastByteIdx * 8L) & 0xFFL | signBit));
                    break;
                }
                throw new Exception("Unsupported integer length: " + fd.getDataLen() + " for field: " + fd.getFieldName());
            }
            case DECIMAL: {
                BigDecimal value = fieldValue == null ? BigDecimal.valueOf(0L) : (BigDecimal)fieldValue;
                this.writeDecimal(fd, value);
                break;
            }
            case REAL: {
                Double value = 0.0;
                if (fieldValue instanceof Double) {
                    value = (Double)fieldValue;
                } else if (fieldValue instanceof Integer) {
                    value = ((Float)fieldValue).doubleValue();
                }
                if (fd.getDataLen() == 4L) {
                    this.buffer.putFloat(value.floatValue());
                    break;
                }
                if (fd.getDataLen() == 8L) {
                    this.buffer.putDouble(value);
                    break;
                }
                throw new Exception("Unsupported real length: " + fd.getDataLen() + " for field: " + fd.getFieldName());
            }
            case CHAR: {
                byte c = 0;
                if (fieldValue != null) {
                    String value = (String)fieldValue;
                    c = (byte)value.charAt(0);
                }
                this.buffer.put(c);
                break;
            }
            case STRING: 
            case VAR_STRING: {
                String value = fieldValue != null ? (String)fieldValue : "";
                byte[] data = new byte[]{};
                if (fd.getSourceType() == HpccSrcType.UTF16LE) {
                    data = value.getBytes("UTF-16LE");
                } else if (fd.getSourceType() == HpccSrcType.UTF16BE) {
                    data = value.getBytes("UTF-16BE");
                } else if (fd.getSourceType() == HpccSrcType.UTF8) {
                    data = value.getBytes("UTF-8");
                } else if (fd.getSourceType() == HpccSrcType.SINGLE_BYTE_CHAR) {
                    data = value.getBytes("ISO-8859-1");
                } else if (fd.getSourceType() == HpccSrcType.QSTRING) {
                    byte[] tempData = value.getBytes("ISO-8859-1");
                    int compressedDataLen = tempData.length * 3 + 3;
                    data = new byte[compressedDataLen /= 4];
                    int bitOffset = 0;
                    for (int i = 0; i < tempData.length; ++i) {
                        int byteIdx = bitOffset / 8;
                        int qstrByteValue = (tempData[i] & 0xFF) - 32;
                        int charIdxMod = i % 4;
                        switch (charIdxMod) {
                            case 3: {
                                int n = byteIdx;
                                data[n] = (byte)(data[n] | (byte)(qstrByteValue & 0x3F));
                                break;
                            }
                            case 2: {
                                int n = byteIdx;
                                data[n] = (byte)(data[n] | (byte)((qstrByteValue & 0x3C) >> 2));
                                data[byteIdx + 1] = (byte)((qstrByteValue & 3) << 6);
                                break;
                            }
                            case 1: {
                                int n = byteIdx;
                                data[n] = (byte)(data[n] | (byte)((qstrByteValue & 0x30) >> 4));
                                data[byteIdx + 1] = (byte)((qstrByteValue & 0xF) << 4);
                                break;
                            }
                            case 0: {
                                data[byteIdx] = (byte)((qstrByteValue & 0x3F) << 2);
                            }
                        }
                        bitOffset += 6;
                    }
                } else {
                    throw new Exception("Unsupported string encoding type: " + (Object)((Object)fd.getSourceType()) + " encountered while writing field: " + fd.getFieldName());
                }
                if (fd.isFixed()) {
                    int fillLength;
                    if (fd.getDataLen() > Integer.MAX_VALUE) {
                        throw new Exception("String length: " + fd.getDataLen() + " exceeds max supported length: " + Integer.MAX_VALUE);
                    }
                    int bytesToWrite = (int)fd.getDataLen();
                    if (fd.getFieldType() == FieldType.VAR_STRING) {
                        ++bytesToWrite;
                    }
                    if (fd.getSourceType().isUTF16()) {
                        bytesToWrite *= 2;
                    }
                    if (data.length >= bytesToWrite) {
                        if (fd.getFieldType() == FieldType.VAR_STRING && bytesToWrite > 0) {
                            data[bytesToWrite - 1] = 0;
                            if (fd.getSourceType().isUTF16() && bytesToWrite > 1) {
                                data[bytesToWrite - 2] = 0;
                            }
                        }
                        this.writeByteArray(data, 0, bytesToWrite);
                        break;
                    }
                    this.writeByteArray(data, 0, data.length);
                    for (int numFillBytes = bytesToWrite - data.length; numFillBytes > 0; numFillBytes -= fillLength) {
                        fillLength = numFillBytes;
                        if (fillLength > 256) {
                            fillLength = 256;
                        }
                        Arrays.fill(this.scratchBuffer, 0, fillLength, (byte)0);
                        this.writeByteArray(this.scratchBuffer, 0, fillLength);
                    }
                    break;
                }
                if (fd.getFieldType() == FieldType.VAR_STRING) {
                    this.writeByteArray(data, 0, data.length);
                    if (fd.getFieldType() != FieldType.VAR_STRING) break;
                    byte nullByte = 0;
                    this.buffer.put(nullByte);
                    if (!fd.getSourceType().isUTF16()) break;
                    this.buffer.put(nullByte);
                    break;
                }
                this.writeUnsigned(value == null ? 0L : (long)value.length());
                this.writeByteArray(data);
                break;
            }
            default: {
                throw new Exception("Unsupported type encountered while writing field. This should not happen");
            }
        }
    }

    private long calculateFieldSize(FieldDef fd, IRecordAccessor recordAccessor, Object fieldValue) throws Exception {
        switch (fd.getFieldType()) {
            case SET: 
            case DATASET: {
                boolean isSet;
                List listValue = null;
                if (!(fieldValue instanceof List)) {
                    throw new Exception("Error writing list. Expected List, got: " + fieldValue.getClass().getName());
                }
                listValue = (List)fieldValue;
                long dataLen = 4L;
                boolean bl = isSet = fd.getDef(0).getFieldType() != FieldType.RECORD;
                if (isSet) {
                    ++dataLen;
                }
                for (Object o : listValue) {
                    dataLen += this.calculateFieldSize(fd.getDef(0), recordAccessor, o);
                }
                return dataLen;
            }
            case BINARY: {
                if (fd.isFixed()) {
                    return fd.getDataLen();
                }
                byte[] data = (byte[])fieldValue;
                return data.length + 4;
            }
            case BOOLEAN: {
                return 1L;
            }
            case INTEGER: 
            case FILEPOS: 
            case REAL: 
            case DECIMAL: {
                return fd.getDataLen();
            }
            case CHAR: {
                return 1L;
            }
            case STRING: 
            case VAR_STRING: {
                if (fd.isFixed()) {
                    long dataLen = 0L;
                    if (fd.getSourceType().isUTF16()) {
                        dataLen = fd.getDataLen() * 2L;
                        if (fd.getFieldType() == FieldType.VAR_STRING) {
                            dataLen += 2L;
                        }
                    } else if (fd.getSourceType() == HpccSrcType.SINGLE_BYTE_CHAR) {
                        dataLen = fd.getDataLen();
                        if (fd.getFieldType() == FieldType.VAR_STRING) {
                            ++dataLen;
                        }
                    } else {
                        if (fd.getSourceType() == HpccSrcType.UTF8) {
                            throw new Exception("Fixed length utf8 strings are not supported.");
                        }
                        if (fd.getSourceType() == HpccSrcType.QSTRING) {
                            dataLen = fd.getDataLen();
                        } else {
                            throw new Exception("Unsupported string encoding type: " + (Object)((Object)fd.getSourceType()) + " encountered while writing field: " + fd.getFieldName());
                        }
                    }
                    return dataLen;
                }
                String value = (String)fieldValue;
                byte[] data = null;
                if (fd.getSourceType() == HpccSrcType.UTF16LE) {
                    data = value.getBytes("UTF-16LE");
                } else if (fd.getSourceType() == HpccSrcType.UTF16BE) {
                    data = value.getBytes("UTF-16BE");
                } else if (fd.getSourceType() == HpccSrcType.UTF8) {
                    data = value.getBytes("UTF-8");
                } else if (fd.getSourceType() == HpccSrcType.SINGLE_BYTE_CHAR) {
                    data = value.getBytes("ISO-8859-1");
                } else if (fd.getSourceType() == HpccSrcType.QSTRING) {
                    data = value.getBytes("ISO-8859-1");
                    int compressedDataLen = data.length * 3 + 3;
                    data = new byte[compressedDataLen /= 4];
                } else {
                    throw new Exception("Unsupported string encoding type: " + (Object)((Object)fd.getSourceType()) + " encountered while writing field: " + fd.getFieldName());
                }
                if (fd.getFieldType() == FieldType.STRING) {
                    return data.length + 4;
                }
                int eosLen = 1;
                if (fd.getSourceType().isUTF16()) {
                    ++eosLen;
                }
                return data.length + eosLen;
            }
            case RECORD: {
                recordAccessor.setRecord(fieldValue);
                long dataLen = 0L;
                for (int i = 0; i < recordAccessor.getNumFields(); ++i) {
                    dataLen += this.calculateFieldSize(recordAccessor.getFieldDefinition(i), recordAccessor.getChildRecordAccessor(i), recordAccessor.getFieldValue(i));
                }
                return dataLen;
            }
        }
        throw new Exception("Unsupported type encountered while writing field. This should not happen");
    }

    private void writeList(FieldDef fd, IRecordAccessor childRecordAccessor, List<Object> list) throws Exception {
        boolean isSet;
        boolean bl = isSet = fd.getDef(0).getFieldType() != FieldType.RECORD;
        if (isSet) {
            this.buffer.put((byte)0);
        }
        long dataSetSize = this.calculateFieldSize(fd, childRecordAccessor, list);
        dataSetSize -= 4L;
        if (isSet) {
            --dataSetSize;
        }
        this.writeUnsigned(dataSetSize);
        if (isSet) {
            for (Object value : list) {
                try {
                    this.writeField(fd.getDef(0), value);
                }
                catch (Exception e) {
                    throw new Exception("Error while writing field: " + fd.getFieldName() + " of type: " + fd.getFieldType() + ": ", e);
                }
            }
        } else {
            for (Object value : list) {
                this.writeRecord(childRecordAccessor, value);
            }
        }
    }

    private void writeDecimal(FieldDef fd, BigDecimal decimalValue) {
        boolean isNegative;
        int dataLen = (int)fd.getDataLen();
        for (int i = 0; i < dataLen; ++i) {
            this.scratchBuffer[i] = 0;
        }
        boolean bl = isNegative = decimalValue.signum() == -1;
        if (fd.isUnsigned()) {
            if (isNegative) {
                decimalValue = BigDecimal.ZERO;
            }
        } else if (isNegative) {
            decimalValue = decimalValue.negate();
            int n = dataLen - 1;
            this.scratchBuffer[n] = (byte)(this.scratchBuffer[n] | 0xD);
        } else {
            int n = dataLen - 1;
            this.scratchBuffer[n] = (byte)(this.scratchBuffer[n] | 0xF);
        }
        int desiredPrecision = fd.getPrecision();
        int desiredScale = fd.getScale();
        BigInteger unscaledInt = decimalValue.scaleByPowerOfTen(desiredScale).toBigIntegerExact();
        int signOffset = 4;
        if (fd.isUnsigned()) {
            signOffset = 0;
        }
        BigInteger divisor = BigInteger.valueOf(1000000000000000000L);
        int currentDigit = 0;
        while (currentDigit < desiredPrecision) {
            BigInteger[] quotientRemainder = unscaledInt.divideAndRemainder(divisor);
            unscaledInt = quotientRemainder[0];
            long val = quotientRemainder[1].longValue();
            for (int j = 0; j < 18 && currentDigit < desiredPrecision; ++j, ++currentDigit) {
                int bitOffset = currentDigit * 4 + signOffset;
                int byteOffset = bitOffset / 8;
                int bitShift = bitOffset % 8;
                long digit = val % 10L;
                val /= 10L;
                int n = dataLen - 1 - byteOffset;
                this.scratchBuffer[n] = (byte)((long)this.scratchBuffer[n] | digit << bitShift);
            }
        }
        this.buffer.put(this.scratchBuffer, 0, dataLen);
    }

    private void writeUnsigned(long value) {
        for (int i = 0; i < 4; ++i) {
            int index = i;
            if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                index = 3 - i;
            }
            byte byteValue = (byte)(value >> index * 8 & 0xFFL);
            this.buffer.put(byteValue);
        }
    }

    private void writeByteArray(byte[] data) throws Exception {
        this.writeByteArray(data, 0, data.length);
    }

    private void writeByteArray(byte[] data, int offset, int dataEnd) throws Exception {
        do {
            int writeSize;
            if ((writeSize = dataEnd - offset) > this.buffer.remaining()) {
                writeSize = this.buffer.remaining();
            }
            this.buffer.put(data, offset, writeSize);
            offset += writeSize;
            if (this.buffer.remaining() > 32) continue;
            this.flush();
        } while (offset < dataEnd);
    }
}

