/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldFilterRange;
import org.hpccsystems.commons.ecl.FieldType;

public class CompiledFieldFilter {
    private static final Logger log = LogManager.getLogger(CompiledFieldFilter.class);
    private static final String minStringValue = "";
    private static final String maxStringValue = "\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff";
    private int fieldIndex = -1;
    private FieldType fieldType = FieldType.UNKNOWN;
    private int lowerComparisonType = 0;
    private Object lowerValue = null;
    private int upperComparisonType = 0;
    private Object upperValue = null;
    private int comparisonLength = -1;

    CompiledFieldFilter(int fdIndex, FieldType fdType, FieldFilterRange filter) throws Exception {
        this.fieldIndex = fdIndex;
        this.fieldType = fdType;
        String[] filterValues = filter.getValues();
        if (filterValues.length == 1) {
            this.upperValue = this.lowerValue = CompiledFieldFilter.convertValue(filterValues[0], fdType);
        } else {
            Object[] convertedValues = new Object[filterValues.length];
            for (int i = 0; i < filterValues.length; ++i) {
                convertedValues[i] = CompiledFieldFilter.convertValue(filterValues[i], fdType);
            }
            Arrays.sort(convertedValues, (a, b) -> this.compareValues(a, b));
            this.lowerValue = convertedValues[0];
            this.upperValue = convertedValues[convertedValues.length - 1];
        }
        if (filter.getBound() == FieldFilterRange.Bound.UPPER || filter.getBound() == FieldFilterRange.Bound.NONE) {
            this.lowerValue = CompiledFieldFilter.getMinValueForType(fdType);
        }
        if (filter.getBound() == FieldFilterRange.Bound.LOWER || filter.getBound() == FieldFilterRange.Bound.NONE) {
            this.upperValue = CompiledFieldFilter.getMaxValueForType(fdType);
        }
        if (filter.getLeftOpen()) {
            this.lowerComparisonType = 1;
        }
        if (filter.getRightOpen()) {
            this.upperComparisonType = 1;
        }
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    private int compareValues(Object a, Object b) {
        switch (this.fieldType) {
            case INTEGER: {
                Long la = (Long)a;
                Long lb = (Long)b;
                return la.compareTo(lb);
            }
            case BOOLEAN: {
                Boolean ba = (Boolean)a;
                Boolean bb = (Boolean)b;
                return ba.compareTo(bb);
            }
            case REAL: {
                Double da = (Double)a;
                Double db = (Double)b;
                return da.compareTo(db);
            }
            case DECIMAL: {
                BigDecimal da = (BigDecimal)a;
                BigDecimal db = (BigDecimal)b;
                return da.compareTo(db);
            }
            case STRING: {
                String sa = (String)a;
                String sb = (String)b;
                if (this.comparisonLength < 0) {
                    return sa.compareTo(sb);
                }
                return sa.substring(0, this.comparisonLength).compareTo(sb.substring(0, this.comparisonLength));
            }
        }
        log.error("Invalid key field type: " + this.fieldType + " in comparison. This should never happen.");
        return 0;
    }

    public static Object getMinValueForType(FieldType type) throws Exception {
        switch (type) {
            case INTEGER: {
                return Long.MIN_VALUE;
            }
            case BOOLEAN: {
                return false;
            }
            case REAL: {
                return Double.MIN_VALUE;
            }
            case DECIMAL: {
                return BigDecimal.valueOf(Double.MIN_VALUE);
            }
            case STRING: {
                return minStringValue;
            }
        }
        throw new Exception("Invalid field type for index field.");
    }

    public static Object getMaxValueForType(FieldType type) throws Exception {
        switch (type) {
            case INTEGER: {
                return Long.MAX_VALUE;
            }
            case BOOLEAN: {
                return true;
            }
            case REAL: {
                return Double.MAX_VALUE;
            }
            case DECIMAL: {
                return BigDecimal.valueOf(Double.MAX_VALUE);
            }
            case STRING: {
                return maxStringValue;
            }
        }
        throw new Exception("Invalid field type for index field.");
    }

    public static Object convertValue(String value, FieldType type) throws Exception {
        switch (type) {
            case INTEGER: {
                return Long.valueOf(value);
            }
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case REAL: {
                return Double.valueOf(value);
            }
            case DECIMAL: {
                return BigDecimal.valueOf(Double.valueOf(value));
            }
            case STRING: {
                String unquotedStr = value;
                if (unquotedStr.length() >= 2) {
                    int startIndex = 0;
                    int endIndex = unquotedStr.length();
                    if (unquotedStr.charAt(0) == '\'') {
                        startIndex = 1;
                    }
                    if (unquotedStr.charAt(unquotedStr.length() - 1) == '\'') {
                        endIndex = unquotedStr.length() - 1;
                    }
                    unquotedStr = unquotedStr.substring(startIndex, endIndex);
                }
                return unquotedStr.replaceAll("\\s+$", minStringValue);
            }
        }
        throw new Exception("Invalid field type for index field.");
    }

    public boolean matchesRange(Object inclusiveBegin, Object exclusiveEnd) {
        int beginCompare = this.compareValues(this.lowerValue, inclusiveBegin);
        int endCompare = this.compareValues(exclusiveEnd, this.lowerValue);
        if (beginCompare >= this.lowerComparisonType && endCompare > 0) {
            return true;
        }
        beginCompare = this.compareValues(this.upperValue, inclusiveBegin);
        endCompare = this.compareValues(exclusiveEnd, this.upperValue);
        return beginCompare >= this.upperComparisonType && endCompare > 0;
    }

    public String toString() {
        return "'" + this.fieldIndex + "': <> " + (this.lowerComparisonType == 0 ? "[" : "(") + this.lowerValue + ", " + this.upperValue + (this.upperComparisonType == 0 ? "]" : ")");
    }
}

